/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AnvilMenu;
import org.bukkit.Location;
import org.bukkit.craftbukkit.inventory.CraftResultInventory;
import org.bukkit.inventory.AnvilInventory;

public class CraftInventoryAnvil
extends CraftResultInventory
implements AnvilInventory {
    private final Location location;
    public final AnvilMenu container;

    public CraftInventoryAnvil(Location location, Container inventory, Container resultInventory, AnvilMenu container) {
        super(inventory, resultInventory);
        this.location = location;
        this.container = container;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String getRenameText() {
        return this.container.itemName;
    }

    public int getRepairCostAmount() {
        return this.container.repairItemCountCost;
    }

    public void setRepairCostAmount(int amount) {
        this.container.repairItemCountCost = amount;
    }

    public int getRepairCost() {
        return this.container.cost.get();
    }

    public void setRepairCost(int i) {
        this.container.cost.set(i);
    }

    public int getMaximumRepairCost() {
        return this.container.maximumRepairCost;
    }

    public void setMaximumRepairCost(int levels) {
        Preconditions.checkArgument((levels >= 0 ? 1 : 0) != 0, (Object)"Maximum repair cost must be positive (or 0)");
        this.container.maximumRepairCost = levels;
    }

    public boolean canBypassCost() {
        return this.container.bypassCost;
    }

    public void setBypassCost(boolean bypassCost) {
        this.container.bypassCost = bypassCost;
    }

    public boolean canDoUnsafeEnchants() {
        return this.container.canDoUnsafeEnchants;
    }

    public void setDoUnsafeEnchants(boolean canDoUnsafeEnchants) {
        this.container.canDoUnsafeEnchants = canDoUnsafeEnchants;
    }
}

