/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Random;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.inventory.CraftMetaArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.inventory.CraftMetaColorableArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.inventory.CraftMetaMusicInstrument;
import org.bukkit.craftbukkit.inventory.CraftMetaOminousBottle;
import org.bukkit.craftbukkit.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.craftbukkit.inventory.components.CraftFoodComponent;
import org.bukkit.craftbukkit.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.util.CraftLegacy;
import org.bukkit.craftbukkit.util.RandomSourceWrapper;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public final class CraftItemFactory
implements ItemFactory {
    static final Color DEFAULT_LEATHER_COLOR = Color.fromRGB((int)10511680);
    private static final CraftItemFactory instance;
    private static final RandomSource randomSource;

    private CraftItemFactory() {
    }

    public boolean isApplicable(ItemMeta meta, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return this.isApplicable(meta, itemstack.getType());
    }

    public boolean isApplicable(ItemMeta meta, Material type) {
        if ((type = CraftLegacy.fromLegacy(type)) == null || meta == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(meta instanceof CraftMetaItem), (String)"Meta of %s not created by %s", (Object)meta.getClass().toString(), (Object)CraftItemFactory.class.getName());
        return ((CraftMetaItem)meta).applicableTo(type);
    }

    public ItemMeta getItemMeta(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.getItemMeta(material, null);
    }

    private ItemMeta getItemMeta(Material material, CraftMetaItem meta) {
        material = CraftLegacy.fromLegacy(material);
        switch (material) {
            case AIR: {
                return null;
            }
            case WRITTEN_BOOK: {
                return meta instanceof CraftMetaBookSigned ? meta : new CraftMetaBookSigned(meta);
            }
            case WRITABLE_BOOK: {
                return meta != null && meta.getClass().equals(CraftMetaBook.class) ? meta : new CraftMetaBook(meta);
            }
            case CREEPER_HEAD: 
            case CREEPER_WALL_HEAD: 
            case DRAGON_HEAD: 
            case DRAGON_WALL_HEAD: 
            case PIGLIN_HEAD: 
            case PIGLIN_WALL_HEAD: 
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: 
            case SKELETON_SKULL: 
            case SKELETON_WALL_SKULL: 
            case WITHER_SKELETON_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: 
            case ZOMBIE_HEAD: 
            case ZOMBIE_WALL_HEAD: {
                return meta instanceof CraftMetaSkull ? meta : new CraftMetaSkull(meta);
            }
            case CHAINMAIL_HELMET: 
            case CHAINMAIL_CHESTPLATE: 
            case CHAINMAIL_LEGGINGS: 
            case CHAINMAIL_BOOTS: 
            case DIAMOND_HELMET: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_LEGGINGS: 
            case DIAMOND_BOOTS: 
            case GOLDEN_HELMET: 
            case GOLDEN_CHESTPLATE: 
            case GOLDEN_LEGGINGS: 
            case GOLDEN_BOOTS: 
            case IRON_HELMET: 
            case IRON_CHESTPLATE: 
            case IRON_LEGGINGS: 
            case IRON_BOOTS: 
            case NETHERITE_HELMET: 
            case NETHERITE_CHESTPLATE: 
            case NETHERITE_LEGGINGS: 
            case NETHERITE_BOOTS: 
            case TURTLE_HELMET: {
                return meta != null && meta.getClass().equals(CraftMetaArmor.class) ? meta : new CraftMetaArmor(meta);
            }
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: 
            case WOLF_ARMOR: {
                return meta instanceof CraftMetaColorableArmor ? meta : new CraftMetaColorableArmor(meta);
            }
            case LEATHER_HORSE_ARMOR: {
                return meta instanceof CraftMetaLeatherArmor ? meta : new CraftMetaLeatherArmor(meta);
            }
            case POTION: 
            case SPLASH_POTION: 
            case LINGERING_POTION: 
            case TIPPED_ARROW: {
                return meta instanceof CraftMetaPotion ? meta : new CraftMetaPotion(meta);
            }
            case FILLED_MAP: {
                return meta instanceof CraftMetaMap ? meta : new CraftMetaMap(meta);
            }
            case FIREWORK_ROCKET: {
                return meta instanceof CraftMetaFirework ? meta : new CraftMetaFirework(meta);
            }
            case FIREWORK_STAR: {
                return meta instanceof CraftMetaCharge ? meta : new CraftMetaCharge(meta);
            }
            case ENCHANTED_BOOK: {
                return meta instanceof CraftMetaEnchantedBook ? meta : new CraftMetaEnchantedBook(meta);
            }
            case BLACK_BANNER: 
            case BLACK_WALL_BANNER: 
            case BLUE_BANNER: 
            case BLUE_WALL_BANNER: 
            case BROWN_BANNER: 
            case BROWN_WALL_BANNER: 
            case CYAN_BANNER: 
            case CYAN_WALL_BANNER: 
            case GRAY_BANNER: 
            case GRAY_WALL_BANNER: 
            case GREEN_BANNER: 
            case GREEN_WALL_BANNER: 
            case LIGHT_BLUE_BANNER: 
            case LIGHT_BLUE_WALL_BANNER: 
            case LIGHT_GRAY_BANNER: 
            case LIGHT_GRAY_WALL_BANNER: 
            case LIME_BANNER: 
            case LIME_WALL_BANNER: 
            case MAGENTA_BANNER: 
            case MAGENTA_WALL_BANNER: 
            case ORANGE_BANNER: 
            case ORANGE_WALL_BANNER: 
            case PINK_BANNER: 
            case PINK_WALL_BANNER: 
            case PURPLE_BANNER: 
            case PURPLE_WALL_BANNER: 
            case RED_BANNER: 
            case RED_WALL_BANNER: 
            case WHITE_BANNER: 
            case WHITE_WALL_BANNER: 
            case YELLOW_BANNER: 
            case YELLOW_WALL_BANNER: {
                return meta instanceof CraftMetaBanner ? meta : new CraftMetaBanner(meta);
            }
            case ARMADILLO_SPAWN_EGG: 
            case ALLAY_SPAWN_EGG: 
            case AXOLOTL_SPAWN_EGG: 
            case BAT_SPAWN_EGG: 
            case BEE_SPAWN_EGG: 
            case BLAZE_SPAWN_EGG: 
            case BOGGED_SPAWN_EGG: 
            case BREEZE_SPAWN_EGG: 
            case CAT_SPAWN_EGG: 
            case CAMEL_SPAWN_EGG: 
            case CAVE_SPIDER_SPAWN_EGG: 
            case CHICKEN_SPAWN_EGG: 
            case COD_SPAWN_EGG: 
            case COW_SPAWN_EGG: 
            case CREEPER_SPAWN_EGG: 
            case DOLPHIN_SPAWN_EGG: 
            case DONKEY_SPAWN_EGG: 
            case DROWNED_SPAWN_EGG: 
            case ELDER_GUARDIAN_SPAWN_EGG: 
            case ENDER_DRAGON_SPAWN_EGG: 
            case ENDERMAN_SPAWN_EGG: 
            case ENDERMITE_SPAWN_EGG: 
            case EVOKER_SPAWN_EGG: 
            case FOX_SPAWN_EGG: 
            case FROG_SPAWN_EGG: 
            case GHAST_SPAWN_EGG: 
            case GLOW_SQUID_SPAWN_EGG: 
            case GOAT_SPAWN_EGG: 
            case GUARDIAN_SPAWN_EGG: 
            case HOGLIN_SPAWN_EGG: 
            case HORSE_SPAWN_EGG: 
            case HUSK_SPAWN_EGG: 
            case IRON_GOLEM_SPAWN_EGG: 
            case LLAMA_SPAWN_EGG: 
            case MAGMA_CUBE_SPAWN_EGG: 
            case MOOSHROOM_SPAWN_EGG: 
            case MULE_SPAWN_EGG: 
            case OCELOT_SPAWN_EGG: 
            case PANDA_SPAWN_EGG: 
            case PARROT_SPAWN_EGG: 
            case PHANTOM_SPAWN_EGG: 
            case PIGLIN_BRUTE_SPAWN_EGG: 
            case PIGLIN_SPAWN_EGG: 
            case PIG_SPAWN_EGG: 
            case PILLAGER_SPAWN_EGG: 
            case POLAR_BEAR_SPAWN_EGG: 
            case PUFFERFISH_SPAWN_EGG: 
            case RABBIT_SPAWN_EGG: 
            case RAVAGER_SPAWN_EGG: 
            case SALMON_SPAWN_EGG: 
            case SHEEP_SPAWN_EGG: 
            case SHULKER_SPAWN_EGG: 
            case SILVERFISH_SPAWN_EGG: 
            case SKELETON_HORSE_SPAWN_EGG: 
            case SKELETON_SPAWN_EGG: 
            case SLIME_SPAWN_EGG: 
            case SNIFFER_SPAWN_EGG: 
            case SNOW_GOLEM_SPAWN_EGG: 
            case SPIDER_SPAWN_EGG: 
            case SQUID_SPAWN_EGG: 
            case STRAY_SPAWN_EGG: 
            case STRIDER_SPAWN_EGG: 
            case TADPOLE_SPAWN_EGG: 
            case TRADER_LLAMA_SPAWN_EGG: 
            case TROPICAL_FISH_SPAWN_EGG: 
            case TURTLE_SPAWN_EGG: 
            case VEX_SPAWN_EGG: 
            case VILLAGER_SPAWN_EGG: 
            case VINDICATOR_SPAWN_EGG: 
            case WANDERING_TRADER_SPAWN_EGG: 
            case WARDEN_SPAWN_EGG: 
            case WITCH_SPAWN_EGG: 
            case WITHER_SKELETON_SPAWN_EGG: 
            case WITHER_SPAWN_EGG: 
            case WOLF_SPAWN_EGG: 
            case ZOGLIN_SPAWN_EGG: 
            case ZOMBIE_HORSE_SPAWN_EGG: 
            case ZOMBIE_SPAWN_EGG: 
            case ZOMBIE_VILLAGER_SPAWN_EGG: 
            case ZOMBIFIED_PIGLIN_SPAWN_EGG: {
                return meta instanceof CraftMetaSpawnEgg ? meta : new CraftMetaSpawnEgg(meta);
            }
            case ARMOR_STAND: {
                return meta instanceof CraftMetaArmorStand ? meta : new CraftMetaArmorStand(meta);
            }
            case KNOWLEDGE_BOOK: {
                return meta instanceof CraftMetaKnowledgeBook ? meta : new CraftMetaKnowledgeBook(meta);
            }
            case FURNACE: 
            case CHEST: 
            case TRAPPED_CHEST: 
            case JUKEBOX: 
            case DISPENSER: 
            case DROPPER: 
            case ACACIA_HANGING_SIGN: 
            case ACACIA_SIGN: 
            case ACACIA_WALL_HANGING_SIGN: 
            case ACACIA_WALL_SIGN: 
            case BAMBOO_HANGING_SIGN: 
            case BAMBOO_SIGN: 
            case BAMBOO_WALL_HANGING_SIGN: 
            case BAMBOO_WALL_SIGN: 
            case BIRCH_HANGING_SIGN: 
            case BIRCH_SIGN: 
            case BIRCH_WALL_HANGING_SIGN: 
            case BIRCH_WALL_SIGN: 
            case CHERRY_HANGING_SIGN: 
            case CHERRY_SIGN: 
            case CHERRY_WALL_HANGING_SIGN: 
            case CHERRY_WALL_SIGN: 
            case CRIMSON_HANGING_SIGN: 
            case CRIMSON_SIGN: 
            case CRIMSON_WALL_HANGING_SIGN: 
            case CRIMSON_WALL_SIGN: 
            case DARK_OAK_HANGING_SIGN: 
            case DARK_OAK_SIGN: 
            case DARK_OAK_WALL_HANGING_SIGN: 
            case DARK_OAK_WALL_SIGN: 
            case JUNGLE_HANGING_SIGN: 
            case JUNGLE_SIGN: 
            case JUNGLE_WALL_HANGING_SIGN: 
            case JUNGLE_WALL_SIGN: 
            case MANGROVE_HANGING_SIGN: 
            case MANGROVE_SIGN: 
            case MANGROVE_WALL_HANGING_SIGN: 
            case MANGROVE_WALL_SIGN: 
            case OAK_HANGING_SIGN: 
            case OAK_SIGN: 
            case OAK_WALL_HANGING_SIGN: 
            case OAK_WALL_SIGN: 
            case SPRUCE_HANGING_SIGN: 
            case SPRUCE_SIGN: 
            case SPRUCE_WALL_HANGING_SIGN: 
            case SPRUCE_WALL_SIGN: 
            case WARPED_HANGING_SIGN: 
            case WARPED_SIGN: 
            case WARPED_WALL_HANGING_SIGN: 
            case WARPED_WALL_SIGN: 
            case SPAWNER: 
            case BREWING_STAND: 
            case ENCHANTING_TABLE: 
            case COMMAND_BLOCK: 
            case REPEATING_COMMAND_BLOCK: 
            case CHAIN_COMMAND_BLOCK: 
            case BEACON: 
            case DAYLIGHT_DETECTOR: 
            case HOPPER: 
            case COMPARATOR: 
            case SHIELD: 
            case STRUCTURE_BLOCK: 
            case SHULKER_BOX: 
            case WHITE_SHULKER_BOX: 
            case ORANGE_SHULKER_BOX: 
            case MAGENTA_SHULKER_BOX: 
            case LIGHT_BLUE_SHULKER_BOX: 
            case YELLOW_SHULKER_BOX: 
            case LIME_SHULKER_BOX: 
            case PINK_SHULKER_BOX: 
            case GRAY_SHULKER_BOX: 
            case LIGHT_GRAY_SHULKER_BOX: 
            case CYAN_SHULKER_BOX: 
            case PURPLE_SHULKER_BOX: 
            case BLUE_SHULKER_BOX: 
            case BROWN_SHULKER_BOX: 
            case GREEN_SHULKER_BOX: 
            case RED_SHULKER_BOX: 
            case BLACK_SHULKER_BOX: 
            case ENDER_CHEST: 
            case BARREL: 
            case BELL: 
            case BLAST_FURNACE: 
            case CAMPFIRE: 
            case SOUL_CAMPFIRE: 
            case JIGSAW: 
            case LECTERN: 
            case SMOKER: 
            case BEEHIVE: 
            case BEE_NEST: 
            case SCULK_CATALYST: 
            case SCULK_SHRIEKER: 
            case SCULK_SENSOR: 
            case CALIBRATED_SCULK_SENSOR: 
            case CHISELED_BOOKSHELF: 
            case DECORATED_POT: 
            case SUSPICIOUS_SAND: 
            case SUSPICIOUS_GRAVEL: 
            case CRAFTER: 
            case TRIAL_SPAWNER: 
            case VAULT: {
                return new CraftMetaBlockState(meta, material);
            }
            case TROPICAL_FISH_BUCKET: {
                return meta instanceof CraftMetaTropicalFishBucket ? meta : new CraftMetaTropicalFishBucket(meta);
            }
            case AXOLOTL_BUCKET: {
                return meta instanceof CraftMetaAxolotlBucket ? meta : new CraftMetaAxolotlBucket(meta);
            }
            case CROSSBOW: {
                return meta instanceof CraftMetaCrossbow ? meta : new CraftMetaCrossbow(meta);
            }
            case SUSPICIOUS_STEW: {
                return meta instanceof CraftMetaSuspiciousStew ? meta : new CraftMetaSuspiciousStew(meta);
            }
            case COD_BUCKET: 
            case PUFFERFISH_BUCKET: 
            case SALMON_BUCKET: 
            case TADPOLE_BUCKET: 
            case ITEM_FRAME: 
            case GLOW_ITEM_FRAME: 
            case PAINTING: {
                return meta instanceof CraftMetaEntityTag ? meta : new CraftMetaEntityTag(meta);
            }
            case COMPASS: {
                return meta instanceof CraftMetaCompass ? meta : new CraftMetaCompass(meta);
            }
            case BUNDLE: {
                return meta instanceof CraftMetaBundle ? meta : new CraftMetaBundle(meta);
            }
            case GOAT_HORN: {
                return meta instanceof CraftMetaMusicInstrument ? meta : new CraftMetaMusicInstrument(meta);
            }
            case OMINOUS_BOTTLE: {
                return meta instanceof CraftMetaOminousBottle ? meta : new CraftMetaOminousBottle(meta);
            }
        }
        return new CraftMetaItem(meta);
    }

    public boolean equals(ItemMeta meta1, ItemMeta meta2) {
        if (meta1 == meta2) {
            return true;
        }
        if (meta1 == null) {
            return ((CraftMetaItem)meta2).isEmpty();
        }
        Preconditions.checkArgument((boolean)(meta1 instanceof CraftMetaItem), (String)"First meta of %s does not belong to %s", (Object)meta1.getClass().getName(), (Object)CraftItemFactory.class.getName());
        if (meta2 == null) {
            return ((CraftMetaItem)meta1).isEmpty();
        }
        Preconditions.checkArgument((boolean)(meta2 instanceof CraftMetaItem), (String)"Second meta of %s does not belong to %s", (Object)meta2.getClass().getName(), (Object)CraftItemFactory.class.getName());
        return this.equals((CraftMetaItem)meta1, (CraftMetaItem)meta2);
    }

    boolean equals(CraftMetaItem meta1, CraftMetaItem meta2) {
        return meta1.equalsCommon(meta2) && meta1.notUncommon(meta2) && meta2.notUncommon(meta1);
    }

    public static CraftItemFactory instance() {
        return instance;
    }

    public ItemMeta asMetaFor(ItemMeta meta, ItemStack stack) {
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"ItemStack stack cannot be null");
        return this.asMetaFor(meta, stack.getType());
    }

    public ItemMeta asMetaFor(ItemMeta meta, Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)(meta instanceof CraftMetaItem), (String)"ItemMeta of %s not created by %s", (Object)(meta != null ? meta.getClass().toString() : "null"), (Object)CraftItemFactory.class.getName());
        return this.getItemMeta(material, (CraftMetaItem)meta);
    }

    public Color getDefaultLeatherColor() {
        return DEFAULT_LEATHER_COLOR;
    }

    public ItemStack createItemStack(String input) throws IllegalArgumentException {
        try {
            ItemParser.ItemResult arg = new ItemParser(MinecraftServer.getDefaultRegistryAccess()).parse(new StringReader(input));
            Item item = arg.item().value();
            net.minecraft.world.item.ItemStack nmsItemStack = new net.minecraft.world.item.ItemStack(item);
            DataComponentMap nbt = arg.components();
            if (nbt != null) {
                nmsItemStack.applyComponents(nbt);
            }
            return CraftItemStack.asCraftMirror(nmsItemStack);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse ItemStack: " + input, ex);
        }
    }

    public Material getSpawnEgg(EntityType type) {
        if (type == EntityType.UNKNOWN) {
            return null;
        }
        net.minecraft.world.entity.EntityType<?> nmsType = CraftEntityType.bukkitToMinecraft(type);
        SpawnEggItem nmsItem = SpawnEggItem.byId(nmsType);
        if (nmsItem == null) {
            return null;
        }
        return CraftItemType.minecraftToBukkit(nmsItem);
    }

    public ItemStack enchantItem(org.bukkit.entity.Entity entity, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"The entity must not be null");
        return CraftItemFactory.enchantItem(((CraftEntity)entity).getHandle().random, itemStack, level, allowTreasures);
    }

    public ItemStack enchantItem(World world, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"The world must not be null");
        return CraftItemFactory.enchantItem(((CraftWorld)world).getHandle().random, itemStack, level, allowTreasures);
    }

    public ItemStack enchantItem(ItemStack itemStack, int level, boolean allowTreasures) {
        return CraftItemFactory.enchantItem(randomSource, itemStack, level, allowTreasures);
    }

    private static ItemStack enchantItem(RandomSource source, ItemStack itemStack, int level, boolean allowTreasures) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"ItemStack must not be null");
        Preconditions.checkArgument((!itemStack.getType().isAir() ? 1 : 0) != 0, (Object)"ItemStack must not be air");
        itemStack = CraftItemStack.asCraftCopy(itemStack);
        CraftItemStack craft = (CraftItemStack)itemStack;
        return CraftItemStack.asCraftMirror(EnchantmentHelper.enchantItem(MinecraftServer.getServer().getWorldData().enabledFeatures(), source, craft.handle, level, allowTreasures));
    }

    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(ItemStack item, UnaryOperator<HoverEvent.ShowItem> op) {
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.showItem((Keyed)item.getType().getKey(), (int)item.getAmount(), PaperAdventure.asAdventure(CraftItemStack.unwrap(item).getComponentsPatch())))));
    }

    public @NotNull Component displayName(@NotNull ItemStack itemStack) {
        return PaperAdventure.asAdventure(CraftItemStack.asNMSCopy(itemStack).getDisplayName());
    }

    public ItemStack ensureServerConversions(ItemStack item) {
        return CraftItemStack.asCraftMirror(CraftItemStack.asNMSCopy(item));
    }

    public String getI18NDisplayName(ItemStack item) {
        net.minecraft.world.item.ItemStack nms = null;
        if (item instanceof CraftItemStack) {
            nms = ((CraftItemStack)item).handle;
        }
        if (nms == null) {
            nms = CraftItemStack.asNMSCopy(item);
        }
        return nms != null ? Language.getInstance().getOrDefault(nms.getItem().getDescriptionId(nms)) : null;
    }

    public Content hoverContentOf(ItemStack itemStack) {
        throw new UnsupportedOperationException("BungeeCord Chat API does not support data components");
    }

    public Content hoverContentOf(org.bukkit.entity.Entity entity) {
        return this.hoverContentOf(entity, (BaseComponent)(StringUtils.isBlank((CharSequence)entity.getCustomName()) ? null : new TextComponent(entity.getCustomName())));
    }

    public Content hoverContentOf(org.bukkit.entity.Entity entity, String customName) {
        return this.hoverContentOf(entity, (BaseComponent)(StringUtils.isBlank((CharSequence)customName) ? null : new TextComponent(customName)));
    }

    public Content hoverContentOf(org.bukkit.entity.Entity entity, BaseComponent customName) {
        return new Entity(entity.getType().getKey().toString(), entity.getUniqueId().toString(), customName);
    }

    public Content hoverContentOf(org.bukkit.entity.Entity entity, BaseComponent[] customName) {
        return new Entity(entity.getType().getKey().toString(), entity.getUniqueId().toString(), (BaseComponent)new TextComponent(customName));
    }

    @Deprecated
    public ItemStack getSpawnEgg0(EntityType type) {
        if (type == null) {
            return null;
        }
        String typeId = type.getKey().toString();
        ResourceLocation typeKey = new ResourceLocation(typeId);
        net.minecraft.world.entity.EntityType<?> nmsType = BuiltInRegistries.ENTITY_TYPE.get(typeKey);
        SpawnEggItem eggItem = SpawnEggItem.byId(nmsType);
        return eggItem == null ? null : new net.minecraft.world.item.ItemStack(eggItem).asBukkitMirror();
    }

    public ItemStack enchantWithLevels(ItemStack itemStack, int levels, boolean allowTreasure, Random random) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Argument 'itemStack' must not be null");
        Preconditions.checkArgument((itemStack.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Argument 'itemStack' must not be of type AIR");
        Preconditions.checkArgument((itemStack.getAmount() > 0 ? 1 : 0) != 0, (Object)"Argument 'itemStack' amount must be greater than 0");
        Preconditions.checkArgument((levels > 0 && levels <= 30 ? 1 : 0) != 0, (Object)("Argument 'levels' must be in range [1, 30] (attempted " + levels + ")"));
        Preconditions.checkArgument((random != null ? 1 : 0) != 0, (Object)"Argument 'random' must not be null");
        net.minecraft.world.item.ItemStack internalStack = CraftItemStack.asNMSCopy(itemStack);
        if (internalStack.isEnchanted()) {
            internalStack.set(DataComponents.ENCHANTMENTS, null);
        }
        net.minecraft.world.item.ItemStack enchanted = EnchantmentHelper.enchantItem(MinecraftServer.getServer().getWorldData().enabledFeatures(), new RandomSourceWrapper(random), internalStack, levels, allowTreasure);
        return CraftItemStack.asCraftMirror(enchanted);
    }

    static {
        randomSource = RandomSource.create();
        instance = new CraftItemFactory();
        ConfigurationSerialization.registerClass(SerializableMeta.class);
        ConfigurationSerialization.registerClass(CraftFoodComponent.class);
        ConfigurationSerialization.registerClass(CraftFoodComponent.CraftFoodEffect.class);
        ConfigurationSerialization.registerClass(CraftToolComponent.class);
        ConfigurationSerialization.registerClass(CraftToolComponent.CraftToolRule.class);
    }
}

