/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import org.bukkit.Material;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public Ingredient toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        return CraftRecipe.toIngredient(bukkit, requireNotEmpty);
    }

    public static Ingredient toIngredient(RecipeChoice bukkit, boolean requireNotEmpty) {
        Ingredient stack;
        if (bukkit == null) {
            stack = Ingredient.EMPTY;
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = new Ingredient(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> new Ingredient.ItemValue(CraftItemStack.asNMSCopy(new ItemStack(mat)))));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = new Ingredient(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> new Ingredient.ItemValue(CraftItemStack.asNMSCopy(mat))));
            stack.exact = true;
            stack.predicate = ((RecipeChoice.ExactChoice)bukkit).getPredicate();
        } else if (bukkit == RecipeChoice.empty()) {
            stack = Ingredient.EMPTY;
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + String.valueOf(bukkit));
        }
        stack.getItems();
        if (requireNotEmpty) {
            Preconditions.checkArgument((stack.itemStacks.length != 0 ? 1 : 0) != 0, (Object)"Recipe requires at least one non-air choice");
        }
        return stack;
    }

    public static RecipeChoice toBukkit(Ingredient list) {
        list.getItems();
        if (list.itemStacks.length == 0) {
            return RecipeChoice.empty();
        }
        if (list.exact) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.itemStacks.length);
            for (net.minecraft.world.item.ItemStack i : list.itemStacks) {
                choices.add(CraftItemStack.asBukkitCopy(i));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        ArrayList<Material> choices = new ArrayList<Material>(list.itemStacks.length);
        for (net.minecraft.world.item.ItemStack i : list.itemStacks) {
            choices.add(CraftItemType.minecraftToBukkit(i.getItem()));
        }
        return new RecipeChoice.MaterialChoice(choices);
    }

    public static CraftingBookCategory getCategory(org.bukkit.inventory.recipe.CraftingBookCategory bukkit) {
        return CraftingBookCategory.valueOf(bukkit.name());
    }

    public static org.bukkit.inventory.recipe.CraftingBookCategory getCategory(CraftingBookCategory nms) {
        return org.bukkit.inventory.recipe.CraftingBookCategory.valueOf((String)nms.name());
    }

    public static net.minecraft.world.item.crafting.CookingBookCategory getCategory(CookingBookCategory bukkit) {
        return net.minecraft.world.item.crafting.CookingBookCategory.valueOf(bukkit.name());
    }

    public static CookingBookCategory getCategory(net.minecraft.world.item.crafting.CookingBookCategory nms) {
        return CookingBookCategory.valueOf((String)nms.name());
    }
}

