/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.inventory.CraftMetaArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.inventory.CraftMetaColorableArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.inventory.CraftMetaMusicInstrument;
import org.bukkit.craftbukkit.inventory.CraftMetaOminousBottle;
import org.bukkit.craftbukkit.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.inventory.meta.ItemMeta;

@SerializableAs(value="ItemMeta")
public final class SerializableMeta
implements ConfigurationSerializable {
    static final String TYPE_FIELD = "meta-type";
    static final ImmutableMap<Class<? extends CraftMetaItem>, String> classMap = ImmutableMap.builder().put(CraftMetaArmor.class, (Object)"ARMOR").put(CraftMetaArmorStand.class, (Object)"ARMOR_STAND").put(CraftMetaBanner.class, (Object)"BANNER").put(CraftMetaBlockState.class, (Object)"TILE_ENTITY").put(CraftMetaBook.class, (Object)"BOOK").put(CraftMetaBookSigned.class, (Object)"BOOK_SIGNED").put(CraftMetaSkull.class, (Object)"SKULL").put(CraftMetaLeatherArmor.class, (Object)"LEATHER_ARMOR").put(CraftMetaColorableArmor.class, (Object)"COLORABLE_ARMOR").put(CraftMetaMap.class, (Object)"MAP").put(CraftMetaPotion.class, (Object)"POTION").put(CraftMetaSpawnEgg.class, (Object)"SPAWN_EGG").put(CraftMetaEnchantedBook.class, (Object)"ENCHANTED").put(CraftMetaFirework.class, (Object)"FIREWORK").put(CraftMetaCharge.class, (Object)"FIREWORK_EFFECT").put(CraftMetaKnowledgeBook.class, (Object)"KNOWLEDGE_BOOK").put(CraftMetaTropicalFishBucket.class, (Object)"TROPICAL_FISH_BUCKET").put(CraftMetaAxolotlBucket.class, (Object)"AXOLOTL_BUCKET").put(CraftMetaCrossbow.class, (Object)"CROSSBOW").put(CraftMetaSuspiciousStew.class, (Object)"SUSPICIOUS_STEW").put(CraftMetaEntityTag.class, (Object)"ENTITY_TAG").put(CraftMetaCompass.class, (Object)"COMPASS").put(CraftMetaBundle.class, (Object)"BUNDLE").put(CraftMetaMusicInstrument.class, (Object)"MUSIC_INSTRUMENT").put(CraftMetaOminousBottle.class, (Object)"OMINOUS_BOTTLE").put(CraftMetaItem.class, (Object)"UNSPECIFIC").build();
    static final ImmutableMap<String, Constructor<? extends CraftMetaItem>> constructorMap;

    private SerializableMeta() {
    }

    public static ItemMeta deserialize(Map<String, Object> map) throws Throwable {
        Preconditions.checkArgument((map != null ? 1 : 0) != 0, (Object)"Cannot deserialize null map");
        String type = SerializableMeta.getString(map, TYPE_FIELD, false);
        Constructor constructor = (Constructor)constructorMap.get((Object)type);
        if (constructor == null) {
            throw new IllegalArgumentException(type + " is not a valid meta-type");
        }
        try {
            return (ItemMeta)constructor.newInstance(map);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public Map<String, Object> serialize() {
        throw new AssertionError();
    }

    public static String getString(Map<?, ?> map, Object field, boolean nullable) {
        return SerializableMeta.getObject(String.class, map, field, nullable);
    }

    public static boolean getBoolean(Map<?, ?> map, Object field) {
        Boolean value = SerializableMeta.getObject(Boolean.class, map, field, true);
        return value != null && value != false;
    }

    public static <T> T getObject(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
        Object object = map.get(field);
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        if ((clazz == Float.class || clazz == Double.class) && Number.class.isInstance(object)) {
            Number number = (Number)Number.class.cast(object);
            if (clazz == Float.class) {
                return clazz.cast(Float.valueOf(number.floatValue()));
            }
            return clazz.cast(number.doubleValue());
        }
        if (object == null) {
            if (!nullable) {
                throw new NoSuchElementException(String.valueOf(map) + " does not contain " + String.valueOf(field));
            }
            return null;
        }
        throw new IllegalArgumentException(String.valueOf(field) + "(" + String.valueOf(object) + ") is not a valid " + String.valueOf(clazz));
    }

    public static <T> Optional<T> getObjectOptionally(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
        Object object = map.get(field);
        if (clazz.isInstance(object)) {
            return Optional.of(clazz.cast(object));
        }
        if (object == null) {
            if (!nullable) {
                throw new NoSuchElementException(String.valueOf(map) + " does not contain " + String.valueOf(field));
            }
            return Optional.empty();
        }
        throw new IllegalArgumentException(String.valueOf(field) + "(" + String.valueOf(object) + ") is not a valid " + String.valueOf(clazz));
    }

    static {
        ImmutableMap.Builder classConstructorBuilder = ImmutableMap.builder();
        for (Map.Entry mapping : classMap.entrySet()) {
            try {
                classConstructorBuilder.put((Object)((String)mapping.getValue()), ((Class)mapping.getKey()).getDeclaredConstructor(Map.class));
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        constructorMap = classConstructorBuilder.build();
    }
}

