/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.controller;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.purpurmc.purpur.controller.MoveControllerWASD;

public class FlyingMoveControllerWASD
extends MoveControllerWASD {
    protected final float groundSpeedModifier;
    protected final float flyingSpeedModifier;
    protected int tooHighCooldown = 0;
    protected boolean setNoGravityFlag;

    public FlyingMoveControllerWASD(Mob entity) {
        this(entity, 1.0f);
    }

    public FlyingMoveControllerWASD(Mob entity, float groundSpeedModifier) {
        this(entity, groundSpeedModifier, 1.0f, true);
    }

    public FlyingMoveControllerWASD(Mob entity, float groundSpeedModifier, float flyingSpeedModifier) {
        this(entity, groundSpeedModifier, flyingSpeedModifier, true);
    }

    public FlyingMoveControllerWASD(Mob entity, float groundSpeedModifier, float flyingSpeedModifier, boolean setNoGravityFlag) {
        super(entity);
        this.groundSpeedModifier = groundSpeedModifier;
        this.flyingSpeedModifier = flyingSpeedModifier;
        this.setNoGravityFlag = setNoGravityFlag;
    }

    @Override
    public void purpurTick(Player rider) {
        float forward = Math.max(0.0f, rider.getForwardMot());
        float vertical = forward == 0.0f ? 0.0f : -(rider.xRotO / 45.0f);
        float strafe = rider.getStrafeMot();
        if (rider.jumping && FlyingMoveControllerWASD.spacebarEvent(this.entity)) {
            this.entity.onSpacebar();
        }
        if (this.entity.getY() >= this.entity.getMaxY() || --this.tooHighCooldown > 0) {
            if (this.tooHighCooldown <= 0) {
                this.tooHighCooldown = 20;
            }
            this.entity.setDeltaMovement(this.entity.getDeltaMovement().add(0.0, -0.05, 0.0));
            vertical = 0.0f;
        }
        this.setSpeedModifier(this.entity.getAttributeValue(Attributes.MOVEMENT_SPEED));
        float speed = (float)this.getSpeedModifier();
        speed = this.entity.onGround ? (speed *= this.groundSpeedModifier) : (speed *= this.flyingSpeedModifier);
        if (this.setNoGravityFlag) {
            this.entity.setNoGravity(forward > 0.0f);
        }
        this.entity.setSpeed(speed);
        this.entity.setVerticalMot(vertical);
        this.entity.setStrafeMot(strafe);
        this.entity.setForwardMot(forward);
        this.setForward(this.entity.getForwardMot());
        this.setStrafe(this.entity.getStrafeMot());
    }
}

