/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.item.ItemEntity;
import org.spigotmc.SpigotWorldConfig;

public class TrackingRange {
    public static int getEntityTrackingRange(Entity entity, int defaultRange) {
        if (defaultRange == 0) {
            return defaultRange;
        }
        SpigotWorldConfig config = entity.level().spigotConfig;
        if (entity instanceof ServerPlayer) {
            return config.playerTrackingRange;
        }
        switch (entity.activationType) {
            case RAIDER: 
            case MONSTER: 
            case FLYING_MONSTER: {
                return config.monsterTrackingRange;
            }
            case WATER: 
            case VILLAGER: 
            case ANIMAL: {
                return config.animalTrackingRange;
            }
        }
        if (entity instanceof ItemFrame || entity instanceof Painting || entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
            return config.miscTrackingRange;
        }
        if (entity instanceof Display) {
            return config.displayTrackingRange;
        }
        if (entity instanceof EnderDragon) {
            return ((ServerLevel)entity.getCommandSenderWorld()).getChunkSource().chunkMap.serverViewDistance;
        }
        return config.otherTrackingRange;
    }

    public static TrackingRangeType getTrackingRangeType(Entity entity) {
        if (entity instanceof EnderDragon) {
            return TrackingRangeType.ENDERDRAGON;
        }
        if (entity instanceof ServerPlayer) {
            return TrackingRangeType.PLAYER;
        }
        switch (entity.activationType) {
            case RAIDER: 
            case MONSTER: 
            case FLYING_MONSTER: {
                return TrackingRangeType.MONSTER;
            }
            case WATER: 
            case VILLAGER: 
            case ANIMAL: {
                return TrackingRangeType.ANIMAL;
            }
        }
        if (entity instanceof ItemFrame || entity instanceof Painting || entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
            return TrackingRangeType.MISC;
        }
        if (entity instanceof Display) {
            return TrackingRangeType.DISPLAY;
        }
        return TrackingRangeType.OTHER;
    }

    public static enum TrackingRangeType {
        PLAYER,
        ANIMAL,
        MONSTER,
        MISC,
        OTHER,
        ENDERDRAGON,
        DISPLAY;

    }
}

