/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.reflectionrewriter;

import io.papermc.asm.ClassInfo;
import io.papermc.asm.ClassInfoProvider;
import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.method.MethodRewriteRule;
import io.papermc.asm.util.DescriptorUtils;
import io.papermc.asm.util.OpcodeUtils;
import java.lang.constant.MethodTypeDesc;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DefineClassRule
implements MethodRewriteRule {
    private static final Set<String> CLASS_LOADER_DESCS = Set.of("([BII)Ljava/lang/Class;", "(Ljava/lang/String;[BII)Ljava/lang/Class;", "(Ljava/lang/String;[BIILjava/security/ProtectionDomain;)Ljava/lang/Class;", "(Ljava/lang/String;Ljava/nio/ByteBuffer;Ljava/security/ProtectionDomain;)Ljava/lang/Class;");
    private static final Set<String> SECURE_CLASS_LOADER_DESCS = Set.of("(Ljava/lang/String;Ljava/nio/ByteBuffer;Ljava/security/CodeSource;)Ljava/lang/Class;", "(Ljava/lang/String;[BIILjava/security/CodeSource;)Ljava/lang/Class;");
    private final String proxy;
    private final boolean assumeClassLoader;

    private DefineClassRule(String proxyClassName, boolean assumeClassLoader) {
        this.proxy = proxyClassName;
        this.assumeClassLoader = assumeClassLoader;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MethodRewriteRule.Rewrite rewrite(ClassProcessingContext context, boolean invokeDynamic, int opcode, String owner, String name, MethodTypeDesc descriptor, boolean isInterface) {
        String superName;
        if (!name.equals("defineClass") || OpcodeUtils.isStatic((int)opcode, (boolean)invokeDynamic)) {
            return null;
        }
        if (owner.equals("java/lang/invoke/MethodHandles$Lookup") && descriptor.descriptorString().equals("([B)Ljava/lang/Class;")) {
            descriptor = descriptor.insertParameterTypes(0, DescriptorUtils.fromOwner((String)"java/lang/invoke/MethodHandles$Lookup"));
            new MethodRewriteRule.RewriteSingle(OpcodeUtils.staticOp((boolean)invokeDynamic), this.proxy, name, descriptor, false);
        }
        if ((superName = context.processingClassSuperClassName()) != null) {
            if (CLASS_LOADER_DESCS.contains(descriptor.descriptorString()) && this.isClassLoader(context.classInfoProvider(), superName) && (owner.equals(context.processingClassName()) || this.isClassLoader(context.classInfoProvider(), owner))) {
                return this.classLoaderRewrite(invokeDynamic, name, descriptor);
            }
            if (SECURE_CLASS_LOADER_DESCS.contains(descriptor.descriptorString()) && this.isSecureClassLoader(context.classInfoProvider(), superName) && (owner.equals(context.processingClassName()) || this.isSecureClassLoader(context.classInfoProvider(), owner))) {
                return this.classLoaderRewrite(invokeDynamic, name, descriptor);
            }
        }
        return null;
    }

    private MethodRewriteRule.Rewrite classLoaderRewrite(boolean invokeDynamic, String name, MethodTypeDesc descriptor) {
        descriptor = descriptor.insertParameterTypes(0, DescriptorUtils.fromOwner((String)"java/lang/Object"));
        return new MethodRewriteRule.RewriteSingle(OpcodeUtils.staticOp((boolean)invokeDynamic), this.proxy, name, descriptor, false);
    }

    private boolean isSecureClassLoader(ClassInfoProvider classInfoProvider, String className) {
        return DefineClassRule.is(classInfoProvider, className, "java/security/SecureClassLoader", this.assumeClassLoader);
    }

    private boolean isClassLoader(ClassInfoProvider classInfoProvider, String className) {
        return DefineClassRule.is(classInfoProvider, className, "java/lang/ClassLoader", this.assumeClassLoader);
    }

    public static RewriteRule create(String proxyClassName) {
        return DefineClassRule.create(proxyClassName, false);
    }

    public static RewriteRule create(String proxyClassName, boolean assumeClassLoader) {
        return new DefineClassRule(proxyClassName, assumeClassLoader);
    }

    private static boolean is(ClassInfoProvider classInfoProvider, String className, String checkForName, boolean assumeClassLoader) {
        if (className.equals(checkForName)) {
            return true;
        }
        @Nullable ClassInfo info = classInfoProvider.info(className);
        if (info != null) {
            @Nullable String superName = info.superClassName();
            if (superName != null) {
                return DefineClassRule.is(classInfoProvider, superName, checkForName, assumeClassLoader);
            }
            return false;
        }
        return assumeClassLoader;
    }
}

