/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.bukkit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import me.lucko.spark.common.platform.PlatformInfo;
import org.bukkit.Server;

public class BukkitPlatformInfo
implements PlatformInfo {
    private final Server server;

    public BukkitPlatformInfo(Server server) {
        this.server = server;
    }

    @Override
    public PlatformInfo.Type getType() {
        return PlatformInfo.Type.SERVER;
    }

    @Override
    public String getName() {
        return "Bukkit";
    }

    @Override
    public String getBrand() {
        return this.server.getName();
    }

    @Override
    public String getVersion() {
        return this.server.getVersion();
    }

    @Override
    public String getMinecraftVersion() {
        try {
            return this.server.getMinecraftVersion();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Class serverClass = this.server.getClass();
            try {
                Field minecraftServerField = serverClass.getDeclaredField("console");
                minecraftServerField.setAccessible(true);
                Object minecraftServer = minecraftServerField.get(this.server);
                Class<?> minecraftServerClass = minecraftServer.getClass();
                Method getVersionMethod = minecraftServerClass.getDeclaredMethod("getVersion", new Class[0]);
                getVersionMethod.setAccessible(true);
                return (String)getVersionMethod.invoke(minecraftServer, new Object[0]);
            }
            catch (Exception exception) {
                return serverClass.getPackage().getName().split("\\.")[3];
            }
        }
    }
}

