/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.bukkit;

import java.util.ArrayList;
import java.util.Objects;
import me.lucko.spark.common.platform.world.AbstractChunkInfo;
import me.lucko.spark.common.platform.world.CountMap;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import org.bukkit.Chunk;
import org.bukkit.GameRule;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitWorldInfoProvider
implements WorldInfoProvider {
    private static final boolean SUPPORTS_PAPER_COUNT_METHODS;
    private static final boolean SUPPORTS_GAMERULES;
    private final Server server;

    public BukkitWorldInfoProvider(Server server) {
        this.server = server;
    }

    @Override
    public WorldInfoProvider.CountsResult pollCounts() {
        int players = this.server.getOnlinePlayers().size();
        int entities = 0;
        int tileEntities = 0;
        int chunks = 0;
        for (World world : this.server.getWorlds()) {
            if (SUPPORTS_PAPER_COUNT_METHODS) {
                entities += world.getEntityCount();
                tileEntities += world.getTileEntityCount();
                chunks += world.getChunkCount();
                continue;
            }
            entities += world.getEntities().size();
            Chunk[] chunksArray = world.getLoadedChunks();
            int nullChunks = 0;
            for (Chunk chunk : chunksArray) {
                if (chunk == null) {
                    ++nullChunks;
                    continue;
                }
                BlockState[] tileEntitiesArray = chunk.getTileEntities();
                tileEntities += tileEntitiesArray != null ? tileEntitiesArray.length : 0;
            }
            chunks += chunksArray.length - nullChunks;
        }
        return new WorldInfoProvider.CountsResult(players, entities, tileEntities, chunks);
    }

    public WorldInfoProvider.ChunksResult<BukkitChunkInfo> pollChunks() {
        WorldInfoProvider.ChunksResult<BukkitChunkInfo> data = new WorldInfoProvider.ChunksResult<BukkitChunkInfo>();
        for (World world : this.server.getWorlds()) {
            Chunk[] chunks = world.getLoadedChunks();
            ArrayList<BukkitChunkInfo> list = new ArrayList<BukkitChunkInfo>(chunks.length);
            for (Chunk chunk : chunks) {
                if (chunk == null) continue;
                list.add(new BukkitChunkInfo(chunk));
            }
            data.put(world.getName(), list);
        }
        return data;
    }

    @Override
    public WorldInfoProvider.GameRulesResult pollGameRules() {
        if (!SUPPORTS_GAMERULES) {
            return null;
        }
        WorldInfoProvider.GameRulesResult data = new WorldInfoProvider.GameRulesResult();
        boolean addDefaults = true;
        for (World world : this.server.getWorlds()) {
            for (String gameRule : world.getGameRules()) {
                GameRule ruleObj = GameRule.getByName((String)gameRule);
                if (ruleObj == null) continue;
                if (addDefaults) {
                    Object defaultValue = world.getGameRuleDefault(ruleObj);
                    data.putDefault(gameRule, Objects.toString(defaultValue));
                }
                Object value = world.getGameRuleValue(ruleObj);
                data.put(gameRule, world.getName(), Objects.toString(value));
            }
            addDefaults = false;
        }
        return data;
    }

    static {
        boolean supportsPaperCountMethods = false;
        try {
            World.class.getMethod("getEntityCount", new Class[0]);
            World.class.getMethod("getTileEntityCount", new Class[0]);
            World.class.getMethod("getChunkCount", new Class[0]);
            supportsPaperCountMethods = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean supportsGameRules = false;
        try {
            Class.forName("org.bukkit.GameRule");
            World.class.getMethod("getGameRuleValue", GameRule.class);
            supportsGameRules = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        SUPPORTS_PAPER_COUNT_METHODS = supportsPaperCountMethods;
        SUPPORTS_GAMERULES = supportsGameRules;
    }

    static final class BukkitChunkInfo
    extends AbstractChunkInfo<EntityType> {
        private final CountMap<EntityType> entityCounts = new CountMap.EnumKeyed<EntityType>(EntityType.class);

        BukkitChunkInfo(Chunk chunk) {
            super(chunk.getX(), chunk.getZ());
            for (Entity entity : chunk.getEntities()) {
                if (entity == null) continue;
                this.entityCounts.increment(entity.getType());
            }
        }

        @Override
        public CountMap<EntityType> getEntityCounts() {
            return this.entityCounts;
        }

        @Override
        public String entityTypeName(EntityType type) {
            return type.getName();
        }
    }
}

