/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.bukkit;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

final class CommandMapUtil
extends Enum<CommandMapUtil> {
    private static final Constructor<PluginCommand> COMMAND_CONSTRUCTOR;
    private static final Field COMMAND_MAP_FIELD;
    private static final Field KNOWN_COMMANDS_FIELD;
    private static final /* synthetic */ CommandMapUtil[] $VALUES;

    public static CommandMapUtil[] values() {
        return (CommandMapUtil[])$VALUES.clone();
    }

    public static CommandMapUtil valueOf(String name) {
        return Enum.valueOf(CommandMapUtil.class, name);
    }

    private static CommandMap getCommandMap() {
        try {
            return (CommandMap)COMMAND_MAP_FIELD.get(Bukkit.getServer().getPluginManager());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get CommandMap", e);
        }
    }

    private static Map<String, Command> getKnownCommandMap(CommandMap commandMap) {
        try {
            return (Map)KNOWN_COMMANDS_FIELD.get(commandMap);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get known commands map", e);
        }
    }

    public static void registerCommand(Plugin plugin, CommandExecutor command, String ... aliases) {
        Preconditions.checkArgument((aliases.length != 0 ? 1 : 0) != 0, (Object)"No aliases");
        CommandMap commandMap = CommandMapUtil.getCommandMap();
        Map<String, Command> knownCommandMap = CommandMapUtil.getKnownCommandMap(commandMap);
        for (String alias : aliases) {
            try {
                PluginCommand cmd = COMMAND_CONSTRUCTOR.newInstance(alias, plugin);
                commandMap.register(plugin.getDescription().getName(), (Command)cmd);
                knownCommandMap.put(plugin.getDescription().getName().toLowerCase() + ":" + alias.toLowerCase(), (Command)cmd);
                knownCommandMap.put(alias.toLowerCase(), (Command)cmd);
                cmd.setLabel(alias.toLowerCase());
                cmd.setExecutor(command);
                if (!(command instanceof TabCompleter)) continue;
                cmd.setTabCompleter((TabCompleter)command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void unregisterCommand(CommandExecutor command) {
        CommandMap commandMap = CommandMapUtil.getCommandMap();
        Map<String, Command> knownCommandMap = CommandMapUtil.getKnownCommandMap(commandMap);
        Iterator<Command> iterator = knownCommandMap.values().iterator();
        while (iterator.hasNext()) {
            CommandExecutor executor;
            Command cmd = iterator.next();
            if (!(cmd instanceof PluginCommand) || command != (executor = ((PluginCommand)cmd).getExecutor())) continue;
            cmd.unregister(commandMap);
            iterator.remove();
        }
    }

    private static /* synthetic */ CommandMapUtil[] $values() {
        return new CommandMapUtil[0];
    }

    static {
        $VALUES = CommandMapUtil.$values();
        try {
            COMMAND_CONSTRUCTOR = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            COMMAND_CONSTRUCTOR.setAccessible(true);
            COMMAND_MAP_FIELD = SimplePluginManager.class.getDeclaredField("commandMap");
            COMMAND_MAP_FIELD.setAccessible(true);
            KNOWN_COMMANDS_FIELD = SimpleCommandMap.class.getDeclaredField("knownCommands");
            KNOWN_COMMANDS_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

