/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.platform.world;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.lucko.spark.common.platform.world.ChunkInfo;

public interface WorldInfoProvider {
    public static final WorldInfoProvider NO_OP = new WorldInfoProvider(){

        @Override
        public CountsResult pollCounts() {
            return null;
        }

        @Override
        public ChunksResult<? extends ChunkInfo<?>> pollChunks() {
            return null;
        }

        @Override
        public GameRulesResult pollGameRules() {
            return null;
        }
    };

    public CountsResult pollCounts();

    public ChunksResult<? extends ChunkInfo<?>> pollChunks();

    public GameRulesResult pollGameRules();

    default public boolean mustCallSync() {
        return true;
    }

    public static final class GameRulesResult {
        private final Map<String, GameRule> rules = new HashMap<String, GameRule>();

        private GameRule rule(String name) {
            return this.rules.computeIfAbsent(name, k -> new GameRule());
        }

        public void put(String gameRuleName, String worldName, String value) {
            this.rule((String)gameRuleName).worldValues.put(worldName, value);
        }

        public void putDefault(String gameRuleName, String value) {
            this.rule((String)gameRuleName).defaultValue = value;
        }

        public Map<String, GameRule> getRules() {
            return this.rules;
        }

        public static final class GameRule {
            Map<String, String> worldValues = new HashMap<String, String>();
            String defaultValue = null;

            public String getDefaultValue() {
                return this.defaultValue;
            }

            public Map<String, String> getWorldValues() {
                return this.worldValues;
            }
        }
    }

    public static final class CountsResult {
        private final int players;
        private final int entities;
        private final int tileEntities;
        private final int chunks;

        public CountsResult(int players, int entities, int tileEntities, int chunks) {
            this.players = players;
            this.entities = entities;
            this.tileEntities = tileEntities;
            this.chunks = chunks;
        }

        public int players() {
            return this.players;
        }

        public int entities() {
            return this.entities;
        }

        public int tileEntities() {
            return this.tileEntities;
        }

        public int chunks() {
            return this.chunks;
        }
    }

    public static final class ChunksResult<T extends ChunkInfo<?>> {
        private final Map<String, List<T>> worlds = new HashMap<String, List<T>>();

        public void put(String worldName, List<T> chunks) {
            this.worlds.put(worldName, chunks);
        }

        public Map<String, List<T>> getWorlds() {
            return this.worlds;
        }
    }
}

