/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.implementation.snakeyaml;

import java.util.LinkedHashMap;
import java.util.Map;
import org.simpleyaml.configuration.serialization.ConfigurationSerialization;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class SnakeYamlConstructor
extends SafeConstructor {
    public SnakeYamlConstructor() {
        this.yamlConstructors.put(Tag.MAP, new ConstructCustomObject());
    }

    @Override
    public void flattenMapping(MappingNode node) {
        super.flattenMapping(node);
    }

    public Object construct(Node node) {
        return super.constructObject(node);
    }

    protected boolean hasSerializedTypeKey(MappingNode node) {
        for (NodeTuple nodeTuple : node.getValue()) {
            String key;
            Node keyNode = nodeTuple.getKeyNode();
            if (!(keyNode instanceof ScalarNode) || !(key = ((ScalarNode)keyNode).getValue()).equals("==")) continue;
            return true;
        }
        return false;
    }

    private final class ConstructCustomObject
    extends SafeConstructor.ConstructYamlMap {
        private ConstructCustomObject() {
            super(SnakeYamlConstructor.this);
        }

        @Override
        public Object construct(Node node) {
            if (node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
            }
            Map raw = (Map)super.construct(node);
            if (!raw.containsKey("==")) {
                return raw;
            }
            LinkedHashMap typed = new LinkedHashMap(raw.size());
            for (Map.Entry entry : raw.entrySet()) {
                typed.put(entry.getKey().toString(), entry.getValue());
            }
            try {
                return ConfigurationSerialization.deserializeObject(typed);
            }
            catch (IllegalArgumentException ex) {
                throw new YAMLException("Could not deserialize object", ex);
            }
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
        }
    }
}

