/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.implementation.snakeyaml;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.comments.CommentType;
import org.simpleyaml.configuration.comments.KeyTree;
import org.simpleyaml.configuration.file.YamlConfigurationOptions;
import org.simpleyaml.configuration.implementation.api.YamlImplementationCommentable;
import org.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlCommentMapper;
import org.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlConstructor;
import org.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlQuoteValue;
import org.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlRepresenter;
import org.simpleyaml.exceptions.InvalidConfigurationException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.AnchorNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;

public class SnakeYamlImplementation
extends YamlImplementationCommentable {
    private SnakeYamlConstructor yamlConstructor;
    private SnakeYamlRepresenter yamlRepresenter;
    private DumperOptions dumperOptions;
    private LoaderOptions loaderOptions;
    private Resolver resolver;
    private Yaml yaml;

    public SnakeYamlImplementation() {
        this(new SnakeYamlRepresenter());
    }

    public SnakeYamlImplementation(SnakeYamlRepresenter yamlRepresenter) {
        this(new SnakeYamlConstructor(), yamlRepresenter, new DumperOptions());
    }

    public SnakeYamlImplementation(SnakeYamlConstructor yamlConstructor, SnakeYamlRepresenter yamlRepresenter, DumperOptions yamlOptions) {
        this.setYaml(yamlConstructor, yamlRepresenter, yamlOptions);
    }

    protected final void setYaml(SnakeYamlConstructor yamlConstructor, SnakeYamlRepresenter yamlRepresenter, DumperOptions yamlOptions) {
        this.setYaml(yamlConstructor, yamlRepresenter, yamlOptions, new LoaderOptions(), new Resolver());
    }

    protected final void setYaml(SnakeYamlConstructor yamlConstructor, SnakeYamlRepresenter yamlRepresenter, DumperOptions dumperOptions, LoaderOptions loaderOptions, Resolver resolver) {
        this.yamlConstructor = yamlConstructor;
        this.yamlRepresenter = yamlRepresenter;
        this.dumperOptions = dumperOptions;
        this.loaderOptions = loaderOptions;
        this.resolver = resolver;
        this.yaml = new Yaml(this.yamlConstructor, this.yamlRepresenter, this.dumperOptions, this.loaderOptions, this.resolver);
    }

    public Yaml getYaml() {
        return this.yaml;
    }

    public SnakeYamlConstructor getConstructor() {
        return this.yamlConstructor;
    }

    public SnakeYamlRepresenter getRepresenter() {
        return this.yamlRepresenter;
    }

    public DumperOptions getDumperOptions() {
        return this.dumperOptions;
    }

    public LoaderOptions getLoaderOptions() {
        return this.loaderOptions;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public void load(Reader reader, ConfigurationSection section) throws IOException, InvalidConfigurationException {
        this.configure(this.options);
        if (reader != null && section != null) {
            try {
                SnakeYamlCommentMapper yamlCommentMapper = null;
                KeyTree.Node node = null;
                if (this.options.useComments()) {
                    yamlCommentMapper = new SnakeYamlCommentMapper(this.options);
                    this.yamlCommentMapper = yamlCommentMapper;
                    node = yamlCommentMapper.getKeyTree().getRoot();
                }
                MappingNode root = (MappingNode)this.yaml.compose(reader);
                this.trackMapping(root, section, node, yamlCommentMapper);
                if (this.yamlCommentMapper != null) {
                    ((SnakeYamlCommentMapper)this.yamlCommentMapper).trackFooter(root);
                }
            }
            catch (YAMLException e) {
                throw new InvalidConfigurationException(e);
            }
            catch (ClassCastException e) {
                throw new InvalidConfigurationException("Top level is not a Map.");
            }
            finally {
                reader.close();
            }
        }
    }

    @Override
    public void dump(Writer writer, ConfigurationSection section) throws IOException {
        this.configure(this.options);
        if (this.hasContent(writer, section)) {
            try {
                SnakeYamlCommentMapper yamlCommentMapper = null;
                KeyTree.Node node = null;
                if (this.yamlCommentMapper != null && this.options.useComments()) {
                    yamlCommentMapper = (SnakeYamlCommentMapper)this.yamlCommentMapper;
                    node = section.getParent() == null ? yamlCommentMapper.getKeyTree().getRoot() : yamlCommentMapper.getNode(section.getCurrentPath());
                }
                MappingNode mappingNode = this.sectionToMapping(section, node, yamlCommentMapper);
                if (yamlCommentMapper != null) {
                    yamlCommentMapper.setFooter(mappingNode);
                }
                this.yaml.serialize(mappingNode, writer);
            }
            catch (YAMLException e) {
                throw new IOException(e);
            }
            finally {
                writer.close();
            }
        }
    }

    protected void dumpYaml(Writer writer, ConfigurationSection section) throws IOException {
        try {
            this.yaml.dump(section, writer);
        }
        catch (YAMLException e) {
            throw new IOException(e);
        }
    }

    protected boolean hasContent(Writer writer, ConfigurationSection section) throws IOException {
        if (writer == null) {
            return false;
        }
        boolean empty = false;
        if (section == null) {
            empty = true;
        } else if (section.isEmpty()) {
            ConfigurationSection defaultsSection = section.getDefaultSection();
            boolean bl = empty = defaultsSection == null || defaultsSection.isEmpty();
        }
        if (empty) {
            writer.write("");
        }
        return !empty;
    }

    @Override
    public void configure(YamlConfigurationOptions options) {
        super.configure(options);
        this.dumperOptions.setAllowUnicode(options.isUnicode());
        this.dumperOptions.setIndent(options.indent());
        this.dumperOptions.setIndicatorIndent(options.indentList());
        this.dumperOptions.setIndentWithIndicator(true);
        this.dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultScalarStyle(SnakeYamlQuoteValue.getQuoteScalarStyle(options.quoteStyleDefaults().getDefaultQuoteStyle()));
        boolean useComments = options.useComments();
        this.loaderOptions.setProcessComments(useComments);
        this.dumperOptions.setProcessComments(useComments);
    }

    @Override
    public void setComment(String path, String comment, CommentType type) {
        if (this.yamlCommentMapper == null) {
            this.options.useComments(true);
            this.yamlCommentMapper = new SnakeYamlCommentMapper(this.options);
        }
        this.yamlCommentMapper.setComment(path, comment, type);
    }

    protected void trackMapping(MappingNode node, ConfigurationSection section, KeyTree.Node parent, SnakeYamlCommentMapper yamlCommentMapper) {
        if (node != null) {
            this.yamlConstructor.flattenMapping(node);
            boolean useComments = yamlCommentMapper != null;
            for (NodeTuple nodeTuple : node.getValue()) {
                Node key = nodeTuple.getKeyNode();
                Node value = SnakeYamlImplementation.resolveAnchor(nodeTuple.getValueNode());
                String name = this.getName(key, true);
                boolean isSerializable = value instanceof MappingNode && this.yamlConstructor.hasSerializedTypeKey((MappingNode)value);
                KeyTree.Node childNode = null;
                if (useComments) {
                    childNode = yamlCommentMapper.track(parent, name, key, value);
                    if (value instanceof SequenceNode) {
                        this.trackSequence((SequenceNode)value, childNode, yamlCommentMapper);
                    } else if (isSerializable) {
                        this.trackMapping((MappingNode)value, null, childNode, yamlCommentMapper);
                    }
                }
                if (section == null) continue;
                if (value instanceof MappingNode && !isSerializable) {
                    this.trackMapping((MappingNode)value, section.createSection(name), childNode, yamlCommentMapper);
                    continue;
                }
                section.set(name, this.yamlConstructor.construct(value));
            }
            if (useComments) {
                yamlCommentMapper.clearCurrentNodeIfNoComments();
            }
        }
    }

    protected void trackSequence(SequenceNode node, KeyTree.Node parent, SnakeYamlCommentMapper yamlCommentMapper) {
        int i = 0;
        for (Node element : node.getValue()) {
            element = SnakeYamlImplementation.resolveAnchor(element);
            KeyTree.Node elementNode = yamlCommentMapper.trackElement(parent, this.getName(element, false), element, i);
            if (element instanceof SequenceNode) {
                this.trackSequence((SequenceNode)element, elementNode, yamlCommentMapper);
            } else if (element instanceof MappingNode) {
                this.trackMapping((MappingNode)element, null, elementNode, yamlCommentMapper);
            }
            ++i;
        }
    }

    protected MappingNode sectionToMapping(ConfigurationSection section, KeyTree.Node node, SnakeYamlCommentMapper yamlCommentMapper) {
        ArrayList<NodeTuple> nodes = new ArrayList<NodeTuple>();
        boolean useComments = yamlCommentMapper != null && node != null;
        for (Map.Entry<String, Object> entry : section.getValues(false).entrySet()) {
            Node value;
            KeyTree.Node childNode;
            Node key = this.yamlRepresenter.represent(entry.getKey());
            if (entry.getValue() instanceof ConfigurationSection) {
                ConfigurationSection childSection = (ConfigurationSection)entry.getValue();
                childNode = useComments ? node.getPriority(childSection.getName()) : null;
                value = this.sectionToMapping(childSection, childNode, yamlCommentMapper);
            } else {
                value = this.yamlRepresenter.represent(entry.getValue());
            }
            if (useComments) {
                String name = this.getName(key, true);
                childNode = node.getPriority(name);
                yamlCommentMapper.setComments(childNode, key, value);
                if (value instanceof SequenceNode) {
                    this.setCommentsSequence((SequenceNode)value, childNode, yamlCommentMapper);
                } else if (value instanceof MappingNode) {
                    this.setCommentsMapping((MappingNode)value, childNode, yamlCommentMapper);
                }
            }
            nodes.add(new NodeTuple(key, value));
        }
        return new MappingNode(Tag.MAP, nodes, this.dumperOptions.getDefaultFlowStyle());
    }

    protected void setCommentsSequence(SequenceNode sequence, KeyTree.Node node, SnakeYamlCommentMapper yamlCommentMapper) {
        if (node != null && node.isList()) {
            int i = 0;
            for (Node element : sequence.getValue()) {
                String name;
                element = SnakeYamlImplementation.resolveAnchor(element);
                KeyTree.Node elementNode = node.getElement(i);
                if (elementNode == null && (name = this.getName(element, false)) != null) {
                    elementNode = node.getPriority(name);
                }
                yamlCommentMapper.setComments(elementNode, element, null);
                if (element instanceof SequenceNode) {
                    this.setCommentsSequence((SequenceNode)element, elementNode, yamlCommentMapper);
                } else if (element instanceof MappingNode) {
                    this.setCommentsMapping((MappingNode)element, elementNode, yamlCommentMapper);
                }
                ++i;
            }
        }
    }

    protected void setCommentsMapping(MappingNode mapping, KeyTree.Node node, SnakeYamlCommentMapper yamlCommentMapper) {
        if (node != null) {
            this.yamlConstructor.flattenMapping(mapping);
            for (NodeTuple nodeTuple : mapping.getValue()) {
                Node key = nodeTuple.getKeyNode();
                Node value = SnakeYamlImplementation.resolveAnchor(nodeTuple.getValueNode());
                String name = this.getName(key, true);
                KeyTree.Node childNode = node.getPriority(name);
                yamlCommentMapper.setComments(childNode, key, value);
                if (value instanceof SequenceNode) {
                    this.setCommentsSequence((SequenceNode)value, childNode, yamlCommentMapper);
                    continue;
                }
                if (!(value instanceof MappingNode)) continue;
                this.setCommentsMapping((MappingNode)value, childNode, yamlCommentMapper);
            }
        }
    }

    protected String getName(Node node, boolean key) {
        String name = null;
        Object value = this.yamlConstructor.construct(node);
        if (key || value instanceof String || value instanceof Number || value instanceof Boolean) {
            name = String.valueOf(value);
        }
        return name;
    }

    protected static Node resolveAnchor(Node node) {
        while (node instanceof AnchorNode) {
            node = ((AnchorNode)node).getRealNode();
        }
        return node;
    }
}

