/*
 * Decompiled with CFR 0.152.
 */
package co.technove.flare.collectors;

import co.technove.flare.internal.FlareInternal;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ThreadState
implements Runnable {
    private final Map<Thread, ThreadValues> activeThreads = new WeakHashMap<Thread, ThreadValues>();

    public void start(FlareInternal flare) {
        flare.getIntervalManager().schedule(this, Duration.ofSeconds(1L));
    }

    public synchronized void stop() {
        this.activeThreads.clear();
    }

    @Override
    public synchronized void run() {
        Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stacks.entrySet()) {
            StackTraceElement head;
            StackTraceElement[] stack = entry.getValue();
            boolean active = stack.length > 0 ? !((head = stack[0]).getClassName().equals("jdk.internal.misc.Unsafe") && head.getMethodName().equals("park") || head.getClassName().equals("java.lang.Object") && head.getMethodName().equals("wait") || head.getClassName().equals("java.lang.Thread") && head.getMethodName().equals("sleep") || head.getClassName().equals("io.netty.channel.epoll.Native") && head.getMethodName().equals("epollWait") || head.getClassName().equals("java.lang.ref.Reference") && head.getMethodName().equals("waitForReferencePendingList") || head.getClassName().equals("java.io.FileInputStream") || head.getMethodName().equals("read0")) : false;
            Thread thread = entry.getKey();
            ThreadValues values = this.activeThreads.get(thread);
            if (values == null) {
                values = new ThreadValues();
                this.activeThreads.put(thread, values);
            }
            values.history <<= 1;
            values.history = values.history | (active ? 1L : 0L);
        }
        this.activeThreads.keySet().retainAll(stacks.keySet());
    }

    public synchronized Set<Thread> getActiveThreads() {
        HashSet<Thread> set = new HashSet<Thread>();
        for (Map.Entry<Thread, ThreadValues> entry : this.activeThreads.entrySet()) {
            if (!entry.getValue().isActive()) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    private static class ThreadValues {
        private long history = 0L;

        private ThreadValues() {
        }

        public boolean isActive() {
            return this.history != 0L;
        }
    }
}

