/*
 * Decompiled with CFR 0.152.
 */
package co.technove.flare.internal.profiling;

import co.technove.flare.internal.FlareInternal;
import co.technove.flare.internal.profiling.InitializationException;
import co.technove.flare.internal.profiling.ProfileSection;
import co.technove.flare.internal.profiling.ProfileType;
import co.technove.flare.internal.profiling.dictionary.JavaMethod;
import co.technove.flare.internal.profiling.dictionary.ProfileDictionary;
import co.technove.flare.internal.profiling.dictionary.TypeValue;
import co.technove.flare.proto.ProfilerFileProto;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import one.jfr.Dictionary;
import one.jfr.JfrReader;
import one.jfr.StackTrace;
import one.jfr.event.Event;
import one.jfr.event.EventAggregator;
import one.profiler.AsyncProfiler;

public class AsyncProfilerIntegration {
    private static final int ALLOC_INTERVAL = 8192;
    private static boolean initialized = false;
    private static boolean profiling = false;
    private static AsyncProfiler profiler;
    private static Path tempdir;
    private static String profileFile;
    private static long interval;

    public static List<String> init() throws InitializationException {
        Path flare;
        if (initialized) {
            throw new InitializationException("Integration has already been initialized");
        }
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Linux")) {
            throw new InitializationException("Flare does not support the operating system " + osName);
        }
        osName = "linux";
        String path = osName + "-" + System.getProperty("os.arch") + "/libasyncProfiler.so";
        try {
            flare = Files.createTempDirectory("flare", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new InitializationException("Could not create temporary directory", e);
        }
        Path tmp = flare.resolve("libasycProfiler.so");
        try (InputStream resource = AsyncProfilerIntegration.class.getClassLoader().getResourceAsStream(path);){
            if (resource == null) {
                throw new InitializationException("Failed to find " + path + " inside JAR, is this operating system supported?");
            }
            Files.copy(resource, tmp, new CopyOption[0]);
            tmp.toFile().deleteOnExit();
            flare.toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw new InitializationException(e);
        }
        if (!Files.exists(tmp, new LinkOption[0])) {
            throw new InitializationException("Failed to copy out libasyncProfiler.so");
        }
        ArrayList<String> warnings = new ArrayList<String>();
        String[] required = new String[]{"-XX:+UnlockDiagnosticVMOptions", "-XX:+DebugNonSafepoints"};
        List arguments = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().map(String::toLowerCase).collect(Collectors.toList());
        for (String s : required) {
            if (arguments.contains(s.toLowerCase())) continue;
            warnings.add("For optimal profiles, the following flags are missing: -XX:+UnlockDiagnosticVMOptions -XX:+DebugNonSafepoints");
            break;
        }
        profiler = AsyncProfiler.getInstance(tmp.toAbsolutePath().toString());
        initialized = true;
        boolean supportsProfilingMemory = false;
        try {
            supportsProfilingMemory = profiler.execute("check,alloc").trim().equals("OK");
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
        if (!supportsProfilingMemory) {
            warnings.add("Failed to find JVM debug symbols, allocation profiling will be disabled.");
        }
        return warnings;
    }

    private static String execute(String command) throws IOException {
        String val = profiler.execute(command);
        return val;
    }

    static synchronized void startProfiling(FlareInternal flare) throws IOException {
        if (profiling) {
            throw new RuntimeException("Profiling already started.");
        }
        interval = flare.getInterval().toMillis();
        tempdir = Files.createTempDirectory("flare", new FileAttribute[0]);
        profileFile = tempdir.resolve("flare.jfr").toString();
        boolean supportsProfilingMemory = false;
        try {
            supportsProfilingMemory = profiler.execute("check,alloc").trim().equals("OK");
        }
        catch (IOException | IllegalStateException exception) {
            // empty catch block
        }
        String alloc = supportsProfilingMemory && flare.isProfilingMemory() ? "alloc=8192," : "";
        String returned = AsyncProfilerIntegration.execute("start,event=" + flare.getProfileType().getInternalName() + "," + alloc + "interval=" + interval + "ms,threads,filter,jstackdepth=1024,jfr,file=" + profileFile);
        for (Thread activeThread : flare.getThreadState().getActiveThreads()) {
            profiler.addThread(activeThread);
        }
        if (!(returned.contains("Started ") && returned.contains(" profiling") || returned.contains("Profiling started"))) {
            throw new IOException("Failed to start flare: " + returned.trim());
        }
        profiling = true;
    }

    private static FinalProfileData getProfileData(FlareInternal flare, JfrReader reader, ProfileType type) {
        Event event2;
        HashMap<String, ProfileSection> threadsMap = new HashMap<String, ProfileSection>();
        Dictionary methodNames = new Dictionary();
        EventAggregator agg = new EventAggregator(true, true);
        int totalSamples = 0;
        while ((event2 = reader.readEvent(type.getEventClass())) != null) {
            agg.collect(event2);
            ++totalSamples;
        }
        agg.forEach((event, value, samples) -> {
            StackTrace stackTrace = reader.stackTraces.get(event.stackTraceId);
            if (stackTrace == null) {
                return;
            }
            long[] methods = stackTrace.methods;
            byte[] types = stackTrace.types;
            String thread = reader.threads.get(event.tid);
            if (thread.startsWith("[tid=")) {
                return;
            }
            ProfileSection section = null;
            for (int i = methods.length - 1; i >= 0; --i) {
                TypeValue method = JavaMethod.getMethodName(methods[i], types[i], reader, methodNames);
                section = section == null ? threadsMap.computeIfAbsent(thread, t -> new ProfileSection(flare, method)) : section.getSection(method);
            }
            if (section != null) {
                section.setSamples(Math.toIntExact(samples));
                section.setTimeTakenNs(type == ProfileType.ALLOC ? value : value * interval);
            }
        });
        reader.resetRead();
        return new FinalProfileData(threadsMap, totalSamples);
    }

    static synchronized Optional<ProfilerFileProto.AirplaneProfileFile.Builder> stopProfiling(FlareInternal flare, ProfileDictionary dictionary) {
        if (!profiling) {
            return Optional.empty();
        }
        try {
            profiler.stop();
        }
        catch (Throwable t) {
            profiling = false;
            throw t;
        }
        try {
            Optional<ProfilerFileProto.AirplaneProfileFile.Builder> optional;
            JfrReader reader = new JfrReader(profileFile);
            try {
                FinalProfileData cpuData = AsyncProfilerIntegration.getProfileData(flare, reader, flare.getProfileType());
                FinalProfileData allocData = AsyncProfilerIntegration.getProfileData(flare, reader, ProfileType.ALLOC);
                optional = Optional.of(ProfilerFileProto.AirplaneProfileFile.newBuilder().setInfo((ProfilerFileProto.AirplaneProfileFile.ProfileInfo)ProfilerFileProto.AirplaneProfileFile.ProfileInfo.newBuilder().setSamples(Math.max(cpuData.samples, allocData.samples)).setTimeMs(reader.durationNanos / 1000000L).build()).setData(ProfilerFileProto.AirplaneProfileFile.ProfileData.newBuilder().setMemoryProfile(ProfilerFileProto.MemoryProfile.newBuilder())).setV2(ProfilerFileProto.AirplaneProfileFile.V2Data.newBuilder().addAllTimeProfile(cpuData.threads.entrySet().stream().map(entry -> (ProfilerFileProto.TimeProfileV2)ProfilerFileProto.TimeProfileV2.newBuilder().setThread((String)entry.getKey()).setTime(((ProfileSection)entry.getValue()).calculateTimeTaken()).setSamples(cpuData.samples).addAllChildren(((ProfileSection)entry.getValue()).toTimeChild(dictionary).getChildrenList()).build()).collect(Collectors.toList())).addAllMemoryProfile(allocData.threads.entrySet().stream().map(entry -> (ProfilerFileProto.MemoryProfileV2)ProfilerFileProto.MemoryProfileV2.newBuilder().setThread((String)entry.getKey()).setBytes(((ProfileSection)entry.getValue()).calculateTimeTaken()).addAllChildren(((ProfileSection)entry.getValue()).toMemoryProfile(dictionary).getChildrenList()).build()).collect(Collectors.toList())).setDictionary(dictionary.toProto())));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
            return optional;
        }
        finally {
            profiling = false;
            try {
                for (Path path : Files.list(tempdir).collect(Collectors.toList())) {
                    Files.delete(path);
                }
                Files.delete(tempdir);
            }
            catch (IOException iOException) {}
        }
    }

    static {
        tempdir = null;
        profileFile = null;
    }

    private static final class FinalProfileData {
        private final Map<String, ProfileSection> threads;
        private final int samples;

        private FinalProfileData(Map<String, ProfileSection> threads, int samples) {
            this.threads = threads;
            this.samples = samples;
        }
    }
}

