/*
 * Decompiled with CFR 0.152.
 */
package co.technove.flare.internal.profiling;

import co.technove.flare.internal.FlareInternal;
import co.technove.flare.libs.com.google.common.collect.Iterators;
import co.technove.flare.live.Collector;
import co.technove.flare.live.CollectorData;
import co.technove.flare.live.EventCollector;
import co.technove.flare.live.LiveCollector;
import co.technove.flare.live.category.GraphCategory;
import co.technove.flare.live.formatter.DataFormatter;
import co.technove.flare.proto.ProfilerFileProto;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ProtoHelper {
    public static ProfilerFileProto.CreateProfile createProfile(FlareInternal flare, List<EventCollector> eventCollectors, List<LiveCollector> liveCollectors) {
        ArrayList files = new ArrayList();
        flare.getFiles().forEach((key, value) -> files.add((ProfilerFileProto.CreateProfile.ConfigurationFile)ProfilerFileProto.CreateProfile.ConfigurationFile.newBuilder().setFilename((String)key).setContents((String)value).build()));
        HashMap<String, ProfilerFileProto.CreateProfile.TimelineData> timelineData = new HashMap<String, ProfilerFileProto.CreateProfile.TimelineData>();
        HashMap categoryMap = new HashMap();
        Iterator<LiveCollector> it = Iterators.concat(eventCollectors.iterator(), liveCollectors.iterator());
        while (it.hasNext()) {
            Collector collector = it.next();
            for (CollectorData data : collector.getDataTypes()) {
                timelineData.put(data.getId(), (ProfilerFileProto.CreateProfile.TimelineData)ProfilerFileProto.CreateProfile.TimelineData.newBuilder().setName(data.getName()).setDescription(data.getDescription()).setFormat(data.getFormatter().map(DataFormatter::getId).orElse(null)).build());
                data.getGraphCategory().ifPresent(cat -> categoryMap.computeIfAbsent(cat, name -> new HashSet()).add(data.getId()));
            }
        }
        return (ProfilerFileProto.CreateProfile)ProfilerFileProto.CreateProfile.newBuilder().setFormat(ProfilerFileProto.CreateProfile.Format.THREE_ZERO).addAllConfigs(files).setHwinfo(flare.getHardwareInfo()).setVmoptions((ProfilerFileProto.CreateProfile.VMOptions)ProfilerFileProto.CreateProfile.VMOptions.newBuilder().setVersion(System.getProperty("java.version")).setVendor(System.getProperty("java.vendor")).setVm(System.getProperty("java.vm.name")).setRuntimeName(System.getProperty("java.runtime.name")).setRuntimeVersion(System.getProperty("java.runtime.version")).addAllFlags(ManagementFactory.getRuntimeMXBean().getInputArguments()).build()).setOs(flare.getOperatingSystem()).setV3((ProfilerFileProto.CreateProfile.V3)ProfilerFileProto.CreateProfile.V3.newBuilder().putAllVersions(flare.getVersions()).putAllTimelineData(timelineData).addAllGraphCategories(categoryMap.entrySet().stream().map(entry -> (ProfilerFileProto.CreateProfile.GraphCategory)ProfilerFileProto.CreateProfile.GraphCategory.newBuilder().setName(((GraphCategory)entry.getKey()).getName()).addAllTypes((Iterable)entry.getValue()).setDefault(flare.getDefaultCategories().contains(entry.getKey())).build()).collect(Collectors.toList())).build()).build();
    }

    public static ProfilerFileProto.TimelineFile createTimeline(List<EventCollector> eventCollectors, List<LiveCollector> liveCollectors, long startedAt, long stoppedAt) {
        return (ProfilerFileProto.TimelineFile)ProfilerFileProto.TimelineFile.newBuilder().setStartedAt(startedAt).setStoppedAt(stoppedAt).addAllEvents(eventCollectors.stream().map(eventCollector -> eventCollector.getAndCopyEvents().stream().map(event -> (ProfilerFileProto.TimelineFile.EventData)ProfilerFileProto.TimelineFile.EventData.newBuilder().setType(event.getData().getId()).setTime(event.getTime()).setDuration(Math.toIntExact(event.getDuration())).putAllMetadata(event.getMetadata()).build()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).addAllLive(liveCollectors.stream().map(liveCollector -> liveCollector.useDataThenClear(map -> map.entrySet().stream().map(entry -> (ProfilerFileProto.TimelineFile.LiveData)ProfilerFileProto.TimelineFile.LiveData.newBuilder().setType(((CollectorData)entry.getKey()).getId()).addAllData((Iterable)entry.getValue()).build()).collect(Collectors.toList()))).flatMap(Collection::stream).collect(Collectors.toList())).build();
    }
}

