/*
 * Decompiled with CFR 0.152.
 */
package co.technove.flare.internal.profiling.dictionary;

import co.technove.flare.internal.profiling.dictionary.ProfileDictionary;
import co.technove.flare.internal.profiling.dictionary.TypeValue;
import co.technove.flare.proto.ProfilerFileProto;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JavaMethod
extends TypeValue {
    private static final Map<Character, String> PRIMITIVES;
    private final String classString;
    private final String methodStr;
    private final String signatureStr;

    public JavaMethod(TypeValue.JFRMethodType type, String classString, String methodStr, String signatureStr, String fullPath) {
        super(type);
        this.classString = Objects.requireNonNull(classString);
        this.methodStr = Objects.requireNonNull(methodStr);
        this.signatureStr = Objects.requireNonNull(signatureStr);
    }

    public String getClassString() {
        return this.classString;
    }

    public String getRawClass() {
        String className = this.classString;
        if (className.contains("$")) {
            className = className.substring(0, className.indexOf("$"));
        }
        return className;
    }

    public String getMethodStr() {
        return this.methodStr;
    }

    public String getSignatureStr() {
        return this.signatureStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaMethod javaMethod = (JavaMethod)o;
        return Objects.equals(this.classString, javaMethod.classString) && Objects.equals(this.methodStr, javaMethod.methodStr) && Objects.equals(this.signatureStr, javaMethod.signatureStr);
    }

    public int hashCode() {
        return Objects.hash(this.classString, this.methodStr, this.signatureStr);
    }

    public String toString() {
        return this.getMethodType().getPrefix() + this.classString + "." + this.methodStr + this.signatureStr;
    }

    private ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.JavaTypeValue mapType(String unparsed, ProfileDictionary dictionary) {
        if (unparsed.charAt(unparsed.length() - 1) == ';') {
            unparsed = unparsed.substring(0, unparsed.length() - 1);
        }
        int array = 0;
        while (unparsed.charAt(0) == '[') {
            unparsed = unparsed.substring(1);
            ++array;
        }
        char type = unparsed.charAt(0);
        if (PRIMITIVES.containsKey(Character.valueOf(type))) {
            return (ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.JavaTypeValue)ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.JavaTypeValue.newBuilder().setPrimitive(PRIMITIVES.get(Character.valueOf(type))).setArray(array).build();
        }
        if (type == 'L') {
            String[] split = unparsed.substring(1).split("/");
            String className = split[split.length - 1];
            String packageName = split.length > 1 ? String.join((CharSequence)".", Arrays.copyOfRange(split, 0, split.length - 1)) : "";
            return (ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.JavaTypeValue)ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.JavaTypeValue.newBuilder().setJavaClassType((ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.JavaClass)ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.JavaClass.newBuilder().setPackageIndex(dictionary.getOrAddPackage(packageName)).setName(className).build()).setArray(array).build();
        }
        throw new RuntimeException("Unknown type for string: " + unparsed);
    }

    @Override
    public ProfilerFileProto.MethodDictionarySlice.MethodDictionaryEntry getEntry(ProfileDictionary dictionary) {
        ProfilerFileProto.MethodDictionarySlice.MethodDictionaryEntry.Builder builder = ProfilerFileProto.MethodDictionarySlice.MethodDictionaryEntry.newBuilder();
        ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.Builder entry = ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.newBuilder();
        int lambdaIndex = this.classString.indexOf("$$Lambda$");
        String lambdaText = "";
        String classString = this.classString;
        if (lambdaIndex > -1) {
            lambdaText = this.classString.substring(lambdaIndex);
            classString = this.classString.substring(0, lambdaIndex);
        }
        String[] split = classString.split("\\.");
        String className = split[split.length - 1] + lambdaText;
        String packageName = split.length > 1 ? String.join((CharSequence)".", Arrays.copyOfRange(split, 0, split.length - 1)) : "";
        entry.setJavaClass((ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.JavaClass)ProfilerFileProto.MethodDictionarySlice.JavaDictionaryEntry.JavaClass.newBuilder().setPackageIndex(dictionary.getOrAddPackage(packageName)).setName(className).build());
        entry.setMethod(this.methodStr);
        String[] splitSig = this.signatureStr.substring(1).split("\\)");
        List params = Arrays.stream(splitSig[0].split(";")).filter(val -> val.length() > 0).map(type -> {
            try {
                return this.mapType((String)type, dictionary);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse param " + type + " from " + this.signatureStr, e);
            }
        }).collect(Collectors.toList());
        entry.addAllParams(params);
        try {
            entry.setReturnType(this.mapType(splitSig[1], dictionary));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse return " + splitSig[1] + " from " + this.signatureStr, e);
        }
        builder.setJavaEntry(entry);
        return (ProfilerFileProto.MethodDictionarySlice.MethodDictionaryEntry)builder.build();
    }

    static {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('Z'), "boolean");
        map.put(Character.valueOf('B'), "byte");
        map.put(Character.valueOf('C'), "char");
        map.put(Character.valueOf('S'), "short");
        map.put(Character.valueOf('I'), "int");
        map.put(Character.valueOf('J'), "long");
        map.put(Character.valueOf('F'), "float");
        map.put(Character.valueOf('D'), "double");
        map.put(Character.valueOf('V'), "void");
        PRIMITIVES = Collections.unmodifiableMap(map);
    }
}

