/*
 * Decompiled with CFR 0.152.
 */
package co.technove.flare.libs.com.google.common.collect;

import co.technove.flare.libs.com.google.common.annotations.GwtCompatible;
import co.technove.flare.libs.com.google.common.annotations.GwtIncompatible;
import co.technove.flare.libs.com.google.common.collect.ImmutableMap;
import co.technove.flare.libs.com.google.common.collect.ImmutableSet;
import co.technove.flare.libs.com.google.common.collect.IndexedImmutableSet;
import co.technove.flare.libs.com.google.common.collect.UnmodifiableIterator;
import co.technove.flare.libs.org.checkerframework.checker.nullness.compatqual.NullableDecl;
import java.io.Serializable;
import java.util.Map;

@GwtCompatible(emulated=true)
final class ImmutableMapKeySet<K, V>
extends IndexedImmutableSet<K> {
    private final ImmutableMap<K, V> map;

    ImmutableMapKeySet(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return this.map.keyIterator();
    }

    @Override
    public boolean contains(@NullableDecl Object object) {
        return this.map.containsKey(object);
    }

    @Override
    K get(int index) {
        return ((Map.Entry)((ImmutableSet)this.map.entrySet()).asList().get(index)).getKey();
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map);
    }

    @GwtIncompatible
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

