/*
 * Decompiled with CFR 0.152.
 */
package co.technove.flare.live;

import co.technove.flare.Flare;
import co.technove.flare.internal.util.DoubleArrayList;
import co.technove.flare.live.Collector;
import co.technove.flare.live.CollectorData;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class LiveCollector
extends Collector
implements Runnable {
    private final Map<CollectorData, DoubleArrayList> data = new HashMap<CollectorData, DoubleArrayList>();
    protected Duration interval = Duration.ofSeconds(5L);

    public LiveCollector(CollectorData ... data) {
        for (CollectorData datum : data) {
            this.data.put(datum, new DoubleArrayList());
        }
    }

    public Duration getInterval() {
        return this.interval;
    }

    @Override
    public Collection<CollectorData> getDataTypes() {
        return this.data.keySet();
    }

    @Override
    public void start(Flare flare) {
        flare.getIntervalManager().schedule(this, this.interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void report(CollectorData collectorData, double data) {
        Map<CollectorData, DoubleArrayList> map = this.data;
        synchronized (map) {
            Objects.requireNonNull(this.data.get(collectorData)).addDouble(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T useDataThenClear(Function<Map<CollectorData, DoubleArrayList>, T> function) {
        Map<CollectorData, DoubleArrayList> map = this.data;
        synchronized (map) {
            T returned = function.apply(this.data);
            this.data.values().forEach(List::clear);
            return returned;
        }
    }
}

