/*
 * Decompiled with CFR 0.152.
 */
package one.jfr;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.jfr.ClassRef;
import one.jfr.Dictionary;
import one.jfr.Element;
import one.jfr.JfrClass;
import one.jfr.JfrField;
import one.jfr.MethodRef;
import one.jfr.StackTrace;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.ExecutionSample;

public class JfrReader
implements Closeable {
    private static final int CHUNK_HEADER_SIZE = 68;
    private static final int CPOOL_OFFSET = 16;
    private static final int META_OFFSET = 24;
    private final FileChannel ch;
    private final ByteBuffer buf;
    public final long startNanos;
    public final long durationNanos;
    public final long startTicks;
    public final long ticksPerSec;
    public final Dictionary<JfrClass> types = new Dictionary();
    public final Map<String, JfrClass> typesByName = new HashMap<String, JfrClass>();
    public final Dictionary<String> threads = new Dictionary();
    public final Dictionary<ClassRef> classes = new Dictionary();
    public final Dictionary<byte[]> symbols = new Dictionary();
    public final Dictionary<MethodRef> methods = new Dictionary();
    public final Dictionary<StackTrace> stackTraces = new Dictionary();
    public final Map<Integer, String> frameTypes = new HashMap<Integer, String>();
    public final Map<Integer, String> threadStates = new HashMap<Integer, String>();
    private final int executionSample;
    private final int nativeMethodSample;
    private final int allocationInNewTLAB;
    private final int allocationOutsideTLAB;
    private final int monitorEnter;
    private final int threadPark;

    public JfrReader(String fileName) throws IOException {
        this.ch = FileChannel.open(Paths.get(fileName, new String[0]), StandardOpenOption.READ);
        this.buf = this.ch.map(FileChannel.MapMode.READ_ONLY, 0L, this.ch.size());
        if (this.buf.getInt(0) != 1179406848) {
            throw new IOException("Not a valid JFR file");
        }
        int version = this.buf.getInt(4);
        if (version < 131072 || version > 196607) {
            throw new IOException("Unsupported JFR version: " + (version >>> 16) + "." + (version & 0xFFFF));
        }
        this.buf.limit((int)this.buf.getLong(8));
        this.startNanos = this.buf.getLong(32);
        this.durationNanos = this.buf.getLong(40);
        this.startTicks = this.buf.getLong(48);
        this.ticksPerSec = this.buf.getLong(56);
        this.readMeta();
        this.readConstantPool();
        this.executionSample = this.getTypeId("jdk.ExecutionSample");
        this.nativeMethodSample = this.getTypeId("jdk.NativeMethodSample");
        this.allocationInNewTLAB = this.getTypeId("jdk.ObjectAllocationInNewTLAB");
        this.allocationOutsideTLAB = this.getTypeId("jdk.ObjectAllocationOutsideTLAB");
        this.monitorEnter = this.getTypeId("jdk.JavaMonitorEnter");
        this.threadPark = this.getTypeId("jdk.ThreadPark");
        this.buf.position(68);
    }

    public void resetRead() {
        this.buf.position(68);
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    public List<Event> readAllEvents() {
        return this.readAllEvents(null);
    }

    public <E extends Event> List<E> readAllEvents(Class<E> cls) {
        E event;
        ArrayList<E> events = new ArrayList<E>();
        while ((event = this.readEvent(cls)) != null) {
            events.add(event);
        }
        Collections.sort(events);
        return events;
    }

    public Event readEvent() {
        return this.readEvent(null);
    }

    public <E extends Event> E readEvent(Class<E> cls) {
        while (this.buf.hasRemaining()) {
            int position = this.buf.position();
            int size = this.getVarint();
            int type = this.getVarint();
            if (type == this.executionSample || type == this.nativeMethodSample) {
                if (cls == null || cls == ExecutionSample.class) {
                    return (E)this.readExecutionSample();
                }
            } else if (type == this.allocationInNewTLAB) {
                if (cls == null || cls == AllocationSample.class) {
                    return (E)this.readAllocationSample(true);
                }
            } else if (type == this.allocationOutsideTLAB) {
                if (cls == null || cls == AllocationSample.class) {
                    return (E)this.readAllocationSample(false);
                }
            } else if (type == this.monitorEnter) {
                if (cls == null || cls == ContendedLock.class) {
                    return (E)this.readContendedLock(false);
                }
            } else if (type == this.threadPark && (cls == null || cls == ContendedLock.class)) {
                return (E)this.readContendedLock(true);
            }
            this.buf.position(position + size);
        }
        return null;
    }

    private ExecutionSample readExecutionSample() {
        long time = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int threadState = this.getVarint();
        return new ExecutionSample(time, tid, stackTraceId, threadState);
    }

    private AllocationSample readAllocationSample(boolean tlab) {
        long time = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int classId = this.getVarint();
        long allocationSize = this.getVarlong();
        long tlabSize = tlab ? this.getVarlong() : 0L;
        return new AllocationSample(time, tid, stackTraceId, classId, allocationSize, tlabSize);
    }

    private ContendedLock readContendedLock(boolean hasTimeout) {
        long time = this.getVarlong();
        long duration = this.getVarlong();
        int tid = this.getVarint();
        int stackTraceId = this.getVarint();
        int classId = this.getVarint();
        if (hasTimeout) {
            this.getVarlong();
        }
        long address = this.getVarlong();
        return new ContendedLock(time, tid, stackTraceId, duration, classId);
    }

    private void readMeta() {
        this.buf.position(this.buf.getInt(28));
        this.getVarint();
        this.getVarint();
        this.getVarlong();
        this.getVarlong();
        this.getVarlong();
        String[] strings = new String[this.getVarint()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.getString();
        }
        this.readElement(strings);
    }

    private Element readElement(String[] strings) {
        String name = strings[this.getVarint()];
        int attributeCount = this.getVarint();
        HashMap<String, String> attributes = new HashMap<String, String>(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            attributes.put(strings[this.getVarint()], strings[this.getVarint()]);
        }
        Element e = this.createElement(name, attributes);
        int childCount = this.getVarint();
        for (int i = 0; i < childCount; ++i) {
            e.addChild(this.readElement(strings));
        }
        return e;
    }

    private Element createElement(String name, Map<String, String> attributes) {
        switch (name) {
            case "class": {
                JfrClass type = new JfrClass(attributes);
                if (!attributes.containsKey("superType")) {
                    this.types.put(type.id, type);
                }
                this.typesByName.put(type.name, type);
                return type;
            }
            case "field": {
                return new JfrField(attributes);
            }
        }
        return new Element();
    }

    private void readConstantPool() {
        int offset = this.buf.getInt(20);
        while (true) {
            this.buf.position(offset);
            this.getVarint();
            this.getVarint();
            this.getVarlong();
            this.getVarlong();
            long delta = this.getVarlong();
            this.getVarint();
            int poolCount = this.getVarint();
            for (int i = 0; i < poolCount; ++i) {
                int type = this.getVarint();
                this.readConstants(this.types.get(type));
            }
            if (delta == 0L) break;
            offset = (int)((long)offset + delta);
        }
    }

    private void readConstants(JfrClass type) {
        switch (type.name) {
            case "jdk.types.ChunkHeader": {
                this.buf.position(this.buf.position() + 71);
                break;
            }
            case "java.lang.Thread": {
                this.readThreads(type.field("group") != null);
                break;
            }
            case "java.lang.Class": {
                this.readClasses(type.field("hidden") != null);
                break;
            }
            case "jdk.types.Symbol": {
                this.readSymbols();
                break;
            }
            case "jdk.types.Method": {
                this.readMethods();
                break;
            }
            case "jdk.types.StackTrace": {
                this.readStackTraces();
                break;
            }
            case "jdk.types.FrameType": {
                this.readMap(this.frameTypes);
                break;
            }
            case "jdk.types.ThreadState": {
                this.readMap(this.threadStates);
                break;
            }
            default: {
                this.readOtherConstants(type.fields);
            }
        }
    }

    private void readThreads(boolean hasGroup) {
        int count = this.threads.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            String osName = this.getString();
            int osThreadId = this.getVarint();
            String javaName = this.getString();
            long javaThreadId = this.getVarlong();
            if (hasGroup) {
                this.getVarlong();
            }
            this.threads.put(id, javaName != null ? javaName : osName);
        }
    }

    private void readClasses(boolean hasHidden) {
        int count = this.classes.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            long loader = this.getVarlong();
            long name = this.getVarlong();
            long pkg = this.getVarlong();
            int modifiers = this.getVarint();
            if (hasHidden) {
                this.getVarint();
            }
            this.classes.put(id, new ClassRef(name));
        }
    }

    private void readMethods() {
        int count = this.methods.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            long cls = this.getVarlong();
            long name = this.getVarlong();
            long sig = this.getVarlong();
            int modifiers = this.getVarint();
            int hidden = this.getVarint();
            this.methods.put(id, new MethodRef(cls, name, sig));
        }
    }

    private void readStackTraces() {
        int count = this.stackTraces.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            int truncated = this.getVarint();
            StackTrace stackTrace = this.readStackTrace();
            this.stackTraces.put(id, stackTrace);
        }
    }

    private StackTrace readStackTrace() {
        int depth = this.getVarint();
        long[] methods = new long[depth];
        byte[] types = new byte[depth];
        for (int i = 0; i < depth; ++i) {
            methods[i] = this.getVarlong();
            int line = this.getVarint();
            int bci = this.getVarint();
            types[i] = this.buf.get();
        }
        return new StackTrace(methods, types);
    }

    private void readSymbols() {
        int count = this.symbols.preallocate(this.getVarint());
        for (int i = 0; i < count; ++i) {
            long id = this.getVarlong();
            if (this.buf.get() != 3) {
                throw new IllegalArgumentException("Invalid symbol encoding");
            }
            this.symbols.put(id, this.getBytes());
        }
    }

    private void readMap(Map<Integer, String> map) {
        int count = this.getVarint();
        for (int i = 0; i < count; ++i) {
            map.put(this.getVarint(), this.getString());
        }
    }

    private void readOtherConstants(List<JfrField> fields) {
        int stringType = this.getTypeId("java.lang.String");
        boolean[] numeric = new boolean[fields.size()];
        for (int i = 0; i < numeric.length; ++i) {
            JfrField f = fields.get(i);
            numeric[i] = f.constantPool || f.type != stringType;
        }
        int count = this.getVarint();
        for (int i = 0; i < count; ++i) {
            this.getVarlong();
            this.readFields(numeric);
        }
    }

    private void readFields(boolean[] numeric) {
        for (boolean n : numeric) {
            if (n) {
                this.getVarlong();
                continue;
            }
            this.getString();
        }
    }

    private int getTypeId(String typeName) {
        JfrClass type = this.typesByName.get(typeName);
        return type != null ? type.id : -1;
    }

    private int getVarint() {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = this.buf.get();
            result |= (b & 0x7F) << shift;
            if (b >= 0) {
                return result;
            }
            shift += 7;
        }
    }

    private long getVarlong() {
        long result = 0L;
        for (int shift = 0; shift < 56; shift += 7) {
            byte b = this.buf.get();
            result |= ((long)b & 0x7FL) << shift;
            if (b < 0) continue;
            return result;
        }
        return result | ((long)this.buf.get() & 0xFFL) << 56;
    }

    private String getString() {
        switch (this.buf.get()) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
            case 3: {
                return new String(this.getBytes(), StandardCharsets.UTF_8);
            }
            case 4: {
                char[] chars = new char[this.getVarint()];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = (char)this.getVarint();
                }
                return new String(chars);
            }
            case 5: {
                return new String(this.getBytes(), StandardCharsets.ISO_8859_1);
            }
        }
        throw new IllegalArgumentException("Invalid string encoding");
    }

    private byte[] getBytes() {
        byte[] bytes = new byte[this.getVarint()];
        this.buf.get(bytes);
        return bytes;
    }
}

