/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.ComponentUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V3439 {
    private static final int VERSION = 3439;

    public static void register() {
        DataConverter<MapType<String>, MapType<String>> signTileUpdater = new DataConverter<MapType<String>, MapType<String>>(3439){
            private static final String DEFAULT_COLOR = "black";

            private static ListType migrateToList(MapType<String> root, String prefix) {
                if (root == null) {
                    return null;
                }
                ListType ret = root.getTypeUtil().createEmptyList();
                ret.addString(root.getString(prefix.concat("1"), ComponentUtils.EMPTY));
                ret.addString(root.getString(prefix.concat("2"), ComponentUtils.EMPTY));
                ret.addString(root.getString(prefix.concat("3"), ComponentUtils.EMPTY));
                ret.addString(root.getString(prefix.concat("4"), ComponentUtils.EMPTY));
                return ret;
            }

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType<String> frontText = data.getTypeUtil().createEmptyMap();
                data.setMap("front_text", frontText);
                ListType frontMessages = 1.migrateToList(data, "Text");
                frontText.setList("messages", frontMessages);
                ListType frontFilteredMessages = null;
                for (int i2 = 0; i2 < 4; ++i2) {
                    String filtered = data.getString("FilteredText" + i2);
                    if (filtered == null) {
                        if (frontFilteredMessages == null) continue;
                        frontFilteredMessages.addString(frontMessages.getString(i2));
                        continue;
                    }
                    if (frontFilteredMessages == null) {
                        frontFilteredMessages = data.getTypeUtil().createEmptyList();
                        for (int k2 = 0; k2 < i2; ++k2) {
                            frontFilteredMessages.addString(frontMessages.getString(k2));
                        }
                    }
                    frontFilteredMessages.addString(filtered);
                }
                if (frontFilteredMessages != null) {
                    frontText.setList("filtered_messages", frontFilteredMessages);
                }
                frontText.setString("color", data.getString("Color", DEFAULT_COLOR));
                frontText.setBoolean("has_glowing_text", data.getBoolean("GlowingText", false));
                frontText.setBoolean("_filtered_correct", true);
                MapType<String> backText = data.getTypeUtil().createEmptyMap();
                data.setMap("back_text", backText);
                ListType blankMessages = data.getTypeUtil().createEmptyList();
                backText.setList("messages", blankMessages);
                for (int i3 = 0; i3 < 4; ++i3) {
                    blankMessages.addString(ComponentUtils.EMPTY);
                }
                backText.setString("color", DEFAULT_COLOR);
                backText.setBoolean("has_glowing_text", false);
                data.setBoolean("is_waxed", false);
                return null;
            }
        };
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:sign", signTileUpdater);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:hanging_sign", signTileUpdater);
    }
}

