/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.ComponentUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public final class V3564 {
    private static final int VERSION = 3564;

    public static void register() {
        DataConverter<MapType<String>, MapType<String>> converter = new DataConverter<MapType<String>, MapType<String>>(3564){
            private static final String[] LEGACY_FIELDS = new String[]{"Text1", "Text2", "Text3", "Text4", "FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4", "Color", "GlowingText"};

            private static void updateText(MapType<String> text) {
                if (text == null) {
                    return;
                }
                if (text.getBoolean("_filtered_correct", false)) {
                    text.remove("_filtered_correct");
                    return;
                }
                ListType filteredMessages = text.getList("filtered_messages", ObjectType.STRING);
                if (filteredMessages == null || filteredMessages.size() == 0) {
                    return;
                }
                ListType messages = text.getList("messages", ObjectType.STRING);
                ListType newFilteredList = filteredMessages.getTypeUtil().createEmptyList();
                boolean newFilteredIsEmpty = true;
                int len = filteredMessages.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    String filtered = filteredMessages.getString(i2);
                    String message = messages != null && i2 < messages.size() ? messages.getString(i2) : ComponentUtils.EMPTY;
                    String newFiltered = ComponentUtils.EMPTY.equals(filtered) ? message : filtered;
                    newFilteredList.addString(newFiltered);
                    newFilteredIsEmpty = newFilteredIsEmpty && ComponentUtils.EMPTY.equals(newFiltered);
                }
                if (newFilteredIsEmpty) {
                    text.remove("filtered_messages");
                } else {
                    text.setList("filtered_messages", newFilteredList);
                }
            }

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                1.updateText(data.getMap("front_text"));
                1.updateText(data.getMap("back_text"));
                for (String toRemove : LEGACY_FIELDS) {
                    data.remove(toRemove);
                }
                return null;
            }
        };
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:sign", converter);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:hanging_sign", converter);
    }
}

