/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.DataWalkerTypePaths;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItems;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.TypeUtil;

public final class V3685 {
    private static final int VERSION = 3685;

    private static String getType(MapType<String> arrow) {
        return "minecraft:empty".equals(arrow.getString("Potion", "minecraft:empty")) ? "minecraft:arrow" : "minecraft:tipped_arrow";
    }

    private static MapType<String> createItem(TypeUtil util, String id, int count) {
        MapType<String> ret = util.createEmptyMap();
        ret.setString("id", id);
        ret.setInt("Count", count);
        return ret;
    }

    private static void registerArrowEntity(String id) {
        MCTypeRegistry.ENTITY.addWalker(3685, id, new DataWalkerTypePaths<MapType<String>, MapType<String>>(MCTypeRegistry.BLOCK_STATE, "inBlockState"));
        MCTypeRegistry.ENTITY.addWalker(3685, id, new DataWalkerItems("item"));
    }

    public static void register() {
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:trident", new DataConverter<MapType<String>, MapType<String>>(3685){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                RenameHelper.renameSingle(data, "Trident", "item");
                return null;
            }
        });
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:arrow", new DataConverter<MapType<String>, MapType<String>>(3685){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                data.setMap("item", V3685.createItem(data.getTypeUtil(), V3685.getType(data), 1));
                return null;
            }
        });
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:spectral_arrow", new DataConverter<MapType<String>, MapType<String>>(3685){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                data.setMap("item", V3685.createItem(data.getTypeUtil(), "minecraft:spectral_arrow", 1));
                return null;
            }
        });
        V3685.registerArrowEntity("minecraft:trident");
        V3685.registerArrowEntity("minecraft:spectral_arrow");
        V3685.registerArrowEntity("minecraft:arrow");
    }
}

