/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V702 {
    protected static final int VERSION = 702;

    private static void registerMob(String id) {
        MCTypeRegistry.ENTITY.addWalker(702, id, new DataWalkerItemLists("ArmorItems", "HandItems"));
    }

    public static void register() {
        MCTypeRegistry.ENTITY.addConverterForId("Zombie", new DataConverter<MapType<String>, MapType<String>>(702){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                int zombieType = data.getInt("ZombieType");
                data.remove("ZombieType");
                switch (zombieType) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        data.setString("id", "ZombieVillager");
                        data.setInt("Profession", zombieType - 1);
                        break;
                    }
                    case 6: {
                        data.setString("id", "Husk");
                    }
                }
                return null;
            }
        });
        V702.registerMob("ZombieVillager");
        V702.registerMob("Husk");
    }

    private V702() {
    }
}

