/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.gui;

import com.destroystokyo.paper.gui.GraphData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class RAMGraph
extends JComponent {
    public static final LinkedList<GraphData> DATA = new LinkedList<GraphData>(){

        @Override
        public boolean add(GraphData data) {
            if (this.size() >= 348) {
                this.remove();
            }
            return super.add(data);
        }
    };
    private final Timer timer;
    private final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private int currentTick;

    public RAMGraph() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        this.addMouseListener(new MouseAdapter(){
            final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
            final int dismissDelayMinutes = (int)TimeUnit.MINUTES.toMillis(10L);

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelayMinutes);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
            }
        });
        this.timer = new Timer(50, event -> this.repaint());
        this.timer.start();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(350, 110);
    }

    public void update() {
        Point point;
        Runtime jvm = Runtime.getRuntime();
        DATA.add(new GraphData(jvm.totalMemory(), jvm.freeMemory(), jvm.maxMemory()));
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null && (point = pointerInfo.getLocation()) != null) {
            Point loc = new Point(point);
            SwingUtilities.convertPointFromScreen(loc, this);
            if (this.contains(loc)) {
                ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this, -1, System.currentTimeMillis(), 0, loc.x, loc.y, point.x, point.y, 0, false, 0));
            }
        }
        ++this.currentTick;
    }

    @Override
    public void paint(Graphics graphics) {
        int used;
        graphics.setColor(new Color(-1));
        graphics.fillRect(0, 0, 350, 100);
        graphics.setColor(new Color(0x888888));
        graphics.drawLine(1, 25, 348, 25);
        graphics.drawLine(1, 50, 348, 50);
        graphics.drawLine(1, 75, 348, 75);
        int i2 = 0;
        for (GraphData data : DATA) {
            if ((++i2 + this.currentTick) % 120 == 0) {
                graphics.setColor(new Color(0x888888));
                graphics.drawLine(i2, 1, i2, 99);
            }
            if ((used = data.getUsedPercent()) <= 0) continue;
            Color color = data.getLineColor();
            graphics.setColor(data.getFillColor());
            graphics.fillRect(i2, 100 - used, 1, used);
            graphics.setColor(color);
            graphics.fillRect(i2, 100 - used, 1, 1);
        }
        graphics.setColor(new Color(-16777216));
        graphics.drawRect(0, 0, 348, 100);
        Point m2 = this.getMousePosition();
        if (m2 != null && m2.x > 0 && m2.x < 348 && m2.y > 0 && m2.y < 100) {
            GraphData data;
            data = DATA.get(m2.x);
            used = data.getUsedPercent();
            graphics.setColor(new Color(0));
            graphics.drawLine(m2.x, 1, m2.x, 99);
            graphics.drawOval(m2.x - 2, 100 - used - 2, 5, 5);
            graphics.setColor(data.getLineColor());
            graphics.fillOval(m2.x - 2, 100 - used - 2, 5, 5);
            this.setToolTipText(String.format("<html><body>Used: %s mb (%s%%)<br/>%s</body></html>", Math.round((float)data.getUsedMem() / 1024.0f / 1024.0f), used, this.getTime(m2.x)));
        }
    }

    public String getTime(int halfSeconds) {
        int millis = (348 - halfSeconds) / 2 * 1000;
        return this.TIME_FORMAT.format(new Date(System.currentTimeMillis() - (long)millis));
    }

    public void stop() {
        this.timer.stop();
    }

    static {
        GraphData empty = new GraphData(0L, 0L, 0L);
        for (int i2 = 0; i2 < 350; ++i2) {
            DATA.add(empty);
        }
    }
}

