/*
 * Decompiled with CFR 0.152.
 */
package gg.airplane.structs;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class ItemListWithBitset
extends AbstractList<ItemStack> {
    private final ItemStack[] items;
    private long bitSet = 0L;
    private final long allBits;
    public final NonNullList<ItemStack> nonNullList = new OurNonNullList(this);

    public static ItemListWithBitset fromList(List<ItemStack> list) {
        if (list instanceof ItemListWithBitset) {
            ItemListWithBitset ours = (ItemListWithBitset)list;
            return ours;
        }
        return new ItemListWithBitset(list);
    }

    private static ItemStack[] createArray(int size) {
        Object[] array = new ItemStack[size];
        Arrays.fill(array, ItemStack.f);
        return array;
    }

    private ItemListWithBitset(List<ItemStack> list) {
        this(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.set(i2, list.get(i2));
        }
    }

    public ItemListWithBitset(int size) {
        Validate.isTrue((size < 64 ? 1 : 0) != 0, (String)"size is too large");
        this.items = ItemListWithBitset.createArray(size);
        this.allBits = (1L << size) - 1L;
    }

    public boolean isCompletelyEmpty() {
        return this.bitSet == 0L;
    }

    public boolean hasFullStacks() {
        return (this.bitSet & this.allBits) == this.allBits;
    }

    @Override
    public ItemStack set(int index, @NotNull ItemStack itemStack) {
        ItemStack existing = this.items[index];
        this.items[index] = itemStack;
        this.bitSet = itemStack == ItemStack.f ? (this.bitSet &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL) : (this.bitSet |= 1L << index);
        return existing;
    }

    @Override
    @NotNull
    public ItemStack get(int var0) {
        return this.items[var0];
    }

    @Override
    public int size() {
        return this.items.length;
    }

    @Override
    public void clear() {
        Arrays.fill(this.items, ItemStack.f);
    }

    @Override
    public void add(int var0, ItemStack var1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ItemStack remove(int var0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "ItemListWithBitset{items=" + Arrays.toString(this.items) + ", bitSet=" + Long.toString(this.bitSet, 2) + ", allBits=" + Long.toString(this.allBits, 2) + ", size=" + this.items.length + "}";
    }

    private static class OurNonNullList
    extends NonNullList<ItemStack> {
        protected OurNonNullList(List<ItemStack> delegate) {
            super(delegate, ItemStack.f);
        }
    }
}

