/*
 * Decompiled with CFR 0.152.
 */
package gg.pufferfish.pufferfish;

import gg.pufferfish.pufferfish.PufferfishConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class PufferfishCommand
extends Command {
    public PufferfishCommand() {
        super("pufferfish");
        this.description = "Pufferfish related commands";
        this.usageMessage = "/pufferfish [reload | version]";
        this.setPermission("bukkit.command.pufferfish");
    }

    public static void init() {
        MinecraftServer.getServer().server.getCommandMap().register("pufferfish", "Pufferfish", (Command)new PufferfishCommand());
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        if (args.length == 1) {
            return Stream.of("reload", "version").filter(arg -> arg.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        String prefix = ChatColor.of((String)"#12fff6") + ChatColor.BOLD + "Pufferfish \u00bb " + ChatColor.of((String)"#e8f9f9");
        if (args.length != 1) {
            sender.sendMessage(prefix + "Usage: " + this.usageMessage);
            args = new String[]{"version"};
        }
        if (args[0].equalsIgnoreCase("reload")) {
            MinecraftServer console = MinecraftServer.getServer();
            try {
                PufferfishConfig.load();
            }
            catch (IOException e2) {
                sender.sendMessage((Component)Component.text((String)"Failed to reload.", (TextColor)NamedTextColor.RED));
                e2.printStackTrace();
                return true;
            }
            ++console.server.reloadCount;
            Command.broadcastCommandMessage((CommandSender)sender, (String)(prefix + "Pufferfish configuration has been reloaded."));
        } else if (args[0].equalsIgnoreCase("version")) {
            Command.broadcastCommandMessage((CommandSender)sender, (String)(prefix + "This server is running " + Bukkit.getName() + " version " + Bukkit.getVersion() + " (Implementing API version " + Bukkit.getBukkitVersion() + ")"));
        }
        return true;
    }
}

