/*
 * Decompiled with CFR 0.152.
 */
package gg.pufferfish.pufferfish;

import gg.pufferfish.pufferfish.PufferfishLogger;
import gg.pufferfish.pufferfish.sentry.SentryManager;
import gg.pufferfish.pufferfish.simd.SIMDDetection;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.jetbrains.annotations.Nullable;
import org.simpleyaml.configuration.comments.CommentType;
import org.simpleyaml.configuration.file.YamlFile;
import org.simpleyaml.exceptions.InvalidConfigurationException;

public class PufferfishConfig {
    private static final YamlFile config = new YamlFile();
    private static int updates = 0;
    public static File pufferfishFile;
    public static String sentryDsn;
    public static boolean enableBooks;
    public static boolean tpsCatchup;
    public static boolean enableSuffocationOptimization;
    public static boolean enableAsyncMobSpawning;
    public static boolean asyncMobSpawningInitialized;
    public static int maxProjectileLoadsPerTick;
    public static int maxProjectileLoadsPerProjectile;
    public static boolean dearEnabled;
    public static int startDistance;
    public static int startDistanceSquared;
    public static int maximumActivationPrio;
    public static int activationDistanceMod;
    public static Map<String, Integer> projectileTimeouts;
    public static boolean throttleInactiveGoalSelectorTick;
    public static boolean allowEndCrystalRespawn;
    public static boolean disableMethodProfiler;
    public static boolean disableOutOfOrderChat;

    private static ConfigurationSection convertToBukkit(org.simpleyaml.configuration.ConfigurationSection section) {
        MemoryConfiguration newSection = new MemoryConfiguration();
        for (String key : section.getKeys(false)) {
            if (section.isConfigurationSection(key)) {
                newSection.set(key, (Object)PufferfishConfig.convertToBukkit(section.getConfigurationSection(key)));
                continue;
            }
            newSection.set(key, section.get(key));
        }
        return newSection;
    }

    public static ConfigurationSection getConfigCopy() {
        return PufferfishConfig.convertToBukkit((org.simpleyaml.configuration.ConfigurationSection)config);
    }

    public static int getUpdates() {
        return updates;
    }

    public static void load() throws IOException {
        File configFile = pufferfishFile;
        if (configFile.exists()) {
            try {
                config.load(configFile);
            }
            catch (InvalidConfigurationException e2) {
                throw new IOException(e2);
            }
        }
        PufferfishConfig.getString("info.version", "1.0", new String[0]);
        PufferfishConfig.setComment("info", "Pufferfish Configuration", "Check out Pufferfish Host for maximum performance server hosting: https://pufferfish.host", "Join our Discord for support: https://discord.gg/reZw4vQV9H", "Download new builds at https://ci.pufferfish.host/job/Pufferfish");
        for (Method method : PufferfishConfig.class.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPrivate(method.getModifiers()) || method.getParameterCount() != 0 || method.getReturnType() != Void.TYPE || method.getName().startsWith("lambda")) continue;
            method.setAccessible(true);
            try {
                method.invoke(null, new Object[0]);
            }
            catch (Throwable t2) {
                MinecraftServer.l.warn("Failed to load configuration option from " + method.getName(), t2);
            }
        }
        ++updates;
        config.save(configFile);
        try {
            SIMDDetection.isEnabled = SIMDDetection.canEnable((Logger)PufferfishLogger.LOGGER);
            SIMDDetection.versionLimited = SIMDDetection.getJavaVersion() < 17 || SIMDDetection.getJavaVersion() > 21;
        }
        catch (Exception | NoClassDefFoundError ignored) {
            ignored.printStackTrace();
        }
        if (SIMDDetection.isEnabled) {
            PufferfishLogger.LOGGER.info("SIMD operations detected as functional. Will replace some operations with faster versions.");
        } else if (SIMDDetection.versionLimited) {
            PufferfishLogger.LOGGER.warning("Will not enable SIMD! These optimizations are only safely supported on Java 17 through Java 21.");
        } else {
            PufferfishLogger.LOGGER.warning("SIMD operations are available for your server, but are not configured!");
            PufferfishLogger.LOGGER.warning("To enable additional optimizations, add \"--add-modules=jdk.incubator.vector\" to your startup flags, BEFORE the \"-jar\".");
            PufferfishLogger.LOGGER.warning("If you have already added this flag, then SIMD operations are not supported on your JVM or CPU.");
            PufferfishLogger.LOGGER.warning("Debug: Java: " + System.getProperty("java.version") + ", test run: " + SIMDDetection.testRun);
        }
    }

    private static void setComment(String key, String ... comment) {
        if (config.contains(key)) {
            config.setComment(key, String.join((CharSequence)"\n", comment), CommentType.BLOCK);
        }
    }

    private static void ensureDefault(String key, Object defaultValue, String ... comment) {
        if (!config.contains(key)) {
            config.set(key, defaultValue);
            config.setComment(key, String.join((CharSequence)"\n", comment), CommentType.BLOCK);
        }
    }

    private static boolean getBoolean(String key, boolean defaultValue, String ... comment) {
        return PufferfishConfig.getBoolean(key, null, defaultValue, comment);
    }

    private static boolean getBoolean(String key, @Nullable String oldKey, boolean defaultValue, String ... comment) {
        PufferfishConfig.ensureDefault(key, defaultValue, comment);
        return config.getBoolean(key, defaultValue);
    }

    private static int getInt(String key, int defaultValue, String ... comment) {
        return PufferfishConfig.getInt(key, null, defaultValue, comment);
    }

    private static int getInt(String key, @Nullable String oldKey, int defaultValue, String ... comment) {
        PufferfishConfig.ensureDefault(key, defaultValue, comment);
        return config.getInt(key, defaultValue);
    }

    private static double getDouble(String key, double defaultValue, String ... comment) {
        return PufferfishConfig.getDouble(key, null, defaultValue, comment);
    }

    private static double getDouble(String key, @Nullable String oldKey, double defaultValue, String ... comment) {
        PufferfishConfig.ensureDefault(key, defaultValue, comment);
        return config.getDouble(key, defaultValue);
    }

    private static String getString(String key, String defaultValue, String ... comment) {
        return PufferfishConfig.getOldString(key, null, defaultValue, comment);
    }

    private static String getOldString(String key, @Nullable String oldKey, String defaultValue, String ... comment) {
        PufferfishConfig.ensureDefault(key, defaultValue, comment);
        return config.getString(key, defaultValue);
    }

    private static List<String> getStringList(String key, List<String> defaultValue, String ... comment) {
        return PufferfishConfig.getStringList(key, null, defaultValue, comment);
    }

    private static List<String> getStringList(String key, @Nullable String oldKey, List<String> defaultValue, String ... comment) {
        PufferfishConfig.ensureDefault(key, defaultValue, comment);
        return config.getStringList(key);
    }

    private static void sentry() {
        String sentryEnvironment = System.getenv("SENTRY_DSN");
        String sentryConfig = PufferfishConfig.getString("sentry-dsn", "", "Sentry DSN for improved error logging, leave blank to disable", "Obtain from https://sentry.io/");
        String string = sentryDsn = sentryEnvironment == null ? sentryConfig : sentryEnvironment;
        if (sentryDsn != null && !sentryDsn.isBlank()) {
            SentryManager.init();
        }
    }

    private static void books() {
        enableBooks = PufferfishConfig.getBoolean("enable-books", true, "Whether or not books should be writeable.", "Servers that anticipate being a target for duping may want to consider", "disabling this option.", "This can be overridden per-player with the permission pufferfish.usebooks");
    }

    private static void tpsCatchup() {
        tpsCatchup = PufferfishConfig.getBoolean("tps-catchup", true, "If this setting is true, the server will run faster after a lag spike in", "an attempt to maintain 20 TPS. This option (defaults to true per", "spigot/paper) can cause mobs to move fast after a lag spike.");
    }

    private static void suffocationOptimization() {
        enableSuffocationOptimization = PufferfishConfig.getBoolean("enable-suffocation-optimization", true, "Optimizes the suffocation check by selectively skipping", "the check in a way that still appears vanilla. This should", "be left enabled on most servers, but is provided as a", "configuration option if the vanilla deviation is undesirable.");
    }

    private static void asyncMobSpawning() {
        boolean temp = PufferfishConfig.getBoolean("enable-async-mob-spawning", true, "Whether or not asynchronous mob spawning should be enabled.", "On servers with many entities, this can improve performance by up to 15%. You must have", "paper's per-player-mob-spawns setting set to true for this to work.", "One quick note - this does not actually spawn mobs async (that would be very unsafe).", "This just offloads some expensive calculations that are required for mob spawning.");
        if (!asyncMobSpawningInitialized) {
            asyncMobSpawningInitialized = true;
            enableAsyncMobSpawning = temp;
        }
    }

    private static void projectileLoading() {
        maxProjectileLoadsPerTick = PufferfishConfig.getInt("projectile.max-loads-per-tick", 10, "Controls how many chunks are allowed", "to be sync loaded by projectiles in a tick.");
        maxProjectileLoadsPerProjectile = PufferfishConfig.getInt("projectile.max-loads-per-projectile", 10, "Controls how many chunks a projectile", "can load in its lifetime before it gets", "automatically removed.");
        PufferfishConfig.setComment("projectile", "Optimizes projectile settings");
    }

    private static void dynamicActivationOfBrains() throws IOException {
        dearEnabled = PufferfishConfig.getBoolean("dab.enabled", "activation-range.enabled", false, new String[0]);
        startDistance = PufferfishConfig.getInt("dab.start-distance", "activation-range.start-distance", 12, "This value determines how far away an entity has to be", "from the player to start being effected by DEAR.");
        startDistanceSquared = startDistance * startDistance;
        maximumActivationPrio = PufferfishConfig.getInt("dab.max-tick-freq", "activation-range.max-tick-freq", 20, "This value defines how often in ticks, the furthest entity", "will get their pathfinders and behaviors ticked. 20 = 1s");
        activationDistanceMod = PufferfishConfig.getInt("dab.activation-dist-mod", "activation-range.activation-dist-mod", 8, "This value defines how much distance modifies an entity's", "tick frequency. freq = (distanceToPlayer^2) / (2^value)", "If you want further away entities to tick less often, use 7.", "If you want further away entities to tick more often, try 9.");
        for (EntityTypes entityTypes : BuiltInRegistries.g) {
            entityTypes.dabEnabled = true;
        }
        PufferfishConfig.getStringList("dab.blacklisted-entities", "activation-range.blacklisted-entities", Collections.emptyList(), "A list of entities to ignore for activation").forEach(name -> EntityTypes.a(name).ifPresentOrElse(entityType -> {
            entityType.dabEnabled = false;
        }, () -> MinecraftServer.l.warn("Unknown entity \"" + name + "\"")));
        PufferfishConfig.setComment("dab", "Optimizes entity brains when", "they're far away from the player");
    }

    private static void projectileTimeouts() {
        PufferfishConfig.getInt("entity_timeouts.SNOWBALL", -1, new String[0]);
        PufferfishConfig.getInt("entity_timeouts.LLAMA_SPIT", -1, new String[0]);
        PufferfishConfig.setComment("entity_timeouts", "These values define a entity's maximum lifespan. If an", "entity is in this list and it has survived for longer than", "that number of ticks, then it will be removed. Setting a value to", "-1 disables this feature.");
        for (EntityTypes entityTypes : BuiltInRegistries.g) {
            String type = EntityTypes.a(entityTypes).a().toUpperCase(Locale.ROOT);
            entityTypes.ttl = config.getInt("entity_timeouts." + type, -1);
        }
    }

    private static void inactiveGoalSelectorThrottle() {
        throttleInactiveGoalSelectorTick = PufferfishConfig.getBoolean("inactive-goal-selector-throttle", "inactive-goal-selector-disable", false, "Throttles the AI goal selector in entity inactive ticks.", "This can improve performance by a few percent, but has minor gameplay implications.");
    }

    private static void allowEndCrystalRespawn() {
        allowEndCrystalRespawn = PufferfishConfig.getBoolean("allow-end-crystal-respawn", true, "Allows end crystals to respawn the ender dragon.", "On servers that expect end crystal fights in the end dimension, disabling this", "will prevent the server from performing an expensive search to attempt respawning", "the ender dragon whenever a player places an end crystal.");
    }

    private static void miscSettings() {
        disableMethodProfiler = PufferfishConfig.getBoolean("misc.disable-method-profiler", true, new String[0]);
        disableOutOfOrderChat = PufferfishConfig.getBoolean("misc.disable-out-of-order-chat", false, new String[0]);
        PufferfishConfig.setComment("misc", "Settings for things that don't belong elsewhere");
    }
}

