/*
 * Decompiled with CFR 0.152.
 */
package gg.pufferfish.pufferfish;

import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.util.VersionFetcher;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PufferfishVersionFetcher
implements VersionFetcher {
    private static final Logger LOGGER = Logger.getLogger("PufferfishVersionFetcher");
    private static final HttpClient client = HttpClient.newHttpClient();
    private static final URI JENKINS_URI = URI.create("https://ci.pufferfish.host/job/Pufferfish-1.20/lastSuccessfulBuild/buildNumber");
    private static final String GITHUB_FORMAT = "https://api.github.com/repos/pufferfish-gg/Pufferfish/compare/ver/1.20...%s";
    private static final HttpResponse.BodyHandler<JsonObject> JSON_OBJECT_BODY_HANDLER = responseInfo -> HttpResponse.BodySubscribers.mapping(HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8), string -> (JsonObject)new Gson().fromJson(string, JsonObject.class));

    public long getCacheTime() {
        return TimeUnit.MINUTES.toMillis(30L);
    }

    @NotNull
    public Component getVersionMessage(@NotNull String serverVersion) {
        TextComponent component;
        String[] parts = CraftServer.class.getPackage().getImplementationVersion().split("-");
        if (parts.length != 3) {
            component = Component.text((String)"Unknown server version.", (TextColor)NamedTextColor.RED);
        } else {
            String versionString = parts[2];
            try {
                component = this.fetchJenkinsVersion(Integer.parseInt(versionString));
            }
            catch (NumberFormatException e2) {
                component = this.fetchGithubVersion(versionString.substring(1, versionString.length() - 1));
            }
        }
        @Nullable Component history = this.getHistory();
        return history != null ? Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{component, Component.newline(), this.getHistory()}) : component;
    }

    @NotNull
    private Component fetchJenkinsVersion(int versionNumber) {
        HttpRequest request = HttpRequest.newBuilder(JENKINS_URI).build();
        try {
            int latestVersionNumber;
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return Component.text((String)("Received invalid status code (" + response.statusCode() + ") from server."), (TextColor)NamedTextColor.RED);
            }
            try {
                latestVersionNumber = Integer.parseInt(response.body());
            }
            catch (NumberFormatException e2) {
                LOGGER.log(Level.WARNING, "Received invalid response from Jenkins \"" + response.body() + "\".");
                return Component.text((String)"Received invalid response from server.", (TextColor)NamedTextColor.RED);
            }
            int versionDiff = latestVersionNumber - versionNumber;
            return this.getResponseMessage(versionDiff);
        }
        catch (IOException | InterruptedException e3) {
            LOGGER.log(Level.WARNING, "Failed to look up version from Jenkins", e3);
            return Component.text((String)"Failed to retrieve version from server.", (TextColor)NamedTextColor.RED);
        }
    }

    @NotNull
    private Component fetchGithubVersion(@NotNull String hash) {
        URI uri = URI.create(String.format(GITHUB_FORMAT, hash));
        HttpRequest request = HttpRequest.newBuilder(uri).build();
        try {
            HttpResponse<JsonObject> response = client.send(request, JSON_OBJECT_BODY_HANDLER);
            if (response.statusCode() != 200) {
                return Component.text((String)("Received invalid status code (" + response.statusCode() + ") from server."), (TextColor)NamedTextColor.RED);
            }
            JsonObject obj = response.body();
            int versionDiff = obj.get("behind_by").getAsInt();
            return this.getResponseMessage(versionDiff);
        }
        catch (IOException | InterruptedException e2) {
            LOGGER.log(Level.WARNING, "Failed to look up version from GitHub", e2);
            return Component.text((String)"Failed to retrieve version from server.", (TextColor)NamedTextColor.RED);
        }
    }

    @NotNull
    private Component getResponseMessage(int versionDiff) {
        return switch (Math.max(-1, Math.min(1, versionDiff))) {
            case -1 -> Component.text((String)"You are running an unsupported version of Pufferfish.", (TextColor)NamedTextColor.RED);
            case 0 -> Component.text((String)"You are on the latest version!", (TextColor)NamedTextColor.GREEN);
            default -> Component.text((String)("You are running " + versionDiff + " version" + (versionDiff == 1 ? "" : "s") + " beyond. Please update your server when possible to maintain stability, security, and receive the latest optimizations."), (TextColor)NamedTextColor.RED);
        };
    }

    @Nullable
    private Component getHistory() {
        VersionHistoryManager.VersionData data = VersionHistoryManager.INSTANCE.getVersionData();
        if (data == null) {
            return null;
        }
        String oldVersion = data.getOldVersion();
        if (oldVersion == null) {
            return null;
        }
        return Component.text((String)("Previous version: " + oldVersion), (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC});
    }
}

