/*
 * Decompiled with CFR 0.152.
 */
package gg.pufferfish.pufferfish.sentry;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.protocol.Message;
import io.sentry.protocol.User;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.filter.AbstractFilter;

public class PufferfishSentryAppender
extends AbstractAppender {
    private static final Logger logger = LogManager.getLogger(PufferfishSentryAppender.class);
    private static final Gson GSON = new Gson();

    public PufferfishSentryAppender() {
        super("PufferfishSentryAdapter", (Filter)new SentryFilter(), null);
    }

    public void append(LogEvent logEvent) {
        if (logEvent.getThrown() != null && logEvent.getLevel().isMoreSpecificThan(Level.WARN)) {
            try {
                this.logException(logEvent);
            }
            catch (Exception e2) {
                logger.warn("Failed to log event with sentry", (Throwable)e2);
            }
        } else {
            try {
                this.logBreadcrumb(logEvent);
            }
            catch (Exception e3) {
                logger.warn("Failed to log event with sentry", (Throwable)e3);
            }
        }
    }

    private void logException(LogEvent e2) {
        Map eventFields;
        boolean hasContext;
        SentryEvent event = new SentryEvent(e2.getThrown());
        Message sentryMessage = new Message();
        sentryMessage.setMessage(e2.getMessage().getFormattedMessage());
        event.setThrowable(e2.getThrown());
        event.setLevel(this.getLevel(e2.getLevel()));
        event.setLogger(e2.getLoggerName());
        event.setTransaction(e2.getLoggerName());
        event.setExtra("thread_name", (Object)e2.getThreadName());
        boolean bl = hasContext = e2.getContextData() != null;
        if (hasContext && e2.getContextData().containsKey("pufferfishsentry_playerid")) {
            User user = new User();
            user.setId((String)e2.getContextData().getValue("pufferfishsentry_playerid"));
            user.setUsername((String)e2.getContextData().getValue("pufferfishsentry_playername"));
            event.setUser(user);
        }
        if (hasContext && e2.getContextData().containsKey("pufferfishsentry_pluginname")) {
            event.setExtra("plugin.name", e2.getContextData().getValue("pufferfishsentry_pluginname"));
            event.setExtra("plugin.version", e2.getContextData().getValue("pufferfishsentry_pluginversion"));
            event.setTransaction((String)e2.getContextData().getValue("pufferfishsentry_pluginname"));
        }
        if (hasContext && e2.getContextData().containsKey("pufferfishsentry_eventdata") && (eventFields = (Map)GSON.fromJson((String)e2.getContextData().getValue("pufferfishsentry_eventdata"), new TypeToken<Map<String, String>>(){}.getType())) != null) {
            event.setExtra("event", (Object)eventFields);
        }
        Sentry.captureEvent((SentryEvent)event);
    }

    private void logBreadcrumb(LogEvent e2) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setLevel(this.getLevel(e2.getLevel()));
        breadcrumb.setCategory(e2.getLoggerName());
        breadcrumb.setType(e2.getLoggerName());
        breadcrumb.setMessage(e2.getMessage().getFormattedMessage());
        Sentry.addBreadcrumb((Breadcrumb)breadcrumb);
    }

    private SentryLevel getLevel(Level level) {
        switch (level.getStandardLevel()) {
            case TRACE: 
            case DEBUG: {
                return SentryLevel.DEBUG;
            }
            case WARN: {
                return SentryLevel.WARNING;
            }
            case ERROR: {
                return SentryLevel.ERROR;
            }
            case FATAL: {
                return SentryLevel.FATAL;
            }
        }
        return SentryLevel.INFO;
    }

    private static class SentryFilter
    extends AbstractFilter {
        private SentryFilter() {
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t2) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(LogEvent event) {
            return this.filter(event == null ? null : event.getLoggerName());
        }

        private Filter.Result filter(String loggerName) {
            return loggerName != null && loggerName.startsWith("gg.castaway.pufferfish.sentry") ? Filter.Result.DENY : Filter.Result.NEUTRAL;
        }
    }
}

