/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command;

import com.google.common.collect.Lists;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.Entrypoint;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.provider.ProviderStatus;
import io.papermc.paper.plugin.provider.ProviderStatusHolder;
import io.papermc.paper.plugin.provider.type.paper.PaperPluginParent;
import io.papermc.paper.plugin.provider.type.spigot.SpigotPluginProvider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PaperPluginsCommand
extends BukkitCommand {
    private static final TextColor INFO_COLOR = TextColor.color((int)52, (int)159, (int)218);
    private static final Component SERVER_PLUGIN_INFO = Component.text((String)"\u2139 What is a server plugin?", (TextColor)INFO_COLOR).append(PaperPluginsCommand.asPlainComponents("Server plugins can add new behavior to your server!\nYou can find new plugins on Paper's plugin repository, Hangar.\n\n<link to hangar>\n"));
    private static final Component SERVER_INITIALIZER_INFO = Component.text((String)"\u2139 What is a server initializer?", (TextColor)INFO_COLOR).append(PaperPluginsCommand.asPlainComponents("Server initializers are ran before your server\nstarts and are provided by paper plugins.\n"));
    private static final Component LEGACY_PLUGIN_INFO = Component.text((String)"\u2139 What is a legacy plugin?", (TextColor)INFO_COLOR).append(PaperPluginsCommand.asPlainComponents("A legacy plugin is a plugin that was made on\nvery old unsupported versions of the game.\n\nIt is encouraged that you replace this plugin,\nas they might not work in the future and may cause\nperformance issues.\n"));
    private static final Component LEGACY_PLUGIN_STAR = Component.text((char)'*', (TextColor)TextColor.color((int)255, (int)212, (int)42)).hoverEvent((HoverEventSource)LEGACY_PLUGIN_INFO);
    private static final Component INFO_ICON_START = Component.text((String)"\u2139 ", (TextColor)INFO_COLOR);
    private static final Component PAPER_HEADER = Component.text((String)"Paper Plugins:", (TextColor)TextColor.color((int)2, (int)136, (int)209));
    private static final Component BUKKIT_HEADER = Component.text((String)"Bukkit Plugins:", (TextColor)TextColor.color((int)237, (int)129, (int)6));
    private static final Component PLUGIN_TICK = Component.text((String)"- ", (TextColor)NamedTextColor.DARK_GRAY);
    private static final Component PLUGIN_TICK_EMPTY = Component.text((String)" ");
    private static final Type JAVA_PLUGIN_PROVIDER_TYPE = new TypeToken<PluginProvider<JavaPlugin>>(){}.getType();

    public PaperPluginsCommand() {
        super("plugins");
        this.description = "Gets a list of plugins running on the server";
        this.usageMessage = "/plugins";
        this.setPermission("bukkit.command.plugins");
        this.setAliases(Arrays.asList("pl"));
    }

    private static <T> List<Component> formatProviders(TreeMap<String, PluginProvider<T>> plugins, @NotNull CommandSender sender) {
        ArrayList<Component> components = new ArrayList<Component>(plugins.size());
        for (PluginProvider<T> entry : plugins.values()) {
            components.add(PaperPluginsCommand.formatProvider(entry, sender));
        }
        boolean isFirst = true;
        ArrayList<Component> formattedSublists = new ArrayList<Component>();
        for (List componentSublist : Lists.partition(components, (int)10)) {
            TextComponent component = Component.space();
            if (isFirst) {
                component = component.append(PLUGIN_TICK);
                isFirst = false;
            } else {
                component = PLUGIN_TICK_EMPTY;
            }
            formattedSublists.add(component.append(Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), (Iterable)componentSublist)));
        }
        return formattedSublists;
    }

    private static Component formatProvider(PluginProvider<?> provider, @NotNull CommandSender sender) {
        SpigotPluginProvider spigotPluginProvider;
        TextComponent.Builder builder = Component.text();
        if (provider instanceof SpigotPluginProvider && CraftMagicNumbers.isLegacy((spigotPluginProvider = (SpigotPluginProvider)provider).getMeta())) {
            builder.append(LEGACY_PLUGIN_STAR);
        }
        String name = provider.getMeta().getName();
        Component pluginName = Component.text((String)name, (TextColor)PaperPluginsCommand.fromStatus(provider)).clickEvent(ClickEvent.suggestCommand((String)("/version " + name)));
        if (sender instanceof Player && sender.hasPermission("bukkit.command.version")) {
            String description = provider.getMeta().getDescription();
            TextComponent.Builder hover = Component.text();
            ((TextComponent.Builder)hover.append((Component)Component.text((String)"Version: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)provider.getMeta().getVersion(), (TextColor)NamedTextColor.GREEN));
            if (description != null) {
                ((TextComponent.Builder)((TextComponent.Builder)hover.append((Component)Component.newline())).append((Component)Component.text((String)"Description: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)description, (TextColor)NamedTextColor.GREEN));
            }
            if (provider.getMeta().getWebsite() != null) {
                ((TextComponent.Builder)((TextComponent.Builder)hover.append((Component)Component.newline())).append((Component)Component.text((String)"Website: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)provider.getMeta().getWebsite(), (TextColor)NamedTextColor.GREEN));
            }
            if (!provider.getMeta().getAuthors().isEmpty()) {
                hover.append((Component)Component.newline());
                if (provider.getMeta().getAuthors().size() == 1) {
                    hover.append((Component)Component.text((String)"Author: "));
                } else {
                    hover.append((Component)Component.text((String)"Authors: "));
                }
                hover.append((Component)PaperPluginsCommand.getAuthors(provider.getMeta()));
            }
            pluginName.hoverEvent((HoverEventSource)hover.build());
        }
        builder.append(pluginName);
        return builder.build();
    }

    @NotNull
    private static TextComponent getAuthors(@NotNull PluginMeta pluginMeta) {
        TextComponent.Builder builder = Component.text();
        List authors = pluginMeta.getAuthors();
        for (int i2 = 0; i2 < authors.size(); ++i2) {
            if (i2 > 0) {
                builder.append((Component)Component.text((String)(i2 < authors.size() - 1 ? ", " : " and "), (TextColor)NamedTextColor.WHITE));
            }
            builder.append((Component)Component.text((String)((String)authors.get(i2)), (TextColor)NamedTextColor.GREEN));
        }
        return (TextComponent)builder.build();
    }

    private static Component asPlainComponents(String strings) {
        TextComponent.Builder builder = Component.text();
        for (String string : strings.split("\n")) {
            builder.append((Component)Component.newline());
            builder.append((Component)Component.text((String)string, (TextColor)NamedTextColor.WHITE));
        }
        return builder.build();
    }

    private static TextColor fromStatus(PluginProvider<?> provider) {
        PaperPluginParent.PaperServerPluginProvider serverPluginProvider;
        ProviderStatusHolder statusHolder;
        if (provider instanceof ProviderStatusHolder && (statusHolder = (ProviderStatusHolder)((Object)provider)).getLastProvidedStatus() != null) {
            ProviderStatus status = statusHolder.getLastProvidedStatus();
            if (status == ProviderStatus.INITIALIZED && GenericTypeReflector.isSuperType((Type)JAVA_PLUGIN_PROVIDER_TYPE, provider.getClass())) {
                Plugin plugin = Bukkit.getPluginManager().getPlugin(provider.getMeta().getName());
                if (plugin == null) {
                    return NamedTextColor.RED;
                }
                return plugin.isEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED;
            }
            return switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case ProviderStatus.INITIALIZED -> NamedTextColor.GREEN;
                case ProviderStatus.ERRORED -> NamedTextColor.RED;
            };
        }
        if (provider instanceof PaperPluginParent.PaperServerPluginProvider && (serverPluginProvider = (PaperPluginParent.PaperServerPluginProvider)provider).shouldSkipCreation()) {
            return NamedTextColor.RED;
        }
        return NamedTextColor.RED;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        TreeMap paperPlugins = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        TreeMap spigotPlugins = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (PluginProvider<JavaPlugin> provider : LaunchEntryPointHandler.INSTANCE.get(Entrypoint.PLUGIN).getRegisteredProviders()) {
            PluginMeta configuration = provider.getMeta();
            if (provider instanceof SpigotPluginProvider) {
                spigotPlugins.put(configuration.getDisplayName(), provider);
                continue;
            }
            if (!(provider instanceof PaperPluginParent.PaperServerPluginProvider)) continue;
            paperPlugins.put(configuration.getDisplayName(), provider);
        }
        if (!paperPlugins.isEmpty()) {
            sender.sendMessage(PAPER_HEADER.append((Component)Component.text((String)" (%s):".formatted(paperPlugins.size()))));
        }
        for (Component component : PaperPluginsCommand.formatProviders(paperPlugins, sender)) {
            sender.sendMessage(component);
        }
        if (!spigotPlugins.isEmpty()) {
            sender.sendMessage(BUKKIT_HEADER.append((Component)Component.text((String)" (%s):".formatted(spigotPlugins.size()))));
        }
        for (Component component : PaperPluginsCommand.formatProviders(spigotPlugins, sender)) {
            sender.sendMessage(component);
        }
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        return Collections.emptyList();
    }
}

