/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.logging;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.checkerframework.checker.nullness.qual.NonNull;

@Plugin(name="StacktraceDeobfuscatingRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public final class StacktraceDeobfuscatingRewritePolicy
implements RewritePolicy {
    private static final MethodHandle DEOBFUSCATE_THROWABLE;

    private StacktraceDeobfuscatingRewritePolicy() {
    }

    public @NonNull LogEvent rewrite(@NonNull LogEvent rewrite) {
        Throwable thrown = rewrite.getThrown();
        if (thrown != null) {
            StacktraceDeobfuscatingRewritePolicy.deobfuscateThrowable(thrown);
            return new Log4jLogEvent.Builder(rewrite).setThrownProxy(null).build();
        }
        return rewrite;
    }

    private static void deobfuscateThrowable(Throwable thrown) {
        try {
            DEOBFUSCATE_THROWABLE.invoke(thrown);
        }
        catch (Error e2) {
            throw e2;
        }
        catch (Throwable e3) {
            throw new RuntimeException(e3);
        }
    }

    @PluginFactory
    public static @NonNull StacktraceDeobfuscatingRewritePolicy createPolicy() {
        return new StacktraceDeobfuscatingRewritePolicy();
    }

    static {
        try {
            Class<?> cls = Class.forName("io.papermc.paper.util.StacktraceDeobfuscator");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            VarHandle instanceHandle = lookup.findStaticVarHandle(cls, "INSTANCE", cls);
            Object deobfuscator = instanceHandle.get();
            DEOBFUSCATE_THROWABLE = lookup.unreflect(cls.getDeclaredMethod("deobfuscateThrowable", Throwable.class)).bindTo(deobfuscator);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

