/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public final class SysoutCatcher {
    private static final boolean SUPPRESS_NAGS = Boolean.getBoolean("io.papermc.paper.suppress.sout.nags");
    private static final long NAG_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(Long.getLong("io.papermc.paper.sout.nags.timeout", TimeUnit.MINUTES.toMillis(5L)));
    private static final long NAG_INTERVAL = Long.getLong("io.papermc.paper.sout.nags.interval", 200L);
    private final ConcurrentMap<String, PluginNag> nagRecords = new ConcurrentHashMap<String, PluginNag>(64);

    public SysoutCatcher() {
        System.setOut(new WrappedOutStream(System.out, Level.INFO, "[STDOUT] "));
        System.setErr(new WrappedOutStream(System.err, Level.SEVERE, "[STDERR] "));
    }

    private final class WrappedOutStream
    extends PrintStream {
        private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        private final Level level;
        private final String prefix;

        public WrappedOutStream(OutputStream out, Level level, String prefix) {
            super(out);
            this.level = level;
            this.prefix = prefix;
        }

        @Override
        public void println(@Nullable String line) {
            Class<?> clazz = STACK_WALKER.getCallerClass();
            try {
                JavaPlugin plugin = JavaPlugin.getProvidingPlugin(clazz);
                plugin.getLogger().log(this.level, line);
                return;
            }
            catch (IllegalArgumentException | IllegalStateException e2) {
                Bukkit.getLogger().log(this.level, String.format("%s[%s] %s", this.prefix, clazz.getName(), line));
                return;
            }
        }

        private static /* synthetic */ PluginNag lambda$println$0(String k2) {
            return new PluginNag();
        }
    }

    private static class PluginNag {
        private long lastNagTimestamp = Long.MIN_VALUE;
        private long messagesSinceNag = Long.MIN_VALUE;

        private PluginNag() {
        }
    }
}

