/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.classloader.group;

import io.papermc.paper.plugin.entrypoint.classloader.group.GlobalPluginClassLoaderGroup;
import io.papermc.paper.plugin.entrypoint.classloader.group.SimpleListPluginClassLoaderGroup;
import io.papermc.paper.plugin.provider.classloader.ClassLoaderAccess;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DependencyBasedPluginClassLoaderGroup
extends SimpleListPluginClassLoaderGroup {
    private final GlobalPluginClassLoaderGroup globalPluginClassLoaderGroup;
    private final ClassLoaderAccess access;

    public DependencyBasedPluginClassLoaderGroup(GlobalPluginClassLoaderGroup globalPluginClassLoaderGroup, ClassLoaderAccess access) {
        super(new ArrayList<ConfiguredPluginClassLoader>());
        this.access = access;
        this.globalPluginClassLoaderGroup = globalPluginClassLoaderGroup;
    }

    public void populateDependencies() {
        this.classloaders.clear();
        for (ConfiguredPluginClassLoader configuredPluginClassLoader : this.globalPluginClassLoaderGroup.getClassLoaders()) {
            if (!this.access.canAccess(configuredPluginClassLoader)) continue;
            this.classloaders.add(configuredPluginClassLoader);
        }
    }

    public ClassLoaderAccess getAccess() {
        return this.access;
    }

    @Override
    public String toString() {
        return "DependencyBasedPluginClassLoaderGroup{globalPluginClassLoaderGroup=" + this.globalPluginClassLoaderGroup + ", access=" + this.access + ", classloaders=" + this.classloaders + "}";
    }
}

