/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.dependency;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.dependency.MetaDependencyTree;
import io.papermc.paper.plugin.provider.configuration.PaperPluginMeta;

public class BootstrapMetaDependencyTree
extends MetaDependencyTree {
    public BootstrapMetaDependencyTree() {
        this((MutableGraph<String>)GraphBuilder.directed().build());
    }

    public BootstrapMetaDependencyTree(MutableGraph<String> graph) {
        super(graph);
    }

    @Override
    protected void registerDependencies(String identifier, PluginMeta meta) {
        if (!(meta instanceof PaperPluginMeta)) {
            throw new IllegalStateException("Only paper plugins can have a bootstrapper!");
        }
        PaperPluginMeta paperPluginMeta = (PaperPluginMeta)meta;
        for (String dependency : paperPluginMeta.getBoostrapDependencies().keySet()) {
            this.graph.putEdge((Object)identifier, (Object)dependency);
        }
    }

    @Override
    protected void unregisterDependencies(String identifier, PluginMeta meta) {
        if (!(meta instanceof PaperPluginMeta)) {
            throw new IllegalStateException("PluginMeta must be a PaperPluginMeta");
        }
        PaperPluginMeta paperPluginMeta = (PaperPluginMeta)meta;
        for (String dependency : paperPluginMeta.getBoostrapDependencies().keySet()) {
            this.graph.removeEdge((Object)identifier, (Object)dependency);
        }
    }

    @Override
    public String toString() {
        return "BootstrapDependencyTree{graph=" + this.graph + "}";
    }
}

