/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.lifecycle.event.types;

import io.papermc.paper.plugin.lifecycle.event.LifecycleEvent;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.AbstractLifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.handler.configuration.LifecycleEventHandlerConfiguration;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class AbstractLifecycleEventType<O extends LifecycleEventOwner, E extends LifecycleEvent, C extends LifecycleEventHandlerConfiguration<O>, CI extends AbstractLifecycleEventHandlerConfiguration<O, E, CI>>
implements LifecycleEventType<O, E, C> {
    private final String name;
    private final Class<? extends O> ownerType;

    protected AbstractLifecycleEventType(String name, Class<? extends O> ownerType) {
        this.name = name;
        this.ownerType = ownerType;
    }

    public String name() {
        return this.name;
    }

    private void verifyOwner(O owner) {
        if (!this.ownerType.isInstance(owner)) {
            throw new IllegalArgumentException("You cannot register the lifecycle event '" + this.name + "' on " + owner);
        }
    }

    public abstract void forEachHandler(Consumer<? super RegisteredHandler<O, E>> var1, Predicate<? super RegisteredHandler<O, E>> var2);

    public abstract void removeMatching(Predicate<? super RegisteredHandler<O, E>> var1);

    protected abstract void register(O var1, LifecycleEventHandler<? super E> var2, CI var3);

    public final void tryRegister(O owner, LifecycleEventHandler<? super E> handler, CI config) {
        this.verifyOwner(owner);
        LifecycleEventRunner.INSTANCE.checkRegisteredHandler((LifecycleEventOwner)owner, this);
        this.register(owner, handler, config);
    }

    public record RegisteredHandler<O, E extends LifecycleEvent>(O owner, LifecycleEventHandler<? super E> lifecycleEventHandler) {
    }
}

