/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.threadedregions.scheduler;

import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.concurrentutil.util.Validate;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.invoke.VarHandle;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public final class FoliaEntityScheduler
implements EntityScheduler {
    private final CraftEntity entity;

    public FoliaEntityScheduler(CraftEntity entity) {
        this.entity = entity;
    }

    private static Consumer<? extends Entity> wrap(Plugin plugin, Runnable runnable) {
        Validate.notNull(plugin, "Plugin may not be null");
        Validate.notNull(runnable, "Runnable may not be null");
        return nmsEntity -> {
            if (!plugin.isEnabled()) {
                return;
            }
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                plugin.getLogger().log(Level.WARNING, "Entity task for " + plugin.getDescription().getFullName() + " generated an exception", throwable);
            }
        };
    }

    public boolean execute(Plugin plugin, Runnable run, Runnable retired, long delay) {
        Consumer<? extends Entity> runNMS = FoliaEntityScheduler.wrap(plugin, run);
        Consumer<? extends Entity> runRetired = retired == null ? null : FoliaEntityScheduler.wrap(plugin, retired);
        return this.entity.taskScheduler.schedule(runNMS, runRetired, delay);
    }

    @Nullable
    public ScheduledTask run(Plugin plugin, Consumer<ScheduledTask> task, Runnable retired) {
        return this.runDelayed(plugin, task, retired, 1L);
    }

    @Nullable
    public ScheduledTask runDelayed(Plugin plugin, Consumer<ScheduledTask> task, Runnable retired, long delayTicks) {
        Validate.notNull(plugin, "Plugin may not be null");
        Validate.notNull(task, "Task may not be null");
        if (delayTicks <= 0L) {
            throw new IllegalArgumentException("Delay ticks may not be <= 0");
        }
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register task while disabled");
        }
        EntityScheduledTask ret = new EntityScheduledTask(plugin, -1L, task, retired);
        if (!this.scheduleInternal(ret, delayTicks)) {
            return null;
        }
        if (!plugin.isEnabled()) {
            ret.cancel();
        }
        return ret;
    }

    @Nullable
    public ScheduledTask runAtFixedRate(Plugin plugin, Consumer<ScheduledTask> task, Runnable retired, long initialDelayTicks, long periodTicks) {
        Validate.notNull(plugin, "Plugin may not be null");
        Validate.notNull(task, "Task may not be null");
        if (initialDelayTicks <= 0L) {
            throw new IllegalArgumentException("Initial delay ticks may not be <= 0");
        }
        if (periodTicks <= 0L) {
            throw new IllegalArgumentException("Period ticks may not be <= 0");
        }
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register task while disabled");
        }
        EntityScheduledTask ret = new EntityScheduledTask(plugin, periodTicks, task, retired);
        if (!this.scheduleInternal(ret, initialDelayTicks)) {
            return null;
        }
        if (!plugin.isEnabled()) {
            ret.cancel();
        }
        return ret;
    }

    private boolean scheduleInternal(EntityScheduledTask ret, long delay) {
        return this.entity.taskScheduler.schedule(ret, ret, delay);
    }

    private final class EntityScheduledTask
    implements ScheduledTask,
    Consumer<Entity> {
        private static final int STATE_IDLE = 0;
        private static final int STATE_EXECUTING = 1;
        private static final int STATE_EXECUTING_CANCELLED = 2;
        private static final int STATE_FINISHED = 3;
        private static final int STATE_CANCELLED = 4;
        private final Plugin plugin;
        private final long repeatDelay;
        private Consumer<ScheduledTask> run;
        private Runnable retired;
        private volatile int state;
        private static final VarHandle STATE_HANDLE = ConcurrentUtil.getVarHandle(EntityScheduledTask.class, "state", Integer.TYPE);

        private EntityScheduledTask(Plugin plugin, long repeatDelay, Consumer<ScheduledTask> run, Runnable retired) {
            this.plugin = plugin;
            this.repeatDelay = repeatDelay;
            this.run = run;
            this.retired = retired;
        }

        private final int getStateVolatile() {
            return STATE_HANDLE.get(this);
        }

        private final int compareAndExchangeStateVolatile(int expect, int update) {
            return STATE_HANDLE.compareAndExchange(this, expect, update);
        }

        private final void setStateVolatile(int value) {
            STATE_HANDLE.setVolatile(this, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Entity entity) {
            if (!this.plugin.isEnabled()) {
                this.setStateVolatile(4);
                return;
            }
            boolean repeating = this.isRepeatingTask();
            if (0 != this.compareAndExchangeStateVolatile(0, 1)) {
                return;
            }
            boolean retired = entity.dH();
            try {
                if (!retired) {
                    this.run.accept(this);
                } else if (this.retired != null) {
                    this.retired.run();
                }
            }
            catch (Throwable throwable) {
                this.plugin.getLogger().log(Level.WARNING, "Entity task for " + this.plugin.getDescription().getFullName() + " generated an exception", throwable);
            }
            finally {
                boolean reschedule = false;
                if (!repeating && !retired) {
                    this.setStateVolatile(3);
                } else if (retired || !this.plugin.isEnabled()) {
                    this.setStateVolatile(4);
                } else if (1 == this.compareAndExchangeStateVolatile(1, 0)) {
                    reschedule = true;
                }
                if (!reschedule) {
                    this.run = null;
                    this.retired = null;
                } else if (!FoliaEntityScheduler.this.scheduleInternal(this, this.repeatDelay)) {
                    this.setStateVolatile(4);
                }
            }
        }

        public Plugin getOwningPlugin() {
            return this.plugin;
        }

        public boolean isRepeatingTask() {
            return this.repeatDelay > 0L;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ScheduledTask.CancelledState cancel() {
            int curr = this.getStateVolatile();
            block7: while (true) {
                switch (curr) {
                    case 0: {
                        curr = this.compareAndExchangeStateVolatile(0, 4);
                        if (0 != curr) continue block7;
                        this.state = 4;
                        this.run = null;
                        this.retired = null;
                        return ScheduledTask.CancelledState.CANCELLED_BY_CALLER;
                    }
                    case 1: {
                        if (!this.isRepeatingTask()) {
                            return ScheduledTask.CancelledState.RUNNING;
                        }
                        curr = this.compareAndExchangeStateVolatile(1, 2);
                        if (1 == curr) return ScheduledTask.CancelledState.NEXT_RUNS_CANCELLED;
                        continue block7;
                    }
                    case 2: {
                        return ScheduledTask.CancelledState.NEXT_RUNS_CANCELLED_ALREADY;
                    }
                    case 3: {
                        return ScheduledTask.CancelledState.ALREADY_EXECUTED;
                    }
                    case 4: {
                        return ScheduledTask.CancelledState.CANCELLED_ALREADY;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unknown state: " + curr);
        }

        public ScheduledTask.ExecutionState getExecutionState() {
            int state = this.getStateVolatile();
            switch (state) {
                case 0: {
                    return ScheduledTask.ExecutionState.IDLE;
                }
                case 1: {
                    return ScheduledTask.ExecutionState.RUNNING;
                }
                case 2: {
                    return ScheduledTask.ExecutionState.CANCELLED_RUNNING;
                }
                case 3: {
                    return ScheduledTask.ExecutionState.FINISHED;
                }
                case 4: {
                    return ScheduledTask.ExecutionState.CANCELLED;
                }
            }
            throw new IllegalStateException("Unknown state: " + state);
        }
    }
}

