/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.WorldUtil;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceSection;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;

public final class PoiAccess {
    protected static double clamp(double val, double min, double max) {
        return val < min ? min : (val > max ? max : val);
    }

    protected static double getSmallestDistanceSquared(double boxMinX, double boxMinY, double boxMinZ, double boxMaxX, double boxMaxY, double boxMaxZ, double circleX, double circleY, double circleZ) {
        if (circleX >= boxMinX && circleX <= boxMaxX && circleY >= boxMinY && circleY <= boxMaxY && circleZ >= boxMinZ && circleZ <= boxMaxZ) {
            return 0.0;
        }
        double boxWidthX = (boxMaxX - boxMinX) / 2.0;
        double boxWidthY = (boxMaxY - boxMinY) / 2.0;
        double boxWidthZ = (boxMaxZ - boxMinZ) / 2.0;
        double boxCenterX = (boxMinX + boxMaxX) / 2.0;
        double boxCenterY = (boxMinY + boxMaxY) / 2.0;
        double boxCenterZ = (boxMinZ + boxMaxZ) / 2.0;
        double centerDiffX = circleX - boxCenterX;
        double centerDiffY = circleY - boxCenterY;
        double centerDiffZ = circleZ - boxCenterZ;
        centerDiffX = circleX - (PoiAccess.clamp(centerDiffX, -boxWidthX, boxWidthX) + boxCenterX);
        centerDiffY = circleY - (PoiAccess.clamp(centerDiffY, -boxWidthY, boxWidthY) + boxCenterY);
        centerDiffZ = circleZ - (PoiAccess.clamp(centerDiffZ, -boxWidthZ, boxWidthZ) + boxCenterZ);
        return centerDiffX * centerDiffX + centerDiffY * centerDiffY + centerDiffZ * centerDiffZ;
    }

    protected static long getKey(int minSection, int maxSection, int section, int radius) {
        return ((long)maxSection & 0xFFFFL) << 48 | ((long)minSection & 0xFFFFL) << 32 | ((long)section & 0xFFFFL) << 16 | ((long)radius & 0xFFFFL) << 0;
    }

    public static BlockPosition findClosestPoiDataPosition(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load) {
        VillagePlaceRecord ret = PoiAccess.findClosestPoiDataRecord(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load);
        return ret == null ? null : ret.f();
    }

    public static Pair<Holder<VillagePlaceType>, BlockPosition> findClosestPoiDataTypeAndPosition(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load) {
        VillagePlaceRecord ret = PoiAccess.findClosestPoiDataRecord(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load);
        return ret == null ? null : Pair.of(ret.g(), (Object)ret.f());
    }

    public static void findClosestPoiDataPositions(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load, Set<BlockPosition> ret) {
        HashSet positions = new HashSet();
        Predicate<BlockPosition> newPredicate = pos -> {
            if (positionPredicate != null && !positionPredicate.test((BlockPosition)pos)) {
                return false;
            }
            return positions.add(pos.i());
        };
        ArrayList<VillagePlaceRecord> toConvert = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findClosestPoiDataRecords(poiStorage, villagePlaceType, newPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load, toConvert);
        for (VillagePlaceRecord record : toConvert) {
            ret.add(record.f());
        }
    }

    public static VillagePlaceRecord findClosestPoiDataRecord(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load) {
        ArrayList<VillagePlaceRecord> ret = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findClosestPoiDataRecords(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load, ret);
        return ret.isEmpty() ? null : (VillagePlaceRecord)ret.get(0);
    }

    public static VillagePlaceRecord findClosestPoiDataRecord(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, BiPredicate<Holder<VillagePlaceType>, BlockPosition> predicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load) {
        ArrayList<VillagePlaceRecord> ret = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findClosestPoiDataRecords(poiStorage, villagePlaceType, predicate, sourcePosition, range, maxDistanceSquared, occupancy, load, ret);
        return ret.isEmpty() ? null : (VillagePlaceRecord)ret.get(0);
    }

    public static void findClosestPoiDataRecords(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load, List<VillagePlaceRecord> ret) {
        BiPredicate<Holder<VillagePlaceType>, BlockPosition> predicate = positionPredicate != null ? (type, pos) -> positionPredicate.test((BlockPosition)pos) : null;
        PoiAccess.findClosestPoiDataRecords(poiStorage, villagePlaceType, predicate, sourcePosition, range, maxDistanceSquared, occupancy, load, ret);
    }

    public static void findClosestPoiDataRecords(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, BiPredicate<Holder<VillagePlaceType>, BlockPosition> predicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load, List<VillagePlaceRecord> ret) {
        Predicate<? super VillagePlaceRecord> occupancyFilter = occupancy.a();
        ArrayList<VillagePlaceRecord> closestRecords = new ArrayList<VillagePlaceRecord>();
        double closestDistanceSquared = maxDistanceSquared;
        int lowerX = MathHelper.d((float)(sourcePosition.u() - range)) >> 4;
        int lowerY = WorldUtil.getMinSection(poiStorage.world);
        int lowerZ = MathHelper.d((float)(sourcePosition.w() - range)) >> 4;
        int upperX = MathHelper.d((float)(sourcePosition.u() + range)) >> 4;
        int upperY = WorldUtil.getMaxSection(poiStorage.world);
        int upperZ = MathHelper.d((float)(sourcePosition.w() + range)) >> 4;
        int centerX = sourcePosition.u() >> 4;
        int centerY = MathHelper.a(sourcePosition.v() >> 4, lowerY, upperY);
        int centerZ = sourcePosition.w() >> 4;
        long centerKey = CoordinateUtils.getChunkSectionKey(centerX, centerY, centerZ);
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        LongOpenHashSet seen = new LongOpenHashSet();
        seen.add(centerKey);
        queue.enqueue(centerKey);
        while (!queue.isEmpty()) {
            VillagePlaceSection poiSection;
            Map<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> sectionData;
            double sectionDistanceSquared;
            long key = queue.dequeueLong();
            int sectionX = CoordinateUtils.getChunkSectionX(key);
            int sectionY = CoordinateUtils.getChunkSectionY(key);
            int sectionZ = CoordinateUtils.getChunkSectionZ(key);
            if (sectionX < lowerX || sectionX > upperX || sectionY < lowerY || sectionY > upperY || sectionZ < lowerZ || sectionZ > upperZ || (sectionDistanceSquared = PoiAccess.getSmallestDistanceSquared((double)(sectionX << 4) + 0.5, (double)(sectionY << 4) + 0.5, (double)(sectionZ << 4) + 0.5, (double)(sectionX << 4) + 15.5, (double)(sectionY << 4) + 15.5, (double)(sectionZ << 4) + 15.5, sourcePosition.u(), sourcePosition.v(), sourcePosition.w())) > closestDistanceSquared) continue;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        int neighbourZ;
                        int neighbourY;
                        int neighbourX;
                        long neighbourKey;
                        if ((dx & 1) + (dy & 1) + (dz & 1) != 1 || !seen.add(neighbourKey = CoordinateUtils.getChunkSectionKey(neighbourX = sectionX + dx, neighbourY = sectionY + dy, neighbourZ = sectionZ + dz))) continue;
                        queue.enqueue(neighbourKey);
                    }
                }
            }
            Optional<VillagePlaceSection> poiSectionOptional = load ? poiStorage.d(key) : poiStorage.c(key);
            if (poiSectionOptional == null || !poiSectionOptional.isPresent() || (sectionData = (poiSection = poiSectionOptional.get()).getData()).isEmpty()) continue;
            for (Map.Entry<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> entry : sectionData.entrySet()) {
                if (!villagePlaceType.test(entry.getKey())) continue;
                for (VillagePlaceRecord poiData : entry.getValue()) {
                    double dataRange;
                    BlockPosition poiPosition;
                    if (!occupancyFilter.test(poiData) || Math.abs((poiPosition = poiData.f()).u() - sourcePosition.u()) > range || Math.abs(poiPosition.w() - sourcePosition.w()) > range || (dataRange = poiPosition.j(sourcePosition)) > closestDistanceSquared || predicate != null && !predicate.test(poiData.g(), poiPosition)) continue;
                    if (dataRange < closestDistanceSquared) {
                        closestRecords.clear();
                        closestDistanceSquared = dataRange;
                    }
                    closestRecords.add(poiData);
                }
            }
        }
        closestRecords.sort((record1, record2) -> {
            BlockPosition pos1 = record1.f();
            BlockPosition pos2 = record2.f();
            int cx1 = pos1.u() >> 4;
            int cz1 = pos1.w() >> 4;
            int cx2 = pos2.u() >> 4;
            int cz2 = pos2.w() >> 4;
            if (cz2 != cz1) {
                return Integer.compare(cz1, cz2);
            }
            if (cx2 != cx1) {
                return Integer.compare(cx1, cx2);
            }
            return Integer.compare(pos1.v() >> 4, pos2.v() >> 4);
        });
        ret.addAll(closestRecords);
    }

    public static BlockPosition findNearestPoiPosition(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load) {
        VillagePlaceRecord ret = PoiAccess.findNearestPoiRecord(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load);
        return ret == null ? null : ret.f();
    }

    public static void findNearestPoiPositions(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load, int max, List<Pair<Holder<VillagePlaceType>, BlockPosition>> ret) {
        HashSet positions = new HashSet();
        Predicate<BlockPosition> newPredicate = pos -> {
            if (positionPredicate != null && !positionPredicate.test((BlockPosition)pos)) {
                return false;
            }
            return positions.add(pos.i());
        };
        ArrayList<VillagePlaceRecord> toConvert = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findNearestPoiRecords(poiStorage, villagePlaceType, newPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load, max, toConvert);
        for (VillagePlaceRecord record : toConvert) {
            ret.add((Pair<Holder<VillagePlaceType>, BlockPosition>)Pair.of(record.g(), (Object)record.f()));
        }
    }

    public static VillagePlaceRecord findNearestPoiRecord(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load) {
        ArrayList<VillagePlaceRecord> ret = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findNearestPoiRecords(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, maxDistanceSquared, occupancy, load, 1, ret);
        return ret.isEmpty() ? null : (VillagePlaceRecord)ret.get(0);
    }

    public static void findNearestPoiRecords(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, double maxDistanceSquared, VillagePlace.Occupancy occupancy, boolean load, int max, List<VillagePlaceRecord> ret) {
        Predicate<? super VillagePlaceRecord> occupancyFilter = occupancy.a();
        Double2ObjectRBTreeMap closestRecords = new Double2ObjectRBTreeMap();
        int totalRecords = 0;
        double furthestDistanceSquared = maxDistanceSquared;
        int lowerX = MathHelper.d((float)(sourcePosition.u() - range)) >> 4;
        int lowerY = WorldUtil.getMinSection(poiStorage.world);
        int lowerZ = MathHelper.d((float)(sourcePosition.w() - range)) >> 4;
        int upperX = MathHelper.d((float)(sourcePosition.u() + range)) >> 4;
        int upperY = WorldUtil.getMaxSection(poiStorage.world);
        int upperZ = MathHelper.d((float)(sourcePosition.w() + range)) >> 4;
        int centerX = sourcePosition.u() >> 4;
        int centerY = MathHelper.a(sourcePosition.v() >> 4, lowerY, upperY);
        int centerZ = sourcePosition.w() >> 4;
        long centerKey = CoordinateUtils.getChunkSectionKey(centerX, centerY, centerZ);
        LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
        LongOpenHashSet seen = new LongOpenHashSet();
        seen.add(centerKey);
        queue.enqueue(centerKey);
        while (!queue.isEmpty()) {
            VillagePlaceSection poiSection;
            Map<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> sectionData;
            long key = queue.dequeueLong();
            int sectionX = CoordinateUtils.getChunkSectionX(key);
            int sectionY = CoordinateUtils.getChunkSectionY(key);
            int sectionZ = CoordinateUtils.getChunkSectionZ(key);
            if (sectionX < lowerX || sectionX > upperX || sectionY < lowerY || sectionY > upperY || sectionZ < lowerZ || sectionZ > upperZ) continue;
            double sectionDistanceSquared = PoiAccess.getSmallestDistanceSquared((double)(sectionX << 4) + 0.5, (double)(sectionY << 4) + 0.5, (double)(sectionZ << 4) + 0.5, (double)(sectionX << 4) + 15.5, (double)(sectionY << 4) + 15.5, (double)(sectionZ << 4) + 15.5, sourcePosition.u(), sourcePosition.v(), sourcePosition.w());
            if (sectionDistanceSquared > (totalRecords >= max ? furthestDistanceSquared : maxDistanceSquared)) continue;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        int neighbourZ;
                        int neighbourY;
                        int neighbourX;
                        long neighbourKey;
                        if ((dx & 1) + (dy & 1) + (dz & 1) != 1 || !seen.add(neighbourKey = CoordinateUtils.getChunkSectionKey(neighbourX = sectionX + dx, neighbourY = sectionY + dy, neighbourZ = sectionZ + dz))) continue;
                        queue.enqueue(neighbourKey);
                    }
                }
            }
            Optional<VillagePlaceSection> poiSectionOptional = load ? poiStorage.d(key) : poiStorage.c(key);
            if (poiSectionOptional == null || !poiSectionOptional.isPresent() || (sectionData = (poiSection = poiSectionOptional.get()).getData()).isEmpty()) continue;
            for (Map.Entry<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> entry : sectionData.entrySet()) {
                if (!villagePlaceType.test(entry.getKey())) continue;
                for (VillagePlaceRecord poiData : entry.getValue()) {
                    double dataRange;
                    BlockPosition poiPosition;
                    if (!occupancyFilter.test(poiData) || Math.abs((poiPosition = poiData.f()).u() - sourcePosition.u()) > range || Math.abs(poiPosition.w() - sourcePosition.w()) > range || (dataRange = poiPosition.j(sourcePosition)) > maxDistanceSquared || dataRange > furthestDistanceSquared && totalRecords >= max || positionPredicate != null && !positionPredicate.test(poiPosition)) continue;
                    if (dataRange > furthestDistanceSquared) {
                        furthestDistanceSquared = dataRange;
                    }
                    ((List)closestRecords.computeIfAbsent(dataRange, unused -> new ArrayList())).add(poiData);
                    if (++totalRecords < max || closestRecords.size() < 2) continue;
                    int entriesInClosest = 0;
                    ObjectBidirectionalIterator iterator = closestRecords.double2ObjectEntrySet().iterator();
                    double nextFurthestDistanceSquared = 0.0;
                    int len = closestRecords.size() - 1;
                    for (int i2 = 0; i2 < len; ++i2) {
                        Double2ObjectMap.Entry recordEntry = (Double2ObjectMap.Entry)iterator.next();
                        entriesInClosest += ((List)recordEntry.getValue()).size();
                        nextFurthestDistanceSquared = recordEntry.getDoubleKey();
                    }
                    if (entriesInClosest < max) continue;
                    Double2ObjectMap.Entry recordEntry = (Double2ObjectMap.Entry)iterator.next();
                    totalRecords -= ((List)recordEntry.getValue()).size();
                    iterator.remove();
                    furthestDistanceSquared = nextFurthestDistanceSquared;
                }
            }
        }
        ArrayList closestRecordsUnsorted = new ArrayList();
        for (List records : closestRecords.values()) {
            closestRecordsUnsorted.addAll(records);
        }
        closestRecordsUnsorted.sort((record1, record2) -> {
            BlockPosition pos1 = record1.f();
            BlockPosition pos2 = record2.f();
            int cx1 = pos1.u() >> 4;
            int cz1 = pos1.w() >> 4;
            int cx2 = pos2.u() >> 4;
            int cz2 = pos2.w() >> 4;
            if (cz2 != cz1) {
                return Integer.compare(cz1, cz2);
            }
            if (cx2 != cx1) {
                return Integer.compare(cx1, cx2);
            }
            return Integer.compare(pos1.v() >> 4, pos2.v() >> 4);
        });
        for (int i3 = closestRecordsUnsorted.size() - 1; i3 >= max; --i3) {
            closestRecordsUnsorted.remove(i3);
        }
        ret.addAll(closestRecordsUnsorted);
    }

    public static BlockPosition findAnyPoiPosition(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, VillagePlace.Occupancy occupancy, boolean load) {
        VillagePlaceRecord ret = PoiAccess.findAnyPoiRecord(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, occupancy, load);
        return ret == null ? null : ret.f();
    }

    public static void findAnyPoiPositions(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, VillagePlace.Occupancy occupancy, boolean load, int max, List<Pair<Holder<VillagePlaceType>, BlockPosition>> ret) {
        HashSet positions = new HashSet();
        Predicate<BlockPosition> newPredicate = pos -> {
            if (positionPredicate != null && !positionPredicate.test((BlockPosition)pos)) {
                return false;
            }
            return positions.add(pos.i());
        };
        ArrayList<VillagePlaceRecord> toConvert = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findAnyPoiRecords(poiStorage, villagePlaceType, newPredicate, sourcePosition, range, occupancy, load, max, toConvert);
        for (VillagePlaceRecord record : toConvert) {
            ret.add((Pair<Holder<VillagePlaceType>, BlockPosition>)Pair.of(record.g(), (Object)record.f()));
        }
    }

    public static VillagePlaceRecord findAnyPoiRecord(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, VillagePlace.Occupancy occupancy, boolean load) {
        ArrayList<VillagePlaceRecord> ret = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findAnyPoiRecords(poiStorage, villagePlaceType, positionPredicate, sourcePosition, range, occupancy, load, 1, ret);
        return ret.isEmpty() ? null : (VillagePlaceRecord)ret.get(0);
    }

    public static void findAnyPoiRecords(VillagePlace poiStorage, Predicate<Holder<VillagePlaceType>> villagePlaceType, Predicate<BlockPosition> positionPredicate, BlockPosition sourcePosition, int range, VillagePlace.Occupancy occupancy, boolean load, int max, List<VillagePlaceRecord> ret) {
        Predicate<? super VillagePlaceRecord> occupancyFilter = occupancy.a();
        double rangeSquared = range * range;
        int added = 0;
        int lowerX = MathHelper.d((float)(sourcePosition.u() - range)) >> 4;
        int lowerY = Math.max(WorldUtil.getMinSection(poiStorage.world), MathHelper.d((float)(sourcePosition.v() - range)) >> 4);
        int lowerZ = MathHelper.d((float)(sourcePosition.w() - range)) >> 4;
        int upperX = MathHelper.d((float)(sourcePosition.u() + range)) >> 4;
        int upperY = Math.min(WorldUtil.getMaxSection(poiStorage.world), MathHelper.d((float)(sourcePosition.v() + range)) >> 4);
        int upperZ = MathHelper.d((float)(sourcePosition.w() + range)) >> 4;
        for (int currZ = lowerZ; currZ <= upperZ; ++currZ) {
            for (int currX = lowerX; currX <= upperX; ++currX) {
                for (int currY = lowerY; currY <= upperY; ++currY) {
                    Map<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> sectionData;
                    VillagePlaceSection poiSection;
                    Optional<VillagePlaceSection> poiSectionOptional = load ? poiStorage.d(CoordinateUtils.getChunkSectionKey(currX, currY, currZ)) : poiStorage.c(CoordinateUtils.getChunkSectionKey(currX, currY, currZ));
                    VillagePlaceSection villagePlaceSection = poiSection = poiSectionOptional == null ? null : (VillagePlaceSection)poiSectionOptional.orElse(null);
                    if (poiSection == null || (sectionData = poiSection.getData()).isEmpty()) continue;
                    for (Map.Entry<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> entry : sectionData.entrySet()) {
                        if (!villagePlaceType.test(entry.getKey())) continue;
                        for (VillagePlaceRecord poiData : entry.getValue()) {
                            BlockPosition poiPosition;
                            if (!occupancyFilter.test(poiData) || Math.abs((poiPosition = poiData.f()).u() - sourcePosition.u()) > range || Math.abs(poiPosition.w() - sourcePosition.w()) > range || poiPosition.j(sourcePosition) > rangeSquared || positionPredicate != null && !positionPredicate.test(poiPosition)) continue;
                            ret.add(poiData);
                            if (++added < max) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    private PoiAccess() {
        throw new RuntimeException();
    }
}

