/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.sun.security.auth.module.NTSystem;
import com.sun.security.auth.module.UnixSystem;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.lang.SystemUtils;

public class ServerEnvironment {
    private static final boolean RUNNING_AS_ROOT_OR_ADMIN;
    private static final String WINDOWS_HIGH_INTEGRITY_LEVEL = "S-1-16-12288";

    public static boolean userIsRootOrAdmin() {
        return RUNNING_AS_ROOT_OR_ADMIN;
    }

    public static String awtDependencyCheck() {
        try {
            new Color(0);
        }
        catch (UnsatisfiedLinkError e2) {
            return e2.getClass().getName() + ": " + e2.getMessage();
        }
        return null;
    }

    static {
        if (SystemUtils.IS_OS_WINDOWS) {
            RUNNING_AS_ROOT_OR_ADMIN = Set.of(new NTSystem().getGroupIDs()).contains(WINDOWS_HIGH_INTEGRITY_LEVEL);
        } else {
            boolean isRunningAsRoot = false;
            if (new UnixSystem().getUid() == 0L) {
                try {
                    Process process = new ProcessBuilder("id", "-u").start();
                    process.waitFor();
                    InputStream inputStream = process.getInputStream();
                    isRunningAsRoot = new String(inputStream.readAllBytes()).trim().equals("0");
                }
                catch (IOException | InterruptedException ignored) {
                    isRunningAsRoot = false;
                }
            }
            RUNNING_AS_ROOT_OR_ADMIN = isRunningAsRoot;
        }
    }
}

