/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionConditionEnchantments;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;

public final class CriterionConditionItem
extends Record {
    private final Optional<TagKey<Item>> b;
    private final Optional<HolderSet<Item>> c;
    private final CriterionConditionValue.IntegerRange d;
    private final CriterionConditionValue.IntegerRange e;
    private final List<CriterionConditionEnchantments> f;
    private final List<CriterionConditionEnchantments> g;
    private final Optional<Holder<PotionRegistry>> h;
    private final Optional<CriterionConditionNBT> i;
    private static final Codec<HolderSet<Item>> j = BuiltInRegistries.h.r().listOf().xmap(HolderSet::a, items -> items.a().toList());
    public static final Codec<CriterionConditionItem> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(TagKey.a(Registries.F), "tag").forGetter(CriterionConditionItem::a), (App)ExtraCodecs.a(j, "items").forGetter(CriterionConditionItem::b), (App)ExtraCodecs.a(CriterionConditionValue.IntegerRange.d, "count", CriterionConditionValue.IntegerRange.c).forGetter(CriterionConditionItem::c), (App)ExtraCodecs.a(CriterionConditionValue.IntegerRange.d, "durability", CriterionConditionValue.IntegerRange.c).forGetter(CriterionConditionItem::d), (App)ExtraCodecs.a(CriterionConditionEnchantments.a.listOf(), "enchantments", List.of()).forGetter(CriterionConditionItem::e), (App)ExtraCodecs.a(CriterionConditionEnchantments.a.listOf(), "stored_enchantments", List.of()).forGetter(CriterionConditionItem::f), (App)ExtraCodecs.a(BuiltInRegistries.i.r(), "potion").forGetter(CriterionConditionItem::g), (App)ExtraCodecs.a(CriterionConditionNBT.a, "nbt").forGetter(CriterionConditionItem::h)).apply((Applicative)instance, CriterionConditionItem::new));

    public CriterionConditionItem(Optional<TagKey<Item>> optional, Optional<HolderSet<Item>> optional2, CriterionConditionValue.IntegerRange count, CriterionConditionValue.IntegerRange durability, List<CriterionConditionEnchantments> list, List<CriterionConditionEnchantments> list2, Optional<Holder<PotionRegistry>> optional3, Optional<CriterionConditionNBT> optional4) {
        this.b = optional;
        this.c = optional2;
        this.d = count;
        this.e = durability;
        this.f = list;
        this.g = list2;
        this.h = optional3;
        this.i = optional4;
    }

    public boolean a(ItemStack stack) {
        if (this.b.isPresent() && !stack.a(this.b.get())) {
            return false;
        }
        if (this.c.isPresent() && !stack.a(this.c.get())) {
            return false;
        }
        if (!this.d.d(stack.L())) {
            return false;
        }
        if (!this.e.c() && !stack.i()) {
            return false;
        }
        if (!this.e.d(stack.l() - stack.k())) {
            return false;
        }
        if (this.i.isPresent() && !this.i.get().a(stack)) {
            return false;
        }
        if (!this.f.isEmpty()) {
            Map<Enchantment, Integer> map = EnchantmentManager.a(stack.x());
            for (CriterionConditionEnchantments enchantmentPredicate : this.f) {
                if (enchantmentPredicate.a(map)) continue;
                return false;
            }
        }
        if (!this.g.isEmpty()) {
            Map<Enchantment, Integer> map2 = EnchantmentManager.a(ItemEnchantedBook.d(stack));
            for (CriterionConditionEnchantments enchantmentPredicate2 : this.g) {
                if (enchantmentPredicate2.a(map2)) continue;
                return false;
            }
        }
        return !this.h.isPresent() || this.h.get().a() == PotionUtil.d(stack);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CriterionConditionItem.class, "tag;items;count;durability;enchantments;storedEnchantments;potion;nbt", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CriterionConditionItem.class, "tag;items;count;durability;enchantments;storedEnchantments;potion;nbt", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CriterionConditionItem.class, "tag;items;count;durability;enchantments;storedEnchantments;potion;nbt", "b", "c", "d", "e", "f", "g", "h", "i"}, this, object);
    }

    public Optional<TagKey<Item>> a() {
        return this.b;
    }

    public Optional<HolderSet<Item>> b() {
        return this.c;
    }

    public CriterionConditionValue.IntegerRange c() {
        return this.d;
    }

    public CriterionConditionValue.IntegerRange d() {
        return this.e;
    }

    public List<CriterionConditionEnchantments> e() {
        return this.f;
    }

    public List<CriterionConditionEnchantments> f() {
        return this.g;
    }

    public Optional<Holder<PotionRegistry>> g() {
        return this.h;
    }

    public Optional<CriterionConditionNBT> h() {
        return this.i;
    }

    public static class a {
        private final ImmutableList.Builder<CriterionConditionEnchantments> a = ImmutableList.builder();
        private final ImmutableList.Builder<CriterionConditionEnchantments> b = ImmutableList.builder();
        private Optional<HolderSet<Item>> c = Optional.empty();
        private Optional<TagKey<Item>> d = Optional.empty();
        private CriterionConditionValue.IntegerRange e = CriterionConditionValue.IntegerRange.c;
        private CriterionConditionValue.IntegerRange f = CriterionConditionValue.IntegerRange.c;
        private Optional<Holder<PotionRegistry>> g = Optional.empty();
        private Optional<CriterionConditionNBT> h = Optional.empty();

        private a() {
        }

        public static a a() {
            return new a();
        }

        public a a(IMaterial ... items) {
            this.c = Optional.of(HolderSet.a(item -> item.k().j(), items));
            return this;
        }

        public a a(TagKey<Item> tag) {
            this.d = Optional.of(tag);
            return this;
        }

        public a a(CriterionConditionValue.IntegerRange count) {
            this.e = count;
            return this;
        }

        public a b(CriterionConditionValue.IntegerRange durability) {
            this.f = durability;
            return this;
        }

        public a a(PotionRegistry potion) {
            this.g = Optional.of(potion.c());
            return this;
        }

        public a a(NBTTagCompound nbt) {
            this.h = Optional.of(new CriterionConditionNBT(nbt));
            return this;
        }

        public a a(CriterionConditionEnchantments enchantment) {
            this.a.add((Object)enchantment);
            return this;
        }

        public a b(CriterionConditionEnchantments enchantment) {
            this.b.add((Object)enchantment);
            return this;
        }

        public CriterionConditionItem b() {
            ImmutableList list = this.a.build();
            ImmutableList list2 = this.b.build();
            return new CriterionConditionItem(this.d, this.c, this.e, this.f, (List<CriterionConditionEnchantments>)list, (List<CriterionConditionEnchantments>)list2, this.g, this.h);
        }
    }
}

