/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.brigadier.PaperBrigadier;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.GameTestHarnessTestCommand;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutCommands;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandAdvancement;
import net.minecraft.server.commands.CommandAttribute;
import net.minecraft.server.commands.CommandBan;
import net.minecraft.server.commands.CommandBanIp;
import net.minecraft.server.commands.CommandBanList;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandClear;
import net.minecraft.server.commands.CommandClone;
import net.minecraft.server.commands.CommandDatapack;
import net.minecraft.server.commands.CommandDeop;
import net.minecraft.server.commands.CommandDifficulty;
import net.minecraft.server.commands.CommandEffect;
import net.minecraft.server.commands.CommandEnchant;
import net.minecraft.server.commands.CommandExecute;
import net.minecraft.server.commands.CommandFill;
import net.minecraft.server.commands.CommandForceload;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.commands.CommandGamemodeDefault;
import net.minecraft.server.commands.CommandGamerule;
import net.minecraft.server.commands.CommandGive;
import net.minecraft.server.commands.CommandHelp;
import net.minecraft.server.commands.CommandIdleTimeout;
import net.minecraft.server.commands.CommandKick;
import net.minecraft.server.commands.CommandKill;
import net.minecraft.server.commands.CommandList;
import net.minecraft.server.commands.CommandLocate;
import net.minecraft.server.commands.CommandLoot;
import net.minecraft.server.commands.CommandMe;
import net.minecraft.server.commands.CommandOp;
import net.minecraft.server.commands.CommandPardon;
import net.minecraft.server.commands.CommandPardonIP;
import net.minecraft.server.commands.CommandParticle;
import net.minecraft.server.commands.CommandPlaySound;
import net.minecraft.server.commands.CommandPublish;
import net.minecraft.server.commands.CommandRecipe;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.commands.CommandSaveAll;
import net.minecraft.server.commands.CommandSaveOff;
import net.minecraft.server.commands.CommandSaveOn;
import net.minecraft.server.commands.CommandSay;
import net.minecraft.server.commands.CommandSchedule;
import net.minecraft.server.commands.CommandScoreboard;
import net.minecraft.server.commands.CommandSeed;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.commands.CommandSetWorldSpawn;
import net.minecraft.server.commands.CommandSpawnpoint;
import net.minecraft.server.commands.CommandSpectate;
import net.minecraft.server.commands.CommandSpreadPlayers;
import net.minecraft.server.commands.CommandStop;
import net.minecraft.server.commands.CommandStopSound;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.CommandTag;
import net.minecraft.server.commands.CommandTeam;
import net.minecraft.server.commands.CommandTeamMsg;
import net.minecraft.server.commands.CommandTeleport;
import net.minecraft.server.commands.CommandTell;
import net.minecraft.server.commands.CommandTellRaw;
import net.minecraft.server.commands.CommandTime;
import net.minecraft.server.commands.CommandTitle;
import net.minecraft.server.commands.CommandTrigger;
import net.minecraft.server.commands.CommandWeather;
import net.minecraft.server.commands.CommandWhitelist;
import net.minecraft.server.commands.CommandWorldBorder;
import net.minecraft.server.commands.CommandXp;
import net.minecraft.server.commands.DamageCommand;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.commands.DebugPathCommand;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.RaidCommand;
import net.minecraft.server.commands.RandomCommand;
import net.minecraft.server.commands.ResetChunksCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.server.commands.RideCommand;
import net.minecraft.server.commands.ServerPackCommand;
import net.minecraft.server.commands.SpawnArmorTrimsCommand;
import net.minecraft.server.commands.TickCommand;
import net.minecraft.server.commands.WardenSpawnTrackerCommand;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.level.GameRules;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.command.VanillaCommandWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.command.CompassCommand;
import org.purpurmc.purpur.command.CreditsCommand;
import org.purpurmc.purpur.command.DemoCommand;
import org.purpurmc.purpur.command.PingCommand;
import org.purpurmc.purpur.command.RamBarCommand;
import org.purpurmc.purpur.command.RamCommand;
import org.purpurmc.purpur.command.TPSBarCommand;
import org.purpurmc.purpur.command.UptimeCommand;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class CommandDispatcher {
    private static final ThreadLocal<ExecutionContext<CommandListenerWrapper>> f = new ThreadLocal();
    private static final Logger g = LogUtils.getLogger();
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;
    public static final int d = 3;
    public static final int e = 4;
    private final com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> h = new com.mojang.brigadier.CommandDispatcher();
    public final List<CommandNode<CommandListenerWrapper>> vanillaCommandNodes = new ArrayList<CommandNode<CommandListenerWrapper>>();
    public static final ThreadPoolExecutor COMMAND_SENDING_POOL = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Async Command Builder Thread Pool - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.l)).build(), new ThreadPoolExecutor.DiscardPolicy());

    public CommandDispatcher(ServerType environment, CommandBuildContext commandRegistryAccess) {
        this();
        CommandAdvancement.a(this.h);
        CommandAttribute.a(this.h, commandRegistryAccess);
        CommandExecute.a(this.h, commandRegistryAccess);
        CommandBossBar.a(this.h);
        CommandClear.a(this.h, commandRegistryAccess);
        CommandClone.a(this.h, commandRegistryAccess);
        DamageCommand.a(this.h, commandRegistryAccess);
        CommandData.a(this.h);
        CommandDatapack.a(this.h);
        CommandGamemodeDefault.a(this.h);
        CommandDifficulty.a(this.h);
        CommandEffect.a(this.h, commandRegistryAccess);
        CommandMe.a(this.h);
        CommandEnchant.a(this.h, commandRegistryAccess);
        CommandXp.a(this.h);
        CommandFill.a(this.h, commandRegistryAccess);
        FillBiomeCommand.a(this.h, commandRegistryAccess);
        CommandForceload.a(this.h);
        CommandFunction.a(this.h);
        CommandGamemode.a(this.h);
        CommandGamerule.a(this.h);
        CommandGive.a(this.h, commandRegistryAccess);
        CommandHelp.a(this.h);
        ItemCommands.a(this.h, commandRegistryAccess);
        CommandKick.a(this.h);
        CommandKill.a(this.h);
        CommandList.a(this.h);
        CommandLocate.a(this.h, commandRegistryAccess);
        CommandLoot.a(this.h, commandRegistryAccess);
        CommandTell.a(this.h);
        CommandParticle.a(this.h, commandRegistryAccess);
        PlaceCommand.a(this.h);
        CommandPlaySound.a(this.h);
        RandomCommand.a(this.h);
        CommandReload.a(this.h);
        CommandRecipe.a(this.h);
        ReturnCommand.a(this.h);
        RideCommand.a(this.h);
        CommandSay.a(this.h);
        CommandSchedule.a(this.h);
        CommandScoreboard.a(this.h);
        CommandSeed.a(this.h, environment != ServerType.c);
        CommandSetBlock.a(this.h, commandRegistryAccess);
        CommandSpawnpoint.a(this.h);
        CommandSetWorldSpawn.a(this.h);
        CommandSpectate.a(this.h);
        CommandSpreadPlayers.a(this.h);
        CommandStopSound.a(this.h);
        CommandSummon.a(this.h, commandRegistryAccess);
        CommandTag.a(this.h);
        CommandTeam.a(this.h);
        CommandTeamMsg.a(this.h);
        CommandTeleport.a(this.h);
        CommandTellRaw.a(this.h);
        TickCommand.a(this.h);
        CommandTime.a(this.h);
        CommandTitle.a(this.h);
        CommandTrigger.a(this.h);
        CommandWeather.a(this.h);
        CommandWorldBorder.a(this.h);
        if (JvmProfiler.e.d()) {
            JfrCommand.a(this.h);
        }
        if (PurpurConfig.registerMinecraftDebugCommands || SharedConstants.aW) {
            if (!PurpurConfig.registerMinecraftDebugCommands) {
                GameTestHarnessTestCommand.a(this.h);
            }
            ResetChunksCommand.a(this.h);
            RaidCommand.a(this.h);
            DebugPathCommand.a(this.h);
            DebugMobSpawningCommand.a(this.h);
            WardenSpawnTrackerCommand.a(this.h);
            SpawnArmorTrimsCommand.a(this.h);
            ServerPackCommand.a(this.h);
            if (environment.e) {
                DebugConfigCommand.a(this.h);
            }
        }
        if (environment.e) {
            CommandBanIp.a(this.h);
            CommandBanList.a(this.h);
            CommandBan.a(this.h);
            CommandDeop.a(this.h);
            CommandOp.a(this.h);
            CommandPardon.a(this.h);
            CommandPardonIP.a(this.h);
            PerfCommand.a(this.h);
            CommandSaveAll.a(this.h);
            CommandSaveOff.a(this.h);
            CommandSaveOn.a(this.h);
            CommandIdleTimeout.a(this.h);
            CommandStop.a(this.h);
            CommandWhitelist.a(this.h);
            CreditsCommand.register(this.h);
            DemoCommand.register(this.h);
            PingCommand.register(this.h);
            UptimeCommand.register(this.h);
            TPSBarCommand.register(this.h);
            CompassCommand.register(this.h);
            RamBarCommand.register(this.h);
            RamCommand.register(this.h);
        }
        if (environment.d) {
            CommandPublish.a(this.h);
        }
        this.vanillaCommandNodes.addAll(this.h.getRoot().getChildren());
        for (CommandNode node : this.h.getRoot().getChildren()) {
            if (node.getRequirement() != ArgumentBuilder.defaultRequirement()) continue;
            node.requirement = stack -> stack.c == ICommandListener.a || stack.getBukkitSender().hasPermission(VanillaCommandWrapper.getPermission(node));
        }
    }

    public CommandDispatcher() {
        this.h.setConsumer(ExecutionCommandSource.b_());
    }

    public static <S> ParseResults<S> a(ParseResults<S> parseResults, UnaryOperator<S> sourceMapper) {
        CommandContextBuilder commandcontextbuilder = parseResults.getContext();
        CommandContextBuilder commandcontextbuilder1 = commandcontextbuilder.withSource(sourceMapper.apply(commandcontextbuilder.getSource()));
        return new ParseResults(commandcontextbuilder1, parseResults.getReader(), parseResults.getExceptions());
    }

    public void dispatchServerCommand(CommandListenerWrapper sender, String command) {
        Joiner joiner = Joiner.on((String)" ");
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        ServerCommandEvent event = new ServerCommandEvent(sender.getBukkitSender(), command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getCommand();
        Object[] args = command.split(" ");
        if (args.length == 0) {
            return;
        }
        if (sender.e().getCraftServer().getCommandBlockOverride(args[0])) {
            args[0] = "minecraft:" + (String)args[0];
        }
        String newCommand = joiner.join(args);
        this.performPrefixedCommand(sender, newCommand, newCommand);
    }

    public void a(CommandListenerWrapper source, String command) {
        this.performPrefixedCommand(source, command, command);
    }

    public void performPrefixedCommand(CommandListenerWrapper commandlistenerwrapper, String s2, String label) {
        s2 = s2.startsWith("/") ? s2.substring(1) : s2;
        this.performCommand(this.h.parse(s2, commandlistenerwrapper), s2, label);
    }

    public void a(ParseResults<CommandListenerWrapper> parseResults, String command) {
        this.performCommand(parseResults, command, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(ParseResults<CommandListenerWrapper> parseresults, String s2, String label) {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)parseresults.getContext().getSource();
        ContextChain<CommandListenerWrapper> contextchain = this.finishParsing(parseresults, s2, commandlistenerwrapper, label);
        try {
            if (contextchain != null) {
                CommandDispatcher.a(commandlistenerwrapper, (ExecutionContext<CommandListenerWrapper> executioncontext) -> ExecutionContext.a(executioncontext, s2, contextchain, commandlistenerwrapper, CommandResultCallback.a));
            }
        }
        catch (Exception exception) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (commandlistenerwrapper.l().isDebugging() || g.isDebugEnabled()) {
                g.error("Command exception: /{}", (Object)s2, (Object)exception);
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int i2 = 0; i2 < Math.min(astacktraceelement.length, 3); ++i2) {
                    ichatmutablecomponent.f("\n\n").f(astacktraceelement[i2].getMethodName()).f("\n ").f(astacktraceelement[i2].getFileName()).f(":").f(String.valueOf(astacktraceelement[i2].getLineNumber()));
                }
            }
            commandlistenerwrapper.b(IChatBaseComponent.c("command.failed").a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent))));
            if (SharedConstants.aW) {
                commandlistenerwrapper.b(IChatBaseComponent.b(SystemUtils.c(exception)));
                g.error("'/{}' threw an exception", (Object)s2, (Object)exception);
            }
        }
    }

    @Nullable
    private ContextChain<CommandListenerWrapper> finishParsing(ParseResults<CommandListenerWrapper> parseresults, String s2, CommandListenerWrapper commandlistenerwrapper, String label) {
        try {
            CommandDispatcher.a(parseresults);
            return (ContextChain)ContextChain.tryFlatten((CommandContext)parseresults.getContext().build(s2)).orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseresults.getReader()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            TextComponent.Builder builder = Component.text();
            if (parseresults.getContext().getNodes().isEmpty() || !this.vanillaCommandNodes.contains(((ParsedCommandNode)parseresults.getContext().getNodes().get(0)).getNode())) {
                if (!SpigotConfig.unknownCommandMessage.isEmpty()) {
                    builder.append((Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.unknownCommandMessage));
                }
            } else {
                ((TextComponent.Builder)builder.color((TextColor)NamedTextColor.RED)).append(PaperBrigadier.componentFromMessage((Message)commandsyntaxexception.getRawMessage()));
                if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                    int i2 = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().a(EnumChatFormat.h).a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/" + label)));
                    if (i2 > 10) {
                        ichatmutablecomponent.b(CommonComponents.t);
                    }
                    ichatmutablecomponent.f(commandsyntaxexception.getInput().substring(Math.max(0, i2 - 10), i2));
                    if (i2 < commandsyntaxexception.getInput().length()) {
                        IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.b(commandsyntaxexception.getInput().substring(i2)).a(EnumChatFormat.m, EnumChatFormat.t);
                        ichatmutablecomponent.b(ichatmutablecomponent1);
                    }
                    ichatmutablecomponent.b(IChatBaseComponent.c("command.context.here").a(EnumChatFormat.m, EnumChatFormat.u));
                    ((TextComponent.Builder)builder.append((Component)Component.newline())).append(PaperAdventure.asAdventure(ichatmutablecomponent));
                }
            }
            UnknownCommandEvent event = new UnknownCommandEvent(commandlistenerwrapper.getBukkitSender(), s2, (Component)(SpigotConfig.unknownCommandMessage.isEmpty() ? null : builder.build()));
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.message() != null) {
                commandlistenerwrapper.sendFailure(PaperAdventure.asVanilla(event.message()), false);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(CommandListenerWrapper commandSource, Consumer<ExecutionContext<CommandListenerWrapper>> callback) {
        block9: {
            boolean flag;
            MinecraftServer minecraftserver = commandSource.l();
            ExecutionContext<CommandListenerWrapper> executioncontext = f.get();
            boolean bl = flag = executioncontext == null;
            if (flag) {
                int i2 = Math.max(1, minecraftserver.aK().c(GameRules.x));
                int j2 = minecraftserver.aK().c(GameRules.y);
                try (ExecutionContext executioncontext1 = new ExecutionContext(i2, j2, minecraftserver.aR());){
                    f.set(executioncontext1);
                    callback.accept(executioncontext1);
                    executioncontext1.a();
                    break block9;
                }
                finally {
                    f.set(null);
                }
            }
            callback.accept(executioncontext);
        }
    }

    public void a(EntityPlayer player) {
        if (SpigotConfig.tabComplete < 0) {
            player.c.b(new PacketPlayOutCommands((RootCommandNode<ICompletionProvider>)new RootCommandNode()));
            return;
        }
        COMMAND_SENDING_POOL.execute(() -> this.sendAsync(player));
    }

    private void sendAsync(EntityPlayer player) {
        IdentityHashMap map = Maps.newIdentityHashMap();
        RootCommandNode vanillaRoot = new RootCommandNode();
        RootCommandNode<CommandListenerWrapper> vanilla = player.d.vanillaCommandDispatcher.a().getRoot();
        map.put(vanilla, vanillaRoot);
        this.a((CommandNode<CommandListenerWrapper>)vanilla, (CommandNode<ICompletionProvider>)vanillaRoot, player.dd(), map);
        RootCommandNode rootcommandnode = new RootCommandNode();
        map.put(this.h.getRoot(), rootcommandnode);
        this.a((CommandNode<CommandListenerWrapper>)this.h.getRoot(), (CommandNode<ICompletionProvider>)rootcommandnode, player.dd(), map);
        LinkedHashSet<String> bukkit = new LinkedHashSet<String>();
        for (CommandNode node : rootcommandnode.getChildren()) {
            bukkit.add(node.getName());
        }
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootcommandnode, false).callEvent();
        MinecraftServer.getServer().execute(() -> this.runSync(player, bukkit, (RootCommandNode<ICompletionProvider>)rootcommandnode));
    }

    private void runSync(EntityPlayer player, Collection<String> bukkit, RootCommandNode<ICompletionProvider> rootcommandnode) {
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootcommandnode, false).callEvent();
        if (PlayerCommandSendEvent.getHandlerList().getRegisteredListeners().length > 0) {
            PlayerCommandSendEvent event = new PlayerCommandSendEvent((Player)player.getBukkitEntity(), new LinkedHashSet<String>(bukkit));
            event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
            for (String orig : bukkit) {
                if (event.getCommands().contains(orig)) continue;
                rootcommandnode.removeCommand(orig);
            }
        }
        player.c.b(new PacketPlayOutCommands(rootcommandnode));
    }

    private void a(CommandNode<CommandListenerWrapper> tree, CommandNode<ICompletionProvider> result, CommandListenerWrapper source, Map<CommandNode<CommandListenerWrapper>, CommandNode<ICompletionProvider>> resultNodes) {
        Iterator<CommandNode<CommandListenerWrapper>> iterator = tree.getChildren().iterator();
        boolean registeredAskServerSuggestionsForTree = false;
        while (iterator.hasNext()) {
            CommandNode<CommandListenerWrapper> commandnode2 = iterator.next();
            if (commandnode2.clientNode != null) {
                commandnode2 = commandnode2.clientNode;
            }
            if (!SpigotConfig.sendNamespaced && commandnode2.getName().contains(":") || !commandnode2.canUse(source)) continue;
            ArgumentBuilder<CommandListenerWrapper, ?> argumentbuilder = commandnode2.createBuilder();
            argumentbuilder.requires(icompletionprovider -> true);
            if (argumentbuilder.getCommand() != null) {
                argumentbuilder.executes((Command<CommandListenerWrapper>)((Command)commandcontext -> 0));
            }
            if (argumentbuilder instanceof RequiredArgumentBuilder) {
                RequiredArgumentBuilder requiredargumentbuilder = (RequiredArgumentBuilder)argumentbuilder;
                if (requiredargumentbuilder.getSuggestionsProvider() != null) {
                    requiredargumentbuilder.suggests(CompletionProviders.b((SuggestionProvider<ICompletionProvider>)requiredargumentbuilder.getSuggestionsProvider()));
                    registeredAskServerSuggestionsForTree = requiredargumentbuilder.getSuggestionsProvider() == CompletionProviders.a;
                } else if (GlobalConfiguration.get().commands.fixTargetSelectorTagCompletion && !registeredAskServerSuggestionsForTree && requiredargumentbuilder.getType() instanceof ArgumentEntity) {
                    requiredargumentbuilder.suggests((arg_0, arg_1) -> ((ArgumentType)requiredargumentbuilder.getType()).listSuggestions(arg_0, arg_1));
                    registeredAskServerSuggestionsForTree = true;
                }
            }
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(resultNodes.get(argumentbuilder.getRedirect()));
            }
            CommandNode<ICompletionProvider> commandnode3 = argumentbuilder.build();
            resultNodes.put(commandnode2, commandnode3);
            result.addChild(commandnode3);
            if (commandnode2.getChildren().isEmpty()) continue;
            this.a(commandnode2, commandnode3, source, resultNodes);
        }
    }

    public static LiteralArgumentBuilder<CommandListenerWrapper> a(String literal) {
        return LiteralArgumentBuilder.literal((String)literal);
    }

    public static <T> RequiredArgumentBuilder<CommandListenerWrapper, T> a(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static Predicate<String> a(b parser) {
        return s2 -> {
            try {
                parser.parse(new StringReader(s2));
                return true;
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        };
    }

    public com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> a() {
        return this.h;
    }

    public static <S> void a(ParseResults<S> parse) throws CommandSyntaxException {
        CommandSyntaxException commandsyntaxexception = CommandDispatcher.b(parse);
        if (commandsyntaxexception != null) {
            throw commandsyntaxexception;
        }
    }

    @Nullable
    public static <S> CommandSyntaxException b(ParseResults<S> parse) {
        return !parse.getReader().canRead() ? null : (parse.getExceptions().size() == 1 ? (CommandSyntaxException)parse.getExceptions().values().iterator().next() : (parse.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parse.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parse.getReader())));
    }

    public static CommandBuildContext a(final HolderLookup.b registryLookup) {
        return new CommandBuildContext(){

            @Override
            public <T> HolderLookup<T> a(ResourceKey<? extends IRegistry<T>> registryRef) {
                final HolderLookup.c holderlookup_c = registryLookup.b(registryRef);
                return new HolderLookup.a<T>(holderlookup_c){

                    @Override
                    public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                        return Optional.of(this.b(tag));
                    }

                    @Override
                    public HolderSet.Named<T> b(TagKey<T> tag) {
                        Optional<HolderSet.Named<HolderSet.Named>> optional = holderlookup_c.a(tag);
                        return optional.orElseGet(() -> HolderSet.a(holderlookup_c, tag));
                    }
                };
            }
        };
    }

    public static void b() {
        CommandBuildContext commandbuildcontext = CommandDispatcher.a(VanillaRegistries.a());
        com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> com_mojang_brigadier_commanddispatcher = new CommandDispatcher(ServerType.a, commandbuildcontext).a();
        RootCommandNode<CommandListenerWrapper> rootcommandnode = com_mojang_brigadier_commanddispatcher.getRoot();
        com_mojang_brigadier_commanddispatcher.findAmbiguities((AmbiguityConsumer<CommandListenerWrapper>)((AmbiguityConsumer)(commandnode, commandnode1, commandnode2, collection) -> g.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{com_mojang_brigadier_commanddispatcher.getPath(commandnode1), com_mojang_brigadier_commanddispatcher.getPath(commandnode2), collection})));
        Set<ArgumentType<?>> set = ArgumentUtils.a(rootcommandnode);
        Set set1 = set.stream().filter(argumenttype -> !ArgumentTypeInfos.a(argumenttype.getClass())).collect(Collectors.toSet());
        if (!set1.isEmpty()) {
            g.warn("Missing type registration for following arguments:\n {}", (Object)set1.stream().map(argumenttype -> "\t" + argumenttype).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static enum ServerType {
        a(true, true),
        b(false, true),
        c(true, false);

        final boolean d;
        final boolean e;

        private ServerType(boolean flag, boolean flag1) {
            this.d = flag;
            this.e = flag1;
        }
    }

    @FunctionalInterface
    public static interface b {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

