/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;

public class ResourceArgument<T>
implements ArgumentType<Holder.c<T>> {
    private static final Collection<String> c = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(id -> IChatBaseComponent.b("entity.not_summonable", id));
    public static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((element, type) -> IChatBaseComponent.b("argument.resource.not_found", element, type));
    public static final Dynamic3CommandExceptionType b = new Dynamic3CommandExceptionType((element, type, expectedType) -> IChatBaseComponent.b("argument.resource.invalid_type", element, type, expectedType));
    final ResourceKey<? extends IRegistry<T>> e;
    private final HolderLookup<T> f;

    public ResourceArgument(CommandBuildContext registryAccess, ResourceKey<? extends IRegistry<T>> registryRef) {
        this.e = registryRef;
        this.f = registryAccess.a(registryRef);
    }

    public static <T> ResourceArgument<T> a(CommandBuildContext registryAccess, ResourceKey<? extends IRegistry<T>> registryRef) {
        return new ResourceArgument<T>(registryAccess, registryRef);
    }

    public static <T> Holder.c<T> a(CommandContext<CommandListenerWrapper> context, String name, ResourceKey<IRegistry<T>> registryRef) throws CommandSyntaxException {
        Holder.c reference = (Holder.c)context.getArgument(name, Holder.c.class);
        ResourceKey resourceKey = reference.g();
        if (resourceKey.b(registryRef)) {
            return reference;
        }
        throw b.create((Object)resourceKey.a(), (Object)resourceKey.b(), (Object)registryRef.a());
    }

    public static Holder.c<AttributeBase> a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceArgument.a(context, name, Registries.c);
    }

    public static Holder.c<WorldGenFeatureConfigured<?, ?>> b(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceArgument.a(context, name, Registries.aw);
    }

    public static Holder.c<Structure> c(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceArgument.a(context, name, Registries.aD);
    }

    public static Holder.c<EntityTypes<?>> d(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceArgument.a(context, name, Registries.u);
    }

    public static Holder.c<EntityTypes<?>> e(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        Holder.c<EntityTypes<?>> reference = ResourceArgument.a(context, name, Registries.u);
        if (!((EntityTypes)reference.a()).c()) {
            throw d.create((Object)reference.g().a().toString());
        }
        return reference;
    }

    public static Holder.c<MobEffectList> f(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceArgument.a(context, name, Registries.Q);
    }

    public static Holder.c<Enchantment> g(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceArgument.a(context, name, Registries.t);
    }

    public Holder.c<T> a(StringReader stringReader) throws CommandSyntaxException {
        MinecraftKey resourceLocation = MinecraftKey.a(stringReader);
        ResourceKey resourceKey = ResourceKey.a(this.e, resourceLocation);
        return this.f.a(resourceKey).orElseThrow(() -> a.create((Object)resourceLocation, (Object)this.e.a()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return ICompletionProvider.a(this.f.c().map(ResourceKey::a), suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return c;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    public static class net.minecraft.commands.arguments.ResourceArgument$a<T>
    implements ArgumentTypeInfo<ResourceArgument<T>, a> {
        @Override
        @Override
        public void a(a properties, PacketDataSerializer buf) {
            buf.b(properties.b);
        }

        @Override
        @Override
        public a a(PacketDataSerializer friendlyByteBuf) {
            return new a(friendlyByteBuf.u());
        }

        @Override
        @Override
        public void a(a properties, JsonObject json) {
            json.addProperty("registry", properties.b.a().toString());
        }

        @Override
        @Override
        public a a(ResourceArgument<T> argumentType) {
            return new a(argumentType.e);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a b(PacketDataSerializer buf) {
            return this.a(buf);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> b;

            a(ResourceKey<? extends IRegistry<T>> registryRef) {
                this.b = registryRef;
            }

            @Override
            public ResourceArgument<T> a(CommandBuildContext commandBuildContext) {
                return new ResourceArgument(commandBuildContext, this.b);
            }

            @Override
            @Override
            public ArgumentTypeInfo<ResourceArgument<T>, ?> a() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType b(CommandBuildContext commandRegistryAccess) {
                return this.a(commandRegistryAccess);
            }
        }
    }
}

