/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.util.Locale;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentAngle;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTBase;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.commands.arguments.StyleArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializerString;
import net.minecraft.commands.synchronization.brigadier.DoubleArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.FloatArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.LongArgumentInfo;
import net.minecraft.core.IRegistry;
import net.minecraft.gametest.framework.GameTestHarnessTestClassArgument;
import net.minecraft.gametest.framework.GameTestHarnessTestFunctionArgument;

public class ArgumentTypeInfos {
    private static final Map<Class<?>, ArgumentTypeInfo<?, ?>> a = Maps.newHashMap();

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.a<A>> ArgumentTypeInfo<A, T> a(IRegistry<ArgumentTypeInfo<?, ?>> registry, String id, Class<? extends A> clazz, ArgumentTypeInfo<A, T> serializer) {
        a.put(clazz, serializer);
        return IRegistry.a(registry, id, serializer);
    }

    public static ArgumentTypeInfo<?, ?> a(IRegistry<ArgumentTypeInfo<?, ?>> registry) {
        ArgumentTypeInfos.a(registry, "brigadier:bool", BoolArgumentType.class, SingletonArgumentInfo.a(BoolArgumentType::bool));
        ArgumentTypeInfos.a(registry, "brigadier:float", FloatArgumentType.class, new FloatArgumentInfo());
        ArgumentTypeInfos.a(registry, "brigadier:double", DoubleArgumentType.class, new DoubleArgumentInfo());
        ArgumentTypeInfos.a(registry, "brigadier:integer", IntegerArgumentType.class, new IntegerArgumentInfo());
        ArgumentTypeInfos.a(registry, "brigadier:long", LongArgumentType.class, new LongArgumentInfo());
        ArgumentTypeInfos.a(registry, "brigadier:string", StringArgumentType.class, new ArgumentSerializerString());
        ArgumentTypeInfos.a(registry, "entity", ArgumentEntity.class, new ArgumentEntity.Info());
        ArgumentTypeInfos.a(registry, "game_profile", ArgumentProfile.class, SingletonArgumentInfo.a(ArgumentProfile::a));
        ArgumentTypeInfos.a(registry, "block_pos", ArgumentPosition.class, SingletonArgumentInfo.a(ArgumentPosition::a));
        ArgumentTypeInfos.a(registry, "column_pos", ArgumentVec2I.class, SingletonArgumentInfo.a(ArgumentVec2I::a));
        ArgumentTypeInfos.a(registry, "vec3", ArgumentVec3.class, SingletonArgumentInfo.a(ArgumentVec3::a));
        ArgumentTypeInfos.a(registry, "vec2", ArgumentVec2.class, SingletonArgumentInfo.a(ArgumentVec2::a));
        ArgumentTypeInfos.a(registry, "block_state", ArgumentTile.class, SingletonArgumentInfo.a(ArgumentTile::a));
        ArgumentTypeInfos.a(registry, "block_predicate", ArgumentBlockPredicate.class, SingletonArgumentInfo.a(ArgumentBlockPredicate::a));
        ArgumentTypeInfos.a(registry, "item_stack", ArgumentItemStack.class, SingletonArgumentInfo.a(ArgumentItemStack::a));
        ArgumentTypeInfos.a(registry, "item_predicate", ArgumentItemPredicate.class, SingletonArgumentInfo.a(ArgumentItemPredicate::a));
        ArgumentTypeInfos.a(registry, "color", ArgumentChatFormat.class, SingletonArgumentInfo.a(ArgumentChatFormat::a));
        ArgumentTypeInfos.a(registry, "component", ArgumentChatComponent.class, SingletonArgumentInfo.a(ArgumentChatComponent::a));
        ArgumentTypeInfos.a(registry, "style", StyleArgument.class, SingletonArgumentInfo.a(StyleArgument::a));
        ArgumentTypeInfos.a(registry, "message", ArgumentChat.class, SingletonArgumentInfo.a(ArgumentChat::a));
        ArgumentTypeInfos.a(registry, "nbt_compound_tag", ArgumentNBTTag.class, SingletonArgumentInfo.a(ArgumentNBTTag::a));
        ArgumentTypeInfos.a(registry, "nbt_tag", ArgumentNBTBase.class, SingletonArgumentInfo.a(ArgumentNBTBase::a));
        ArgumentTypeInfos.a(registry, "nbt_path", ArgumentNBTKey.class, SingletonArgumentInfo.a(ArgumentNBTKey::a));
        ArgumentTypeInfos.a(registry, "objective", ArgumentScoreboardObjective.class, SingletonArgumentInfo.a(ArgumentScoreboardObjective::a));
        ArgumentTypeInfos.a(registry, "objective_criteria", ArgumentScoreboardCriteria.class, SingletonArgumentInfo.a(ArgumentScoreboardCriteria::a));
        ArgumentTypeInfos.a(registry, "operation", ArgumentMathOperation.class, SingletonArgumentInfo.a(ArgumentMathOperation::a));
        ArgumentTypeInfos.a(registry, "particle", ArgumentParticle.class, SingletonArgumentInfo.a(ArgumentParticle::a));
        ArgumentTypeInfos.a(registry, "angle", ArgumentAngle.class, SingletonArgumentInfo.a(ArgumentAngle::a));
        ArgumentTypeInfos.a(registry, "rotation", ArgumentRotation.class, SingletonArgumentInfo.a(ArgumentRotation::a));
        ArgumentTypeInfos.a(registry, "scoreboard_slot", ArgumentScoreboardSlot.class, SingletonArgumentInfo.a(ArgumentScoreboardSlot::a));
        ArgumentTypeInfos.a(registry, "score_holder", ArgumentScoreholder.class, new ArgumentScoreholder.a());
        ArgumentTypeInfos.a(registry, "swizzle", ArgumentRotationAxis.class, SingletonArgumentInfo.a(ArgumentRotationAxis::a));
        ArgumentTypeInfos.a(registry, "team", ArgumentScoreboardTeam.class, SingletonArgumentInfo.a(ArgumentScoreboardTeam::a));
        ArgumentTypeInfos.a(registry, "item_slot", ArgumentInventorySlot.class, SingletonArgumentInfo.a(ArgumentInventorySlot::a));
        ArgumentTypeInfos.a(registry, "resource_location", ArgumentMinecraftKeyRegistered.class, SingletonArgumentInfo.a(ArgumentMinecraftKeyRegistered::a));
        ArgumentTypeInfos.a(registry, "function", ArgumentTag.class, SingletonArgumentInfo.a(ArgumentTag::a));
        ArgumentTypeInfos.a(registry, "entity_anchor", ArgumentAnchor.class, SingletonArgumentInfo.a(ArgumentAnchor::a));
        ArgumentTypeInfos.a(registry, "int_range", ArgumentCriterionValue.b.class, SingletonArgumentInfo.a(ArgumentCriterionValue::a));
        ArgumentTypeInfos.a(registry, "float_range", ArgumentCriterionValue.a.class, SingletonArgumentInfo.a(ArgumentCriterionValue::b));
        ArgumentTypeInfos.a(registry, "dimension", ArgumentDimension.class, SingletonArgumentInfo.a(ArgumentDimension::a));
        ArgumentTypeInfos.a(registry, "gamemode", GameModeArgument.class, SingletonArgumentInfo.a(GameModeArgument::a));
        ArgumentTypeInfos.a(registry, "time", ArgumentTime.class, new ArgumentTime.a());
        ArgumentTypeInfos.a(registry, "resource_or_tag", ArgumentTypeInfos.b(ResourceOrTagArgument.class), new ResourceOrTagArgument.a());
        ArgumentTypeInfos.a(registry, "resource_or_tag_key", ArgumentTypeInfos.b(ResourceOrTagKeyArgument.class), new ResourceOrTagKeyArgument.a());
        ArgumentTypeInfos.a(registry, "resource", ArgumentTypeInfos.b(ResourceArgument.class), new ResourceArgument.a());
        ArgumentTypeInfos.a(registry, "resource_key", ArgumentTypeInfos.b(ResourceKeyArgument.class), new ResourceKeyArgument.a());
        ArgumentTypeInfos.a(registry, "template_mirror", TemplateMirrorArgument.class, SingletonArgumentInfo.a(TemplateMirrorArgument::a));
        ArgumentTypeInfos.a(registry, "template_rotation", TemplateRotationArgument.class, SingletonArgumentInfo.a(TemplateRotationArgument::a));
        ArgumentTypeInfos.a(registry, "heightmap", HeightmapTypeArgument.class, SingletonArgumentInfo.a(HeightmapTypeArgument::a));
        if (SharedConstants.aW) {
            ArgumentTypeInfos.a(registry, "test_argument", GameTestHarnessTestFunctionArgument.class, SingletonArgumentInfo.a(GameTestHarnessTestFunctionArgument::a));
            ArgumentTypeInfos.a(registry, "test_class", GameTestHarnessTestClassArgument.class, SingletonArgumentInfo.a(GameTestHarnessTestClassArgument::a));
        }
        return ArgumentTypeInfos.a(registry, "uuid", ArgumentUUID.class, SingletonArgumentInfo.a(ArgumentUUID::a));
    }

    private static <T extends ArgumentType<?>> Class<T> b(Class<? super T> clazz) {
        return clazz;
    }

    public static boolean a(Class<?> clazz) {
        return a.containsKey(clazz);
    }

    public static <A extends ArgumentType<?>> ArgumentTypeInfo<A, ?> a(A argumentType) {
        ArgumentTypeInfo<?, ?> argumentTypeInfo = a.get(argumentType.getClass());
        if (argumentTypeInfo == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unrecognized argument type %s (%s)", argumentType, argumentType.getClass()));
        }
        return argumentTypeInfo;
    }

    public static <A extends ArgumentType<?>> ArgumentTypeInfo.a<A> b(A argumentType) {
        return ArgumentTypeInfos.a(argumentType).a(argumentType);
    }
}

