/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;

public class RegistryCodecs {
    private static <T> MapCodec<a<T>> a(ResourceKey<? extends IRegistry<T>> registryRef, MapCodec<T> elementCodec) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(registryRef).fieldOf("name").forGetter(a::a), (App)Codec.INT.fieldOf("id").forGetter(a::b), (App)elementCodec.forGetter(a::c)).apply((Applicative)instance, a::new));
    }

    public static <T> Codec<IRegistry<T>> a(ResourceKey<? extends IRegistry<T>> registryRef, Lifecycle lifecycle, Codec<T> elementCodec) {
        return RegistryCodecs.a(registryRef, elementCodec.fieldOf("element")).codec().listOf().xmap(entries -> {
            RegistryMaterials mappedRegistry = new RegistryMaterials(registryRef, lifecycle);
            for (a registryEntry : entries) {
                mappedRegistry.a(registryEntry.b(), registryEntry.a(), registryEntry.c(), lifecycle);
            }
            return mappedRegistry;
        }, registry -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object object : registry) {
                builder.add(new a(registry.c(object).get(), registry.a(object), object));
            }
            return builder.build();
        });
    }

    public static <E> Codec<IRegistry<E>> b(ResourceKey<? extends IRegistry<E>> registryRef, Lifecycle lifecycle, Codec<E> elementCodec) {
        UnboundedMapCodec codec = Codec.unboundedMap(ResourceKey.a(registryRef), elementCodec);
        return codec.xmap(entries -> {
            RegistryMaterials writableRegistry = new RegistryMaterials(registryRef, lifecycle);
            entries.forEach((key, value) -> writableRegistry.a(key, value, lifecycle));
            return writableRegistry.l();
        }, registry -> ImmutableMap.copyOf(registry.g()));
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> elementCodec) {
        return RegistryCodecs.a(registryRef, elementCodec, false);
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryRef, Codec<E> elementCodec, boolean alwaysSerializeAsList) {
        return HolderSetCodec.a(registryRef, RegistryFileCodec.a(registryRef, elementCodec), alwaysSerializeAsList);
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryRef) {
        return RegistryCodecs.a(registryRef, false);
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryRef, boolean alwaysSerializeAsList) {
        return HolderSetCodec.a(registryRef, RegistryFixedCodec.a(registryRef), alwaysSerializeAsList);
    }

    record a<T>(ResourceKey<T> a, int b, T c) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "key;id;value", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "key;id;value", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "key;id;value", "a", "b", "c"}, this, object);
        }
    }
}

