/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;

public class RegistrySetBuilder {
    private final List<i<?>> a = new ArrayList();

    static <T> HolderGetter<T> a(final HolderLookup.c<T> wrapper) {
        return new c<T>(wrapper){

            @Override
            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return wrapper.a(key);
            }
        };
    }

    static <T> HolderLookup.c<T> a(final ResourceKey<? extends IRegistry<? extends T>> registryRef, final Lifecycle lifecycle, final Map<ResourceKey<T>, Holder.c<T>> entries) {
        return new HolderLookup.c<T>(){

            @Override
            @Override
            public ResourceKey<? extends IRegistry<? extends T>> f() {
                return registryRef;
            }

            @Override
            @Override
            public Lifecycle g() {
                return lifecycle;
            }

            @Override
            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return Optional.ofNullable((Holder.c)entries.get(key));
            }

            @Override
            @Override
            public Stream<Holder.c<T>> b() {
                return entries.values().stream();
            }

            @Override
            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                return Optional.empty();
            }

            @Override
            @Override
            public Stream<HolderSet.Named<T>> d() {
                return Stream.empty();
            }
        };
    }

    public <T> RegistrySetBuilder a(ResourceKey<? extends IRegistry<T>> registryRef, Lifecycle lifecycle, g<T> bootstrapFunction) {
        this.a.add(new i<T>(registryRef, lifecycle, bootstrapFunction));
        return this;
    }

    public <T> RegistrySetBuilder a(ResourceKey<? extends IRegistry<T>> registryRef, g<T> bootstrapFunction) {
        return this.a(registryRef, Lifecycle.stable(), bootstrapFunction);
    }

    private a b(IRegistryCustom registryManager) {
        a buildState = net.minecraft.core.RegistrySetBuilder$a.a(registryManager, this.a.stream().map(i::a));
        this.a.forEach(registry -> registry.b(buildState));
        return buildState;
    }

    private static HolderLookup.b a(IRegistryCustom registryManager, Stream<HolderLookup.c<?>> additionalRegistries) {
        Stream<HolderLookup.c> stream = registryManager.c().map(entry -> entry.b().p());
        return HolderLookup.b.a(Stream.concat(stream, additionalRegistries));
    }

    public HolderLookup.b a(IRegistryCustom registryManager) {
        a buildState = this.b(registryManager);
        Stream<HolderLookup.c<?>> stream = this.a.stream().map(info -> info.a(buildState).a(buildState.a));
        HolderLookup.b provider = RegistrySetBuilder.a(registryManager, stream);
        buildState.c();
        buildState.b();
        buildState.d();
        return provider;
    }

    private HolderLookup.b a(IRegistryCustom registryManager, HolderLookup.b base, Cloner.a cloneableRegistries, Map<ResourceKey<? extends IRegistry<?>>, h<?>> initializedRegistries, HolderLookup.b patches) {
        b compositeOwner = new b();
        MutableObject mutableObject = new MutableObject();
        List list = initializedRegistries.keySet().stream().map(registryRef -> this.a((HolderOwner)compositeOwner, cloneableRegistries, (ResourceKey)registryRef, patches, base, (MutableObject<HolderLookup.b>)mutableObject)).peek(compositeOwner::b).collect(Collectors.toUnmodifiableList());
        HolderLookup.b provider = RegistrySetBuilder.a(registryManager, list.stream());
        mutableObject.setValue((Object)provider);
        return provider;
    }

    private <T> HolderLookup.c<T> a(HolderOwner<T> owner, Cloner.a cloneableRegistries, ResourceKey<? extends IRegistry<? extends T>> registryRef, HolderLookup.b patches, HolderLookup.b base, MutableObject<HolderLookup.b> lazyWrapper) {
        Cloner cloner = cloneableRegistries.a(registryRef);
        if (cloner == null) {
            throw new NullPointerException("No cloner for " + registryRef.a());
        }
        HashMap map = new HashMap();
        HolderLookup.c registryLookup = patches.b(registryRef);
        registryLookup.b().forEach(entry -> {
            ResourceKey resourceKey = entry.g();
            d lazyHolder = new d(owner, resourceKey);
            lazyHolder.a = () -> cloner.a(entry.a(), patches, (HolderLookup.b)lazyWrapper.getValue());
            map.put(resourceKey, lazyHolder);
        });
        HolderLookup.c registryLookup2 = base.b(registryRef);
        registryLookup2.b().forEach(entry -> {
            ResourceKey resourceKey = entry.g();
            map.computeIfAbsent(resourceKey, key -> {
                d lazyHolder = new d(owner, resourceKey);
                lazyHolder.a = () -> cloner.a(entry.a(), base, (HolderLookup.b)lazyWrapper.getValue());
                return lazyHolder;
            });
        });
        Lifecycle lifecycle = registryLookup.g().add(registryLookup2.g());
        return RegistrySetBuilder.a(registryRef, lifecycle, map);
    }

    public e a(IRegistryCustom baseRegistryManager, HolderLookup.b wrapperLookup, Cloner.a cloneableRegistries) {
        a buildState = this.b(baseRegistryManager);
        HashMap map = new HashMap();
        this.a.stream().map(info -> info.a(buildState)).forEach(registry -> map.put((ResourceKey<IRegistry<?>>)registry.a, (h<?>)registry));
        Set set = baseRegistryManager.a().collect(Collectors.toUnmodifiableSet());
        wrapperLookup.a().filter(key -> !set.contains(key)).forEach(key -> map.putIfAbsent((ResourceKey<IRegistry<?>>)key, new h(key, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.c<?>> stream = map.values().stream().map(registry -> registry.a(buildState.a));
        HolderLookup.b provider = RegistrySetBuilder.a(baseRegistryManager, stream);
        buildState.b();
        buildState.d();
        HolderLookup.b provider2 = this.a(baseRegistryManager, wrapperLookup, cloneableRegistries, map, provider);
        return new e(provider2, provider);
    }

    record i<T>(ResourceKey<? extends IRegistry<T>> a, Lifecycle b, g<T> c) {
        void b(a registries) {
            this.c.run(registries.a());
        }

        public h<T> a(a registries) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, f<?>>> iterator = registries.d.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, f<?>> entry = iterator.next();
                ResourceKey<?> resourceKey = entry.getKey();
                if (!resourceKey.b(this.a)) continue;
                ResourceKey<?> resourceKey2 = resourceKey;
                f<?> registeredValue = entry.getValue();
                Holder.c<Object> reference = registries.b.a.remove(resourceKey);
                map.put(resourceKey2, new k(registeredValue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new h(this.a, this.b, map);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this, object);
        }
    }

    @FunctionalInterface
    public static interface g<T> {
        public void run(BootstapContext<T> var1);
    }

    record a(b a, j b, Map<MinecraftKey, HolderGetter<?>> c, Map<ResourceKey<?>, f<?>> d, List<RuntimeException> e) {
        private final b a;
        private final j b;
        private final Map<MinecraftKey, HolderGetter<?>> c;
        private final Map<ResourceKey<?>, f<?>> d;
        private final List<RuntimeException> e;

        public static a a(IRegistryCustom dynamicRegistryManager, Stream<ResourceKey<? extends IRegistry<?>>> registryRefs) {
            b compositeOwner = new b();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            j universalLookup = new j(compositeOwner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            dynamicRegistryManager.c().forEach(entry -> builder.put((Object)entry.a().a(), RegistrySetBuilder.a(entry.b().p())));
            registryRefs.forEach(registryRef -> builder.put((Object)registryRef.a(), (Object)universalLookup));
            return new a(compositeOwner, universalLookup, (Map<MinecraftKey, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstapContext<T> a() {
            return new BootstapContext<T>(){

                @Override
                @Override
                public Holder.c<T> a(ResourceKey<T> key, T value, Lifecycle lifecycle) {
                    f registeredValue = d.put(key, new f(value, lifecycle));
                    if (registeredValue != null) {
                        e.add(new IllegalStateException("Duplicate registration for " + key + ", new=" + value + ", old=" + registeredValue.a));
                    }
                    return b.c(key);
                }

                @Override
                @Override
                public <S> HolderGetter<S> a(ResourceKey<? extends IRegistry<? extends S>> registryRef) {
                    return c.getOrDefault(registryRef.a(), b);
                }
            };
        }

        public void b() {
            this.d.forEach((key, value) -> this.e.add(new IllegalStateException("Orpaned value " + value.a + " for key " + key)));
        }

        public void c() {
            for (ResourceKey<Object> resourceKey : this.b.a.keySet()) {
                this.e.add(new IllegalStateException("Unreferenced key: " + resourceKey));
            }
        }

        public void d() {
            if (!this.e.isEmpty()) {
                IllegalStateException illegalStateException = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeException : this.e) {
                    illegalStateException.addSuppressed(runtimeException);
                }
                throw illegalStateException;
            }
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this, object);
        }

        public b e() {
            return this.a;
        }

        public j f() {
            return this.b;
        }

        public Map<MinecraftKey, HolderGetter<?>> g() {
            return this.c;
        }

        public Map<ResourceKey<?>, f<?>> h() {
            return this.d;
        }

        public List<RuntimeException> i() {
            return this.e;
        }
    }

    static class b
    implements HolderOwner<Object> {
        private final Set<HolderOwner<?>> a = Sets.newIdentityHashSet();

        b() {
        }

        @Override
        @Override
        public boolean a(HolderOwner<Object> other) {
            return this.a.contains(other);
        }

        public void b(HolderOwner<?> owner) {
            this.a.add(owner);
        }

        public <T> HolderOwner<T> a() {
            return this;
        }
    }

    public record e(HolderLookup.b a, HolderLookup.b b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "full;patches", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "full;patches", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "full;patches", "a", "b"}, this, object);
        }
    }

    record h<T>(ResourceKey<? extends IRegistry<? extends T>> a, Lifecycle b, Map<ResourceKey<T>, k<T>> c) {
        public HolderLookup.c<T> a(b anyOwner) {
            Map map = this.c.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
                k valueAndHolder = (k)entry.getValue();
                Holder.c reference = valueAndHolder.b().orElseGet(() -> Holder.c.a(anyOwner.a(), (ResourceKey)entry.getKey()));
                reference.b(valueAndHolder.a().a());
                return reference;
            }));
            HolderLookup.c registryLookup = RegistrySetBuilder.a(this.a, this.b, map);
            anyOwner.b(registryLookup);
            return registryLookup;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "key;lifecycle;values", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "key;lifecycle;values", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "key;lifecycle;values", "a", "b", "c"}, this, object);
        }
    }

    static class d<T>
    extends Holder.c<T> {
        @Nullable
        Supplier<T> a;

        protected d(HolderOwner<T> owner, @Nullable ResourceKey<T> key) {
            super(Holder.c.a.a, owner, key, null);
        }

        @Override
        @Override
        protected void b(T value) {
            super.b(value);
            this.a = null;
        }

        @Override
        @Override
        public T a() {
            if (this.a != null) {
                this.b(this.a.get());
            }
            return super.a();
        }
    }

    record k<T>(f<T> a, Optional<Holder.c<T>> b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{k.class, "value;holder", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{k.class, "value;holder", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{k.class, "value;holder", "a", "b"}, this, object);
        }
    }

    record f<T>(T a, Lifecycle b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{f.class, "value;lifecycle", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "value;lifecycle", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{f.class, "value;lifecycle", "a", "b"}, this, object);
        }
    }

    static class j
    extends c<Object> {
        final Map<ResourceKey<Object>, Holder.c<Object>> a = new HashMap<ResourceKey<Object>, Holder.c<Object>>();

        public j(HolderOwner<Object> entryOwner) {
            super(entryOwner);
        }

        @Override
        @Override
        public Optional<Holder.c<Object>> a(ResourceKey<Object> key) {
            return Optional.of(this.c(key));
        }

        <T> Holder.c<T> c(ResourceKey<T> key) {
            return this.a.computeIfAbsent(key, key2 -> Holder.c.a(this.b, key2));
        }
    }

    static abstract class c<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> b;

        protected c(HolderOwner<T> entryOwner) {
            this.b = entryOwner;
        }

        @Override
        @Override
        public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
            return Optional.of(HolderSet.a(this.b, tag));
        }
    }
}

