/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;

public class Vector3f {
    protected final float a;
    protected final float b;
    protected final float c;

    public Vector3f(float pitch, float yaw, float roll) {
        this.a = !Float.isInfinite(pitch) && !Float.isNaN(pitch) ? pitch % 360.0f : 0.0f;
        this.b = !Float.isInfinite(yaw) && !Float.isNaN(yaw) ? yaw % 360.0f : 0.0f;
        this.c = !Float.isInfinite(roll) && !Float.isNaN(roll) ? roll % 360.0f : 0.0f;
    }

    public Vector3f(NBTTagList serialized) {
        this(serialized.i(0), serialized.i(1), serialized.i(2));
    }

    private Vector3f(float x2, float y2, float z2, Void dummy_var) {
        this.a = x2;
        this.b = y2;
        this.c = z2;
    }

    public static Vector3f createWithoutValidityChecks(float x2, float y2, float z2) {
        return new Vector3f(x2, y2, z2, null);
    }

    public NBTTagList a() {
        NBTTagList listTag = new NBTTagList();
        listTag.add(NBTTagFloat.a(this.a));
        listTag.add(NBTTagFloat.a(this.b));
        listTag.add(NBTTagFloat.a(this.c));
        return listTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Vector3f)) return false;
        Vector3f rotations = (Vector3f)object;
        if (this.a != rotations.a) return false;
        if (this.b != rotations.b) return false;
        if (this.c != rotations.c) return false;
        return true;
    }

    public float b() {
        return this.a;
    }

    public float c() {
        return this.b;
    }

    public float d() {
        return this.c;
    }

    public float e() {
        return MathHelper.g(this.a);
    }

    public float f() {
        return MathHelper.g(this.b);
    }

    public float g() {
        return MathHelper.g(this.c);
    }
}

