/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.DispenseBehaviorBoat;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.DispenseBehaviorProjectile;
import net.minecraft.core.dispenser.DispenseBehaviorShears;
import net.minecraft.core.dispenser.DispenseBehaviorShulkerBox;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.projectiles.CraftBlockProjectileSource;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R3.util.DummyGeneratorAccess;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public interface IDispenseBehavior {
    public static final Logger a = LogUtils.getLogger();
    public static final IDispenseBehavior b = (sourceblock, itemstack) -> itemstack;

    public net.minecraft.world.item.ItemStack dispense(SourceBlock var1, net.minecraft.world.item.ItemStack var2);

    public static void c() {
        BlockDispenser.a(Items.os, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(world, position.a(), position.b(), position.c(), stack.c(1));
                entitytippedarrow.d = EntityArrow.PickupStatus.b;
                return entitytippedarrow;
            }
        });
        BlockDispenser.a(Items.vj, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                EntityTippedArrow entitytippedarrow = new EntityTippedArrow(world, position.a(), position.b(), position.c(), stack.c(1));
                entitytippedarrow.a(stack);
                entitytippedarrow.d = EntityArrow.PickupStatus.b;
                return entitytippedarrow;
            }
        });
        BlockDispenser.a(Items.vi, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                EntitySpectralArrow entityspectralarrow = new EntitySpectralArrow(world, position.a(), position.b(), position.c(), stack.c(1));
                entityspectralarrow.d = EntityArrow.PickupStatus.b;
                return entityspectralarrow;
            }
        });
        BlockDispenser.a(Items.qO, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                return SystemUtils.a(new EntityEgg(world, position.a(), position.b(), position.c()), entityegg -> entityegg.a(stack));
            }
        });
        BlockDispenser.a(Items.qz, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                return SystemUtils.a(new EntitySnowball(world, position.a(), position.b(), position.c()), entitysnowball -> entitysnowball.a(stack));
            }
        });
        BlockDispenser.a(Items.tR, new DispenseBehaviorProjectile(){

            @Override
            protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                return SystemUtils.a(new EntityThrownExpBottle(world, position.a(), position.b(), position.c()), entitythrownexpbottle -> entitythrownexpbottle.a(stack));
            }

            @Override
            protected float a() {
                return super.a() * 0.5f;
            }

            @Override
            protected float b() {
                return super.b() * 1.25f;
            }
        });
        BlockDispenser.a(Items.vh, new IDispenseBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack dispense(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                return new DispenseBehaviorProjectile(){

                    @Override
                    protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                        return SystemUtils.a(new EntityPotion(world, position.a(), position.b(), position.c()), entitypotion -> entitypotion.a(stack));
                    }

                    @Override
                    protected float a() {
                        return super.a() * 0.5f;
                    }

                    @Override
                    protected float b() {
                        return super.b() * 1.25f;
                    }
                }.dispense(pointer, stack);
            }
        });
        BlockDispenser.a(Items.vk, new IDispenseBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack dispense(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                return new DispenseBehaviorProjectile(){

                    @Override
                    protected IProjectile a(net.minecraft.world.level.World world, IPosition position, net.minecraft.world.item.ItemStack stack) {
                        return SystemUtils.a(new EntityPotion(world, position.a(), position.b(), position.c()), entitypotion -> entitypotion.a(stack));
                    }

                    @Override
                    protected float a() {
                        return super.a() * 0.5f;
                    }

                    @Override
                    protected float b() {
                        return super.b() * 1.25f;
                    }
                }.dispense(pointer, stack);
            }
        });
        DispenseBehaviorItem dispensebehavioritem = new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.d().c(BlockDispenser.b);
                EntityTypes<?> entitytypes = ((ItemMonsterEgg)stack.d()).a(stack.v());
                WorldServer worldserver = pointer.b();
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                CraftBlock block = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.e.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    itemstack1 = CraftItemStack.unwrap(event.getItem());
                    entitytypes = ((ItemMonsterEgg)itemstack1.d()).a(itemstack1.v());
                }
                try {
                    entitytypes.a(pointer.b(), itemstack1, (EntityHuman)null, pointer.c().a(enumdirection), EnumMobSpawn.o, enumdirection != EnumDirection.b, false);
                }
                catch (Exception exception) {
                    a.error("Error while dispensing spawn egg from dispenser at {}", (Object)pointer.c(), (Object)exception);
                    return net.minecraft.world.item.ItemStack.f;
                }
                if (shrink) {
                    stack.h(1);
                }
                pointer.b().a((Entity)null, GameEvent.t, pointer.c());
                return stack;
            }
        };
        for (ItemMonsterEgg itemmonsteregg : ItemMonsterEgg.h()) {
            BlockDispenser.a(itemmonsteregg, dispensebehavioritem);
        }
        BlockDispenser.a(Items.uy, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.d().c(BlockDispenser.b);
                BlockPosition blockposition = pointer.c().a(enumdirection);
                WorldServer worldserver = pointer.b();
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                CraftBlock block = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.e.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                net.minecraft.world.item.ItemStack newStack = CraftItemStack.unwrap(event.getItem());
                Consumer<EntityArmorStand> consumer = EntityTypes.a(entityarmorstand -> entityarmorstand.r(enumdirection.p()), worldserver, newStack, (EntityHuman)null);
                EntityArmorStand entityarmorstand2 = EntityTypes.d.a(worldserver, newStack.v(), consumer, blockposition, EnumMobSpawn.o, false, false);
                if (entityarmorstand2 != null && shrink) {
                    stack.h(1);
                }
                return stack;
            }
        });
        BlockDispenser.a(Items.nK, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
                List<EntityLiving> list = pointer.b().a(EntityLiving.class, new AxisAlignedBB(blockposition), entityliving -> {
                    if (!(entityliving instanceof ISaddleable)) {
                        return false;
                    }
                    ISaddleable isaddleable = (ISaddleable)((Object)entityliving);
                    return !isaddleable.i() && isaddleable.g();
                });
                if (!list.isEmpty()) {
                    net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                    WorldServer world = pointer.b();
                    CraftBlock block = CraftBlock.at(world, pointer.c());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)list.get(0).getBukkitEntity()));
                    if (!BlockDispenser.eventFired) {
                        world.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    boolean shrink = true;
                    if (!event.getItem().equals((Object)craftItem)) {
                        shrink = false;
                        net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                        IDispenseBehavior idispensebehavior = BlockDispenser.e.get(eventStack.d());
                        if (idispensebehavior != b && idispensebehavior != this) {
                            idispensebehavior.dispense(pointer, eventStack);
                            return stack;
                        }
                    }
                    ((ISaddleable)((Object)list.get(0))).equipSaddle(SoundCategory.e, CraftItemStack.asNMSCopy(event.getItem()));
                    if (shrink) {
                        stack.h(1);
                    }
                    this.a(true);
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        DispenseBehaviorMaybe dispensebehaviormaybe = new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EntityHorseAbstract entityhorseabstract2;
                BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
                List<EntityHorseAbstract> list = pointer.b().a(EntityHorseAbstract.class, new AxisAlignedBB(blockposition), entityhorseabstract -> entityhorseabstract.bx() && entityhorseabstract.gN());
                Iterator<EntityHorseAbstract> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.a(pointer, stack);
                } while (!(entityhorseabstract2 = iterator1.next()).l(stack) || entityhorseabstract2.gO() || !entityhorseabstract2.gt());
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                WorldServer world = pointer.b();
                CraftBlock block = CraftBlock.at(world, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorseabstract2.getBukkitEntity()));
                if (!BlockDispenser.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.e.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                if (shrink) {
                    stack.h(1);
                }
                entityhorseabstract2.a_(401).a(CraftItemStack.asNMSCopy(event.getItem()));
                this.a(true);
                return stack;
            }
        };
        BlockDispenser.a(Items.uC, dispensebehaviormaybe);
        BlockDispenser.a(Items.uz, dispensebehaviormaybe);
        BlockDispenser.a(Items.uA, dispensebehaviormaybe);
        BlockDispenser.a(Items.uB, dispensebehaviormaybe);
        BlockDispenser.a(Items.hD, dispensebehaviormaybe);
        BlockDispenser.a(Items.hE, dispensebehaviormaybe);
        BlockDispenser.a(Items.hM, dispensebehaviormaybe);
        BlockDispenser.a(Items.hO, dispensebehaviormaybe);
        BlockDispenser.a(Items.hP, dispensebehaviormaybe);
        BlockDispenser.a(Items.hS, dispensebehaviormaybe);
        BlockDispenser.a(Items.hK, dispensebehaviormaybe);
        BlockDispenser.a(Items.hQ, dispensebehaviormaybe);
        BlockDispenser.a(Items.hG, dispensebehaviormaybe);
        BlockDispenser.a(Items.hL, dispensebehaviormaybe);
        BlockDispenser.a(Items.hI, dispensebehaviormaybe);
        BlockDispenser.a(Items.hF, dispensebehaviormaybe);
        BlockDispenser.a(Items.hJ, dispensebehaviormaybe);
        BlockDispenser.a(Items.hN, dispensebehaviormaybe);
        BlockDispenser.a(Items.hR, dispensebehaviormaybe);
        BlockDispenser.a(Items.hH, dispensebehaviormaybe);
        BlockDispenser.a(Items.eM, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EntityHorseChestedAbstract entityhorsechestedabstract2;
                BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
                List<EntityHorseChestedAbstract> list = pointer.b().a(EntityHorseChestedAbstract.class, new AxisAlignedBB(blockposition), entityhorsechestedabstract -> entityhorsechestedabstract.bx() && !entityhorsechestedabstract.w());
                Iterator<EntityHorseChestedAbstract> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.a(pointer, stack);
                } while (!(entityhorsechestedabstract2 = iterator1.next()).gt());
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                WorldServer world = pointer.b();
                CraftBlock block = CraftBlock.at(world, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorsechestedabstract2.getBukkitEntity()));
                if (!BlockDispenser.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.e.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                entityhorsechestedabstract2.a_(499).a(CraftItemStack.asNMSCopy(event.getItem()));
                if (shrink) {
                    stack.h(1);
                }
                this.a(true);
                return stack;
            }
        });
        BlockDispenser.a(Items.un, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.d().c(BlockDispenser.b);
                WorldServer worldserver = pointer.b();
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                CraftBlock block = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(enumdirection.j(), enumdirection.k(), enumdirection.l()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.e.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
                Vec3D vec3d = IDispenseBehavior.a(pointer, EntityTypes.N, enumdirection);
                EntityFireworks entityfireworks = new EntityFireworks((net.minecraft.world.level.World)pointer.b(), itemstack1, vec3d.a(), vec3d.b(), vec3d.c(), true);
                entityfireworks.projectileSource = new CraftBlockProjectileSource(pointer.e());
                entityfireworks.c(enumdirection.j(), enumdirection.k(), enumdirection.l(), 0.5f, 1.0f);
                pointer.b().b(entityfireworks);
                if (shrink) {
                    stack.h(1);
                }
                return stack;
            }

            @Override
            protected void a(SourceBlock pointer) {
                pointer.b().c(1004, pointer.c(), 0);
            }
        });
        BlockDispenser.a(Items.tS, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.d().c(BlockDispenser.b);
                IPosition iposition = BlockDispenser.a(pointer);
                double d0 = iposition.a() + (double)((float)enumdirection.j() * 0.3f);
                double d1 = iposition.b() + (double)((float)enumdirection.k() * 0.3f);
                double d2 = iposition.c() + (double)((float)enumdirection.l() * 0.3f);
                WorldServer worldserver = pointer.b();
                RandomSource randomsource = worldserver.z;
                double d3 = randomsource.a((double)enumdirection.j(), 0.11485000000000001);
                double d4 = randomsource.a((double)enumdirection.k(), 0.11485000000000001);
                double d5 = randomsource.a((double)enumdirection.l(), 0.11485000000000001);
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                CraftBlock block = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(d3, d4, d5));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.e.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                EntitySmallFireball entitysmallfireball = new EntitySmallFireball(worldserver, d0, d1, d2, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ());
                entitysmallfireball.a(CraftItemStack.unwrap(event.getItem()));
                entitysmallfireball.projectileSource = new CraftBlockProjectileSource(pointer.e());
                worldserver.b(entitysmallfireball);
                if (shrink) {
                    stack.h(1);
                }
                return stack;
            }

            @Override
            protected void a(SourceBlock pointer) {
                pointer.b().c(1018, pointer.c(), 0);
            }
        });
        BlockDispenser.a(Items.nT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.a));
        BlockDispenser.a(Items.nV, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.b));
        BlockDispenser.a(Items.nX, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.c));
        BlockDispenser.a(Items.nZ, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.d));
        BlockDispenser.a(Items.of, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.g));
        BlockDispenser.a(Items.ob, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.e));
        BlockDispenser.a(Items.od, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.f));
        BlockDispenser.a(Items.oh, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.h));
        BlockDispenser.a(Items.oj, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.i));
        BlockDispenser.a(Items.nU, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.a, true));
        BlockDispenser.a(Items.nW, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.b, true));
        BlockDispenser.a(Items.nY, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.c, true));
        BlockDispenser.a(Items.oa, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.d, true));
        BlockDispenser.a(Items.og, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.g, true));
        BlockDispenser.a(Items.oc, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.e, true));
        BlockDispenser.a(Items.oe, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.f, true));
        BlockDispenser.a(Items.oi, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.h, true));
        BlockDispenser.a(Items.ok, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.i, true));
        DispenseBehaviorItem dispensebehavioritem1 = new DispenseBehaviorItem(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            /*
             * Unable to fully structure code
             */
            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                dispensiblecontaineritem = (DispensibleContainerItem)stack.d();
                blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
                worldserver = pointer.b();
                x = blockposition.u();
                y = blockposition.v();
                z = blockposition.w();
                iblockdata = worldserver.a_(blockposition);
                dispensedItem = stack;
                v0 = willEmptyContentsSolidBucketItem = dispensiblecontaineritem instanceof SolidBucketItem != false && worldserver.k(blockposition) != false && iblockdata.i() != false;
                if (!(dispensiblecontaineritem instanceof ItemBucket)) ** GOTO lbl-1000
                bucketItem = (ItemBucket)dispensiblecontaineritem;
                if (bucketItem.a instanceof FluidTypeFlowing && (iblockdata.i() || iblockdata.a(bucketItem.a) || (var15_13 = iblockdata.b()) instanceof IFluidContainer && (liquidBlockContainer = (IFluidContainer)var15_13).a(null, worldserver, blockposition, iblockdata, bucketItem.a))) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = willEmptyBucketItem = false;
                }
                if (willEmptyContentsSolidBucketItem || willEmptyBucketItem) {
                    block = CraftBlock.at(worldserver, pointer.c());
                    craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                    event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(x, y, z));
                    if (!BlockDispenser.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.e.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != IDispenseBehavior.b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    dispensedItem = CraftItemStack.unwrap(event.getItem());
                    dispensiblecontaineritem = (DispensibleContainerItem)dispensedItem.d();
                }
                if (dispensiblecontaineritem.a((EntityHuman)null, (net.minecraft.world.level.World)worldserver, blockposition, (MovingObjectPositionBlock)null)) {
                    dispensiblecontaineritem.a((EntityHuman)null, (net.minecraft.world.level.World)worldserver, dispensedItem, blockposition);
                    item = Items.qv;
                    stack.h(1);
                    if (stack.b()) {
                        stack = new net.minecraft.world.item.ItemStack(item);
                    } else if (pointer.e().a(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.c.dispense(pointer, new net.minecraft.world.item.ItemStack(item));
                    }
                    return stack;
                }
                return this.c.dispense(pointer, stack);
            }
        };
        BlockDispenser.a(Items.qx, dispensebehavioritem1);
        BlockDispenser.a(Items.qw, dispensebehavioritem1);
        BlockDispenser.a(Items.qy, dispensebehavioritem1);
        BlockDispenser.a(Items.qD, dispensebehavioritem1);
        BlockDispenser.a(Items.qE, dispensebehavioritem1);
        BlockDispenser.a(Items.qC, dispensebehavioritem1);
        BlockDispenser.a(Items.qF, dispensebehavioritem1);
        BlockDispenser.a(Items.qG, dispensebehavioritem1);
        BlockDispenser.a(Items.qH, dispensebehavioritem1);
        BlockDispenser.a(Items.qv, new DispenseBehaviorItem(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPosition blockposition;
                WorldServer worldserver = pointer.b();
                IBlockData iblockdata = worldserver.a_(blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b)));
                Block block = iblockdata.b();
                if (block instanceof IFluidSource) {
                    net.minecraft.world.item.ItemStack eventStack;
                    IDispenseBehavior idispensebehavior;
                    IFluidSource ifluidsource = (IFluidSource)((Object)block);
                    net.minecraft.world.item.ItemStack itemstack1 = ifluidsource.a(null, DummyGeneratorAccess.INSTANCE, blockposition, iblockdata);
                    if (itemstack1.b()) {
                        return super.a(pointer, stack);
                    }
                    worldserver.a((Entity)null, GameEvent.y, blockposition);
                    Item item = itemstack1.d();
                    CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.c());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                    BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                    if (!BlockDispenser.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.e.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    itemstack1 = ifluidsource.a(null, worldserver, blockposition, iblockdata);
                    stack.h(1);
                    if (stack.b()) {
                        return new net.minecraft.world.item.ItemStack(item);
                    }
                    if (pointer.e().a(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.c.dispense(pointer, new net.minecraft.world.item.ItemStack(item));
                    }
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.op, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = pointer.b();
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.e.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                this.a(true);
                EnumDirection enumdirection = pointer.d().c(BlockDispenser.b);
                BlockPosition blockposition = pointer.c().a(enumdirection);
                IBlockData iblockdata = worldserver.a_(blockposition);
                if (BlockFireAbstract.a((net.minecraft.world.level.World)worldserver, blockposition, enumdirection)) {
                    if (!CraftEventFactory.callBlockIgniteEvent((net.minecraft.world.level.World)worldserver, blockposition, pointer.c()).isCancelled()) {
                        worldserver.b(blockposition, BlockFireAbstract.a(worldserver, blockposition));
                        worldserver.a((Entity)null, GameEvent.i, blockposition);
                    }
                } else if (!(BlockCampfire.h(iblockdata) || CandleBlock.g(iblockdata) || CandleCakeBlock.g(iblockdata))) {
                    if (iblockdata.b() instanceof BlockTNT && CraftEventFactory.callTNTPrimeEvent(worldserver, blockposition, TNTPrimeEvent.PrimeCause.DISPENSER, null, pointer.c())) {
                        BlockTNT.a(worldserver, blockposition);
                        worldserver.a(blockposition, false);
                    } else {
                        this.a(false);
                    }
                } else {
                    worldserver.b(blockposition, (IBlockData)iblockdata.a(BlockProperties.r, true));
                    worldserver.a((Entity)null, GameEvent.c, blockposition);
                }
                if (this.a() && stack.hurt(1, worldserver.z, null)) {
                    stack.f(0);
                }
                return stack;
            }
        });
        BlockDispenser.a(Items.rv, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                this.a(true);
                WorldServer worldserver = pointer.b();
                BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
                CraftBlock block = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.e.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                worldserver.captureTreeGeneration = true;
                if (!ItemBoneMeal.a(stack, worldserver, blockposition) && !ItemBoneMeal.a(stack, worldserver, blockposition, null)) {
                    this.a(false);
                } else if (!worldserver.B) {
                    worldserver.c(1505, blockposition, 0);
                }
                worldserver.captureTreeGeneration = false;
                if (worldserver.capturedBlockStates.size() > 0) {
                    TreeType treeType = BlockSapling.treeType;
                    BlockSapling.treeType = null;
                    Location location = CraftLocation.toBukkit(blockposition, (World)worldserver.getWorld());
                    ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(worldserver.capturedBlockStates.values());
                    worldserver.capturedBlockStates.clear();
                    StructureGrowEvent structureEvent = null;
                    if (treeType != null) {
                        structureEvent = new StructureGrowEvent(location, treeType, false, null, blocks);
                        Bukkit.getPluginManager().callEvent((Event)structureEvent);
                    }
                    BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent(location.getBlock(), null, blocks);
                    fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
                    Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
                    if (!fertilizeEvent.isCancelled()) {
                        for (BlockState blockState : blocks) {
                            blockState.update(true);
                            worldserver.checkCapturedTreeStateForObserverNotify(blockposition, (CraftBlockState)blockState);
                        }
                    }
                }
                return stack;
            }
        });
        BlockDispenser.a(Blocks.ck, new DispenseBehaviorItem(){

            @Override
            protected net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                WorldServer worldserver = pointer.b();
                BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
                net.minecraft.world.item.ItemStack itemstack1 = stack.c(1);
                CraftBlock block = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector((double)blockposition.u() + 0.5, (double)blockposition.v(), (double)blockposition.w() + 0.5));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.e.get(eventStack.d());
                    if (idispensebehavior != b && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), null);
                worldserver.b(entitytntprimed);
                worldserver.a((EntityHuman)null, entitytntprimed.dr(), entitytntprimed.dt(), entitytntprimed.dx(), SoundEffects.yB, SoundCategory.e, 1.0f, 1.0f);
                worldserver.a((Entity)null, GameEvent.t, blockposition);
                if (shrink) {
                    stack.h(1);
                }
                return stack;
            }
        });
        DispenseBehaviorMaybe dispensebehaviormaybe1 = new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                this.a(ItemArmor.dispenseArmor(pointer, stack, this));
                return stack;
            }
        };
        BlockDispenser.a(Items.ui, dispensebehaviormaybe1);
        BlockDispenser.a(Items.uh, dispensebehaviormaybe1);
        BlockDispenser.a(Items.uj, dispensebehaviormaybe1);
        BlockDispenser.a(Items.ue, dispensebehaviormaybe1);
        BlockDispenser.a(Items.uk, dispensebehaviormaybe1);
        BlockDispenser.a(Items.ug, dispensebehaviormaybe1);
        BlockDispenser.a(Items.uf, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = pointer.b();
                EnumDirection enumdirection = pointer.d().c(BlockDispenser.b);
                BlockPosition blockposition = pointer.c().a(enumdirection);
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.e.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (worldserver.u(blockposition) && BlockWitherSkull.b(worldserver, blockposition, stack)) {
                    worldserver.a(blockposition, (IBlockData)Blocks.gG.o().a(BlockSkull.e, RotationSegment.a(enumdirection)), 3);
                    worldserver.a((Entity)null, GameEvent.i, blockposition);
                    TileEntity tileentity = worldserver.c_(blockposition);
                    if (tileentity instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)worldserver, blockposition, (TileEntitySkull)tileentity);
                    }
                    stack.h(1);
                    this.a(true);
                } else {
                    this.a(ItemArmor.dispenseArmor(pointer, stack, this));
                }
                return stack;
            }
        });
        BlockDispenser.a(Blocks.ee, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = pointer.b();
                BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
                BlockPumpkinCarved blockpumpkincarved = (BlockPumpkinCarved)Blocks.ee;
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.e.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (worldserver.u(blockposition) && blockpumpkincarved.a((IWorldReader)worldserver, blockposition)) {
                    if (!worldserver.B) {
                        worldserver.a(blockposition, blockpumpkincarved.o(), 3);
                        worldserver.a((Entity)null, GameEvent.i, blockposition);
                    }
                    stack.h(1);
                    this.a(true);
                } else {
                    this.a(ItemArmor.dispenseArmor(pointer, stack, this));
                }
                return stack;
            }
        });
        BlockDispenser.a(Blocks.kP.k(), new DispenseBehaviorShulkerBox());
        for (EnumColor enumcolor : EnumColor.values()) {
            BlockDispenser.a(BlockShulkerBox.a(enumcolor).k(), new DispenseBehaviorShulkerBox());
        }
        BlockDispenser.a(Items.si.k(), new DispenseBehaviorMaybe(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            private net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack emptyBottleStack, net.minecraft.world.item.ItemStack filledBottleStack) {
                emptyBottleStack.h(1);
                if (emptyBottleStack.b()) {
                    pointer.b().a((Entity)null, GameEvent.y, pointer.c());
                    return filledBottleStack.p();
                }
                if (pointer.e().a(filledBottleStack.p()) < 0) {
                    this.c.dispense(pointer, filledBottleStack.p());
                }
                return emptyBottleStack;
            }

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                this.a(false);
                WorldServer worldserver = pointer.b();
                BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
                IBlockData iblockdata = worldserver.a_(blockposition);
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.c());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.c(1));
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.u(), blockposition.v(), blockposition.w()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.e.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).d())) != b && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (iblockdata.a(TagsBlock.aF, (BlockBase.BlockData blockbase_blockdata) -> blockbase_blockdata.b(BlockBeehive.c) && blockbase_blockdata.b() instanceof BlockBeehive) && iblockdata.c(BlockBeehive.c) >= 5) {
                    ((BlockBeehive)iblockdata.b()).a((net.minecraft.world.level.World)worldserver, iblockdata, blockposition, (EntityHuman)null, TileEntityBeehive.ReleaseStatus.b);
                    this.a(true);
                    return this.a(pointer, stack, new net.minecraft.world.item.ItemStack(Items.wq));
                }
                if (worldserver.b_(blockposition).a(TagsFluid.a)) {
                    this.a(true);
                    return this.a(pointer, stack, PotionUtil.a(new net.minecraft.world.item.ItemStack(Items.sh), Potions.c));
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.ft, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                EnumDirection enumdirection = pointer.d().c(BlockDispenser.b);
                BlockPosition blockposition = pointer.c().a(enumdirection);
                WorldServer worldserver = pointer.b();
                IBlockData iblockdata = worldserver.a_(blockposition);
                this.a(true);
                if (iblockdata.a(Blocks.pl)) {
                    if (iblockdata.c(BlockRespawnAnchor.d) != 4) {
                        net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(pointer, blockposition, stack, this);
                        if (result != null) {
                            this.a(false);
                            return result;
                        }
                        BlockRespawnAnchor.a((Entity)null, (net.minecraft.world.level.World)worldserver, blockposition, iblockdata);
                        stack.h(1);
                    } else {
                        this.a(false);
                    }
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.rS.k(), new DispenseBehaviorShears());
        BlockDispenser.a(Items.wn, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPosition blockposition = pointer.c().a(pointer.d().c(BlockDispenser.b));
                WorldServer worldserver = pointer.b();
                IBlockData iblockdata = worldserver.a_(blockposition);
                Optional<IBlockData> optional = HoneycombItem.b(iblockdata);
                if (optional.isPresent()) {
                    net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(pointer, blockposition, stack, this);
                    if (result != null) {
                        this.a(false);
                        return result;
                    }
                    worldserver.b(blockposition, optional.get());
                    worldserver.c(3003, blockposition, 0);
                    stack.h(1);
                    this.a(true);
                    return stack;
                }
                return super.a(pointer, stack);
            }
        });
        BlockDispenser.a(Items.sh, new DispenseBehaviorItem(){
            private final DispenseBehaviorItem c = new DispenseBehaviorItem();

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock pointer, net.minecraft.world.item.ItemStack stack) {
                if (PotionUtil.d(stack) != Potions.c) {
                    return this.c.dispense(pointer, stack);
                }
                WorldServer worldserver = pointer.b();
                BlockPosition blockposition = pointer.c();
                BlockPosition blockposition1 = pointer.c().a(pointer.d().c(BlockDispenser.b));
                if (!worldserver.a_(blockposition1).a(TagsBlock.ca)) {
                    return this.c.dispense(pointer, stack);
                }
                net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(pointer, blockposition1, stack, this);
                if (result != null) {
                    return result;
                }
                if (!worldserver.B) {
                    for (int k2 = 0; k2 < 5; ++k2) {
                        worldserver.a(Particles.aj, (double)blockposition.u() + worldserver.z.j(), (double)(blockposition.v() + 1), (double)blockposition.w() + worldserver.z.j(), 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                worldserver.a((EntityHuman)null, blockposition, SoundEffects.ch, SoundCategory.e, 1.0f, 1.0f);
                worldserver.a((Entity)null, GameEvent.z, blockposition);
                worldserver.b(blockposition1, Blocks.sI.o());
                return new net.minecraft.world.item.ItemStack(Items.si);
            }
        });
        BlockDispenser.a(Items.hc, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack a(SourceBlock dispenser, net.minecraft.world.item.ItemStack stack) {
                WorldServer level = dispenser.b();
                if (!level.purpurConfig.dispenserPlaceAnvils) {
                    return super.a(dispenser, stack);
                }
                EnumDirection facing = dispenser.e().r().c(BlockDispenser.b);
                BlockPosition pos = dispenser.c().a(facing);
                IBlockData state = level.a_(pos);
                if (state.i()) {
                    level.b(pos, (IBlockData)Blocks.gS.o().a(BlockAnvil.b, facing.o() == EnumDirection.EnumAxis.b ? EnumDirection.c : facing.h()));
                    stack.h(1);
                }
                return stack;
            }
        });
    }

    public static Vec3D a(SourceBlock pointer, EntityTypes<?> entityType, EnumDirection direction) {
        return pointer.a().b((double)direction.j() * (0.5000099999997474 - (double)entityType.k() / 2.0), (double)direction.k() * (0.5000099999997474 - (double)entityType.l() / 2.0) - (double)entityType.l() / 2.0, (double)direction.l() * (0.5000099999997474 - (double)entityType.k() / 2.0));
    }
}

