/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.registries;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.numbers.NumberFormatType;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Instruments;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.biome.BiomeSources;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGenerators;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBindings;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class BuiltInRegistries {
    private static final Logger at = LogUtils.getLogger();
    private static final Map<MinecraftKey, Supplier<?>> au = Maps.newLinkedHashMap();
    private static final IRegistryWritable<IRegistryWritable<?>> av = new RegistryMaterials(ResourceKey.a(Registries.a), Lifecycle.stable());
    public static final RegistryBlocks<GameEvent> a = BuiltInRegistries.b(Registries.B, "step", registry -> GameEvent.P);
    public static final IRegistry<SoundEffect> b = BuiltInRegistries.a(Registries.af, (IRegistry<T> registry) -> SoundEffects.mO);
    public static final RegistryBlocks<FluidType> c = BuiltInRegistries.b(Registries.y, "empty", registry -> FluidTypes.a);
    public static final IRegistry<MobEffectList> d = BuiltInRegistries.b(Registries.Q, registry -> MobEffects.z);
    public static final RegistryBlocks<Block> e = BuiltInRegistries.b(Registries.f, "air", registry -> Blocks.a);
    public static final IRegistry<Enchantment> f = BuiltInRegistries.b(Registries.t, registry -> Enchantments.x);
    public static final RegistryBlocks<EntityTypes<?>> g = BuiltInRegistries.b(Registries.u, "pig", registry -> EntityTypes.aw);
    public static final RegistryBlocks<Item> h = BuiltInRegistries.b(Registries.F, "air", registry -> Items.a);
    public static final RegistryBlocks<PotionRegistry> i = BuiltInRegistries.b(Registries.X, "empty", registry -> Potions.b);
    public static final IRegistry<Particle<?>> j = BuiltInRegistries.a(Registries.S, (IRegistry<T> registry) -> Particles.c);
    public static final IRegistry<TileEntityTypes<?>> k = BuiltInRegistries.b(Registries.h, registry -> TileEntityTypes.a);
    public static final RegistryBlocks<PaintingVariant> l = BuiltInRegistries.a(Registries.R, "kebab", PaintingVariants::a);
    public static final IRegistry<MinecraftKey> m = BuiltInRegistries.a(Registries.q, (IRegistry<T> registry) -> StatisticList.E);
    public static final RegistryBlocks<ChunkStatus> n = BuiltInRegistries.a(Registries.n, "empty", (IRegistry<T> registry) -> ChunkStatus.c);
    public static final IRegistry<DefinedStructureRuleTestType<?>> o = BuiltInRegistries.a(Registries.ab, (IRegistry<T> registry) -> DefinedStructureRuleTestType.a);
    public static final IRegistry<RuleBlockEntityModifierType<?>> p = BuiltInRegistries.a(Registries.ac, (IRegistry<T> registry) -> RuleBlockEntityModifierType.b);
    public static final IRegistry<PosRuleTestType<?>> q = BuiltInRegistries.a(Registries.W, (IRegistry<T> registry) -> PosRuleTestType.a);
    public static final IRegistry<Containers<?>> r = BuiltInRegistries.a(Registries.P, (IRegistry<T> registry) -> Containers.i);
    public static final IRegistry<Recipes<?>> s = BuiltInRegistries.a(Registries.Z, (IRegistry<T> registry) -> Recipes.a);
    public static final IRegistry<RecipeSerializer<?>> t = BuiltInRegistries.a(Registries.Y, (IRegistry<T> registry) -> RecipeSerializer.b);
    public static final IRegistry<AttributeBase> u = BuiltInRegistries.a(Registries.c, (IRegistry<T> registry) -> GenericAttributes.j);
    public static final IRegistry<PositionSourceType<?>> v = BuiltInRegistries.a(Registries.V, (IRegistry<T> registry) -> PositionSourceType.a);
    public static final IRegistry<ArgumentTypeInfo<?, ?>> w = BuiltInRegistries.a(Registries.o, ArgumentTypeInfos::a);
    public static final IRegistry<StatisticWrapper<?>> x = BuiltInRegistries.a(Registries.ag, (IRegistry<T> registry) -> StatisticList.c);
    public static final RegistryBlocks<VillagerType> y = BuiltInRegistries.a(Registries.aq, "plains", (IRegistry<T> registry) -> VillagerType.c);
    public static final RegistryBlocks<VillagerProfession> z = BuiltInRegistries.a(Registries.ap, "none", (IRegistry<T> registry) -> VillagerProfession.b);
    public static final IRegistry<VillagePlaceType> A = BuiltInRegistries.a(Registries.U, PoiTypes::a);
    public static final RegistryBlocks<MemoryModuleType<?>> B = BuiltInRegistries.a(Registries.O, "dummy", (IRegistry<T> registry) -> MemoryModuleType.a);
    public static final RegistryBlocks<SensorType<?>> C = BuiltInRegistries.a(Registries.ae, "dummy", (IRegistry<T> registry) -> SensorType.a);
    public static final IRegistry<Schedule> D = BuiltInRegistries.a(Registries.ad, (IRegistry<T> registry) -> Schedule.c);
    public static final IRegistry<Activity> E = BuiltInRegistries.a(Registries.b, (IRegistry<T> registry) -> Activity.b);
    public static final IRegistry<LootEntryType> F = BuiltInRegistries.a(Registries.K, (IRegistry<T> registry) -> LootEntries.b);
    public static final IRegistry<LootItemFunctionType> G = BuiltInRegistries.a(Registries.H, (IRegistry<T> registry) -> LootItemFunctions.c);
    public static final IRegistry<LootItemConditionType> H = BuiltInRegistries.a(Registries.G, (IRegistry<T> registry) -> LootItemConditions.b);
    public static final IRegistry<LootNumberProviderType> I = BuiltInRegistries.a(Registries.J, (IRegistry<T> registry) -> NumberProviders.b);
    public static final IRegistry<LootNbtProviderType> J = BuiltInRegistries.a(Registries.I, (IRegistry<T> registry) -> NbtProviders.c);
    public static final IRegistry<LootScoreProviderType> K = BuiltInRegistries.a(Registries.L, (IRegistry<T> registry) -> ScoreboardNameProviders.c);
    public static final IRegistry<FloatProviderType<?>> L = BuiltInRegistries.a(Registries.x, (IRegistry<T> registry) -> FloatProviderType.a);
    public static final IRegistry<IntProviderType<?>> M = BuiltInRegistries.a(Registries.E, (IRegistry<T> registry) -> IntProviderType.a);
    public static final IRegistry<HeightProviderType<?>> N = BuiltInRegistries.a(Registries.C, (IRegistry<T> registry) -> HeightProviderType.a);
    public static final IRegistry<BlockPredicateType<?>> O = BuiltInRegistries.a(Registries.i, (IRegistry<T> registry) -> BlockPredicateType.k);
    public static final IRegistry<WorldGenCarverAbstract<?>> P = BuiltInRegistries.a(Registries.k, (IRegistry<T> registry) -> WorldGenCarverAbstract.a);
    public static final IRegistry<WorldGenerator<?>> Q = BuiltInRegistries.a(Registries.v, (IRegistry<T> registry) -> WorldGenerator.I);
    public static final IRegistry<StructurePlacementType<?>> R = BuiltInRegistries.a(Registries.ai, (IRegistry<T> registry) -> StructurePlacementType.a);
    public static final IRegistry<WorldGenFeatureStructurePieceType> S = BuiltInRegistries.a(Registries.ah, (IRegistry<T> registry) -> WorldGenFeatureStructurePieceType.c);
    public static final IRegistry<StructureType<?>> T = BuiltInRegistries.a(Registries.am, (IRegistry<T> registry) -> StructureType.f);
    public static final IRegistry<PlacementModifierType<?>> U = BuiltInRegistries.a(Registries.T, (IRegistry<T> registry) -> PlacementModifierType.f);
    public static final IRegistry<WorldGenFeatureStateProviders<?>> V = BuiltInRegistries.a(Registries.j, (IRegistry<T> registry) -> WorldGenFeatureStateProviders.a);
    public static final IRegistry<WorldGenFoilagePlacers<?>> W = BuiltInRegistries.a(Registries.z, (IRegistry<T> registry) -> WorldGenFoilagePlacers.a);
    public static final IRegistry<TrunkPlacers<?>> X = BuiltInRegistries.a(Registries.ao, (IRegistry<T> registry) -> TrunkPlacers.a);
    public static final IRegistry<RootPlacerType<?>> Y = BuiltInRegistries.a(Registries.aa, (IRegistry<T> registry) -> RootPlacerType.a);
    public static final IRegistry<WorldGenFeatureTrees<?>> Z = BuiltInRegistries.a(Registries.an, (IRegistry<T> registry) -> WorldGenFeatureTrees.b);
    public static final IRegistry<FeatureSizeType<?>> aa = BuiltInRegistries.a(Registries.w, (IRegistry<T> registry) -> FeatureSizeType.a);
    public static final IRegistry<Codec<? extends WorldChunkManager>> ab = BuiltInRegistries.a(Registries.e, Lifecycle.stable(), BiomeSources::a);
    public static final IRegistry<Codec<? extends ChunkGenerator>> ac = BuiltInRegistries.a(Registries.m, Lifecycle.stable(), ChunkGenerators::a);
    public static final IRegistry<Codec<? extends SurfaceRules.f>> ad = BuiltInRegistries.a(Registries.M, SurfaceRules.f::a);
    public static final IRegistry<Codec<? extends SurfaceRules.o>> ae = BuiltInRegistries.a(Registries.N, SurfaceRules.o::a);
    public static final IRegistry<Codec<? extends DensityFunction>> af = BuiltInRegistries.a(Registries.s, DensityFunctions::a);
    public static final IRegistry<MapCodec<? extends Block>> ag = BuiltInRegistries.a(Registries.g, BlockTypes::a);
    public static final IRegistry<DefinedStructureStructureProcessorType<?>> ah = BuiltInRegistries.a(Registries.al, (IRegistry<T> registry) -> DefinedStructureStructureProcessorType.e);
    public static final IRegistry<WorldGenFeatureDefinedStructurePools<?>> ai = BuiltInRegistries.a(Registries.aj, (IRegistry<T> registry) -> WorldGenFeatureDefinedStructurePools.d);
    public static final IRegistry<Codec<? extends PoolAliasBinding>> aj = BuiltInRegistries.a(Registries.ak, PoolAliasBindings::a);
    public static final IRegistry<CatVariant> ak = BuiltInRegistries.a(Registries.l, CatVariant::a);
    public static final IRegistry<FrogVariant> al = BuiltInRegistries.a(Registries.A, (IRegistry<T> registry) -> FrogVariant.a);
    public static final IRegistry<EnumBannerPatternType> am = BuiltInRegistries.a(Registries.d, BannerPatterns::a);
    public static final IRegistry<Instrument> an = BuiltInRegistries.a(Registries.D, Instruments::a);
    public static final IRegistry<String> ao = BuiltInRegistries.a(Registries.ar, DecoratedPotPatterns::a);
    public static final IRegistry<CreativeModeTab> ap = BuiltInRegistries.a(Registries.p, CreativeModeTabs::a);
    public static final IRegistry<CriterionTrigger<?>> aq = BuiltInRegistries.a(Registries.aH, CriterionTriggers::a);
    public static final IRegistry<NumberFormatType<?>> ar = BuiltInRegistries.a(Registries.as, NumberFormatTypes::a);
    public static final IRegistry<? extends IRegistry<?>> as = av;

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, a<T> initializer) {
        return BuiltInRegistries.a(key, Lifecycle.stable(), initializer);
    }

    private static <T> IRegistry<T> b(ResourceKey<? extends IRegistry<T>> key, a<T> initializer) {
        return BuiltInRegistries.a(key, new RegistryMaterials(key, Lifecycle.stable(), true), initializer, Lifecycle.stable());
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, a<T> initializer) {
        return BuiltInRegistries.a(key, defaultId, Lifecycle.stable(), initializer);
    }

    private static <T> RegistryBlocks<T> b(ResourceKey<? extends IRegistry<T>> key, String defaultId, a<T> initializer) {
        return BuiltInRegistries.b(key, defaultId, Lifecycle.stable(), initializer);
    }

    private static <T> IRegistry<T> a(ResourceKey<? extends IRegistry<T>> key, Lifecycle lifecycle, a<T> initializer) {
        return BuiltInRegistries.a(key, new RegistryMaterials(key, lifecycle, false), initializer, lifecycle);
    }

    private static <T> RegistryBlocks<T> a(ResourceKey<? extends IRegistry<T>> key, String defaultId, Lifecycle lifecycle, a<T> initializer) {
        return BuiltInRegistries.a(key, new DefaultedMappedRegistry(defaultId, key, lifecycle, false), initializer, lifecycle);
    }

    private static <T> RegistryBlocks<T> b(ResourceKey<? extends IRegistry<T>> key, String defaultId, Lifecycle lifecycle, a<T> initializer) {
        return BuiltInRegistries.a(key, new DefaultedMappedRegistry(defaultId, key, lifecycle, true), initializer, lifecycle);
    }

    private static <T, R extends IRegistryWritable<T>> R a(ResourceKey<? extends IRegistry<T>> key, R registry, a<T> initializer, Lifecycle lifecycle) {
        DispenserRegistry.a(() -> "registry " + key);
        MinecraftKey resourceLocation = key.a();
        au.put(resourceLocation, () -> initializer.run(registry));
        av.a(key, registry, lifecycle);
        return registry;
    }

    public static void a() {
        BuiltInRegistries.bootStrap(() -> {});
    }

    public static void bootStrap(Runnable runnable) {
        BuiltInRegistries.b();
        runnable.run();
        BuiltInRegistries.c();
        BuiltInRegistries.a(as);
    }

    private static void b() {
        au.forEach((id, initializer) -> {
            if (initializer.get() == null) {
                at.error("Unable to bootstrap registry '{}'", id);
            }
        });
    }

    private static void c() {
        as.l();
        for (IRegistry iRegistry : as) {
            iRegistry.l();
        }
    }

    private static <T extends IRegistry<?>> void a(IRegistry<T> registries) {
        registries.forEach(registry -> {
            if (registry.e().isEmpty()) {
                SystemUtils.a("Registry '" + registries.b(registry) + "' was empty after loading");
            }
            if (registry instanceof RegistryBlocks) {
                MinecraftKey resourceLocation = ((RegistryBlocks)registry).a();
                Validate.notNull(registry.a(resourceLocation), (String)("Missing default of DefaultedMappedRegistry: " + resourceLocation), (Object[])new Object[0]);
            }
        });
    }

    @FunctionalInterface
    static interface a<T> {
        public T run(IRegistry<T> var1);
    }
}

