/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.Items;

public class ItemModelGenerators {
    public static final MinecraftKey a = new MinecraftKey("trim_type");
    private static final List<a> b = List.of(new a("quartz", 0.1f, Map.of()), new a("iron", 0.2f, Map.of(EnumArmorMaterial.c, "iron_darker")), new a("netherite", 0.3f, Map.of(EnumArmorMaterial.g, "netherite_darker")), new a("redstone", 0.4f, Map.of()), new a("copper", 0.5f, Map.of()), new a("gold", 0.6f, Map.of(EnumArmorMaterial.d, "gold_darker")), new a("emerald", 0.7f, Map.of()), new a("diamond", 0.8f, Map.of(EnumArmorMaterial.e, "diamond_darker")), new a("lapis", 0.9f, Map.of()), new a("amethyst", 1.0f, Map.of()));
    private final BiConsumer<MinecraftKey, Supplier<JsonElement>> c;

    public ItemModelGenerators(BiConsumer<MinecraftKey, Supplier<JsonElement>> writer) {
        this.c = writer;
    }

    private void a(Item item, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item), TextureMapping.b(item), this.c);
    }

    private void a(Item item, String suffix, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item, suffix), TextureMapping.k(TextureMapping.a(item, suffix)), this.c);
    }

    private void a(Item item, Item texture, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item), TextureMapping.b(texture), this.c);
    }

    private void a(Item compass) {
        for (int i2 = 0; i2 < 32; ++i2) {
            if (i2 == 16) continue;
            this.a(compass, String.format(Locale.ROOT, "_%02d", i2), ModelTemplates.bx);
        }
    }

    private void b(Item clock) {
        for (int i2 = 1; i2 < 64; ++i2) {
            this.a(clock, String.format(Locale.ROOT, "_%02d", i2), ModelTemplates.bx);
        }
    }

    private void a(MinecraftKey id, MinecraftKey layer0, MinecraftKey layer1) {
        ModelTemplates.bB.a(id, TextureMapping.c(layer0, layer1), this.c);
    }

    private void a(MinecraftKey id, MinecraftKey layer0, MinecraftKey layer1, MinecraftKey layer2) {
        ModelTemplates.bC.a(id, TextureMapping.a(layer0, layer1, layer2), this.c);
    }

    private MinecraftKey a(MinecraftKey id, String trimMaterialName) {
        return id.e("_" + trimMaterialName + "_trim");
    }

    private JsonObject a(MinecraftKey id, Map<TextureSlot, MinecraftKey> textures, ArmorMaterial armorMaterial) {
        JsonObject jsonObject = ModelTemplates.bB.a(id, textures);
        JsonArray jsonArray = new JsonArray();
        for (a trimModelData : b) {
            JsonObject jsonObject2 = new JsonObject();
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty(a.a(), (Number)Float.valueOf(trimModelData.b()));
            jsonObject2.add("predicate", (JsonElement)jsonObject3);
            jsonObject2.addProperty("model", this.a(id, trimModelData.a(armorMaterial)).toString());
            jsonArray.add((JsonElement)jsonObject2);
        }
        jsonObject.add("overrides", (JsonElement)jsonArray);
        return jsonObject;
    }

    private void a(ItemArmor armor) {
        MinecraftKey resourceLocation = ModelLocationUtils.a(armor);
        MinecraftKey resourceLocation2 = TextureMapping.c(armor);
        MinecraftKey resourceLocation3 = TextureMapping.a(armor, "_overlay");
        if (armor.d() == EnumArmorMaterial.a) {
            ModelTemplates.bB.a(resourceLocation, TextureMapping.c(resourceLocation2, resourceLocation3), this.c, (MinecraftKey id, Map<TextureSlot, MinecraftKey> textures) -> this.a(id, textures, armor.d()));
        } else {
            ModelTemplates.bx.a(resourceLocation, TextureMapping.k(resourceLocation2), this.c, (MinecraftKey id, Map<TextureSlot, MinecraftKey> textures) -> this.a(id, textures, armor.d()));
        }
        for (a trimModelData : b) {
            String string = trimModelData.a(armor.d());
            MinecraftKey resourceLocation4 = this.a(resourceLocation, string);
            String string2 = armor.b().b() + "_trim_" + string;
            MinecraftKey resourceLocation5 = new MinecraftKey(string2).d("trims/items/");
            if (armor.d() == EnumArmorMaterial.a) {
                this.a(resourceLocation4, resourceLocation2, resourceLocation3, resourceLocation5);
                continue;
            }
            this.a(resourceLocation4, resourceLocation2, resourceLocation5);
        }
    }

    public void a() {
        this.a(Items.ob, ModelTemplates.bx);
        this.a(Items.od, ModelTemplates.bx);
        this.a(Items.oc, ModelTemplates.bx);
        this.a(Items.oe, ModelTemplates.bx);
        this.a(Items.oz, ModelTemplates.bx);
        this.a(Items.oq, ModelTemplates.bx);
        this.a(Items.uy, ModelTemplates.bx);
        this.a(Items.os, ModelTemplates.bx);
        this.a(Items.ua, ModelTemplates.bx);
        this.a(Items.dQ, ModelTemplates.bz);
        this.a(Items.rX, ModelTemplates.bx);
        this.a(Items.vd, ModelTemplates.bx);
        this.a(Items.vf, ModelTemplates.bx);
        this.a(Items.nX, ModelTemplates.bx);
        this.a(Items.nY, ModelTemplates.bx);
        this.a(Items.ru, ModelTemplates.bx);
        this.a(Items.sl, ModelTemplates.bx);
        this.a(Items.sd, ModelTemplates.bz);
        this.a(Items.rq, ModelTemplates.bx);
        this.a(Items.rv, ModelTemplates.bx);
        this.a(Items.qM, ModelTemplates.bx);
        this.a(Items.pn, ModelTemplates.bx);
        this.a(Items.pu, ModelTemplates.bx);
        this.a(Items.qI, ModelTemplates.bx);
        this.a(Items.rr, ModelTemplates.bx);
        this.a(Items.qv, ModelTemplates.bx);
        this.a(Items.nQ, ModelTemplates.bA);
        this.a(Items.nR, ModelTemplates.bA);
        this.a(Items.ou, ModelTemplates.bx);
        this.a(Items.nM, ModelTemplates.bx);
        this.a(Items.rZ, ModelTemplates.bx);
        this.a(Items.uZ, ModelTemplates.bx);
        this.a(Items.qJ, ModelTemplates.bx);
        this.b(Items.qT);
        this.a(Items.ot, ModelTemplates.bx);
        this.a(Items.qE, ModelTemplates.bx);
        this.a(Items.uF, ModelTemplates.bx);
        this.a(Items.qP);
        this.a(Items.qQ);
        this.a(Items.rY, ModelTemplates.bx);
        this.a(Items.sa, ModelTemplates.bx);
        this.a(Items.ra, ModelTemplates.bx);
        this.a(Items.uH, ModelTemplates.bx);
        this.a(Items.pV, ModelTemplates.bx);
        this.a(Items.uu, ModelTemplates.bx);
        this.a(Items.rb, ModelTemplates.bx);
        this.a(Items.rP, ModelTemplates.bx);
        this.a(Items.oC, ModelTemplates.bx);
        this.a(Items.oD, ModelTemplates.bx);
        this.a(Items.vQ, ModelTemplates.bx);
        this.a(Items.ro, ModelTemplates.bx);
        this.a(Items.of, ModelTemplates.bx);
        this.a(Items.og, ModelTemplates.bx);
        this.a(Items.ov, ModelTemplates.bx);
        this.a(Items.pf, ModelTemplates.bz);
        this.a(Items.pg, ModelTemplates.bz);
        this.a(Items.uB, ModelTemplates.bx);
        this.a(Items.pe, ModelTemplates.bz);
        this.a(Items.pd, ModelTemplates.bz);
        this.a(Items.pc, ModelTemplates.bz);
        this.a(Items.vg, ModelTemplates.bx);
        this.a(Items.rU, ModelTemplates.bx);
        this.a(Items.qO, ModelTemplates.bx);
        this.a(Items.ow, ModelTemplates.bx);
        this.a(Items.up, ModelTemplates.bx);
        this.a(Items.sp, ModelTemplates.bx);
        this.a(Items.sc, ModelTemplates.bx);
        this.a(Items.uY, ModelTemplates.bx);
        this.a(Items.tR, ModelTemplates.bx);
        this.a(Items.sk, ModelTemplates.bx);
        this.a(Items.un, ModelTemplates.bx);
        this.a(Items.tS, ModelTemplates.bx);
        this.a(Items.pT, ModelTemplates.bx);
        this.a(Items.op, ModelTemplates.bx);
        this.a(Items.vP, ModelTemplates.bx);
        this.a(Items.nN, ModelTemplates.bx);
        this.a(Items.se, ModelTemplates.bx);
        this.a(Items.si, ModelTemplates.bx);
        this.a(Items.sq, ModelTemplates.bx);
        this.a(Items.vT, ModelTemplates.bx);
        this.a(Items.wj, ModelTemplates.bx);
        this.a(Items.qV, ModelTemplates.bx);
        this.a(Items.rd, ModelTemplates.bx);
        this.a(Items.tW, ModelTemplates.bx);
        this.a(Items.oE, ModelTemplates.bx);
        this.a(Items.pX, ModelTemplates.bx);
        this.a(Items.oV, ModelTemplates.bz);
        this.a(Items.ud, ModelTemplates.bx);
        this.a(Items.oW, ModelTemplates.bz);
        this.a(Items.uA, ModelTemplates.bx);
        this.a(Items.oU, ModelTemplates.bz);
        this.a(Items.oT, ModelTemplates.bz);
        this.a(Items.oS, ModelTemplates.bz);
        this.a(Items.oF, ModelTemplates.bx);
        this.a(Items.sf, ModelTemplates.bx);
        this.a(Items.rm, ModelTemplates.bx);
        this.a(Items.rs, ModelTemplates.bx);
        this.a(Items.pr, ModelTemplates.bx);
        this.a(Items.vL, ModelTemplates.bx);
        this.a(Items.wn, ModelTemplates.bx);
        this.a(Items.wq, ModelTemplates.bx);
        this.a(Items.nP, ModelTemplates.bx);
        this.a(Items.rc, ModelTemplates.bx);
        this.a(Items.oA, ModelTemplates.bx);
        this.a(Items.pa, ModelTemplates.bz);
        this.a(Items.pb, ModelTemplates.bz);
        this.a(Items.uz, ModelTemplates.bx);
        this.a(Items.oB, ModelTemplates.bx);
        this.a(Items.vo, ModelTemplates.bx);
        this.a(Items.oZ, ModelTemplates.bz);
        this.a(Items.oY, ModelTemplates.bz);
        this.a(Items.oX, ModelTemplates.bz);
        this.a(Items.tV, ModelTemplates.bx);
        this.a(Items.nZ, ModelTemplates.bx);
        this.a(Items.oa, ModelTemplates.bx);
        this.a(Items.vp, ModelTemplates.bx);
        this.a(Items.ox, ModelTemplates.bx);
        this.a(Items.qx, ModelTemplates.bx);
        this.a(Items.qA, ModelTemplates.bx);
        this.a(Items.uC, ModelTemplates.bx);
        this.a(Items.ri, ModelTemplates.bx);
        this.a(Items.rn, ModelTemplates.bx);
        this.a(Items.rk, ModelTemplates.bx);
        this.a(Items.rh, ModelTemplates.bx);
        this.a(Items.sm, ModelTemplates.bx);
        this.a(Items.oh, ModelTemplates.bx);
        this.a(Items.oi, ModelTemplates.bx);
        this.a(Items.oj, ModelTemplates.bx);
        this.a(Items.ok, ModelTemplates.bx);
        this.a(Items.uc, ModelTemplates.bx);
        this.a(Items.rT, ModelTemplates.bx);
        this.a(Items.qB, ModelTemplates.bx);
        this.a(Items.nL, ModelTemplates.bx);
        this.a(Items.vS, ModelTemplates.bx);
        this.a(Items.po, ModelTemplates.bx);
        this.a(Items.vH, ModelTemplates.bx);
        this.a(Items.vB, ModelTemplates.by);
        this.a(Items.vr, ModelTemplates.by);
        this.a(Items.vt, ModelTemplates.by);
        this.a(Items.vs, ModelTemplates.by);
        this.a(Items.vu, ModelTemplates.by);
        this.a(Items.vv, ModelTemplates.by);
        this.a(Items.vw, ModelTemplates.by);
        this.a(Items.vx, ModelTemplates.by);
        this.a(Items.vG, ModelTemplates.by);
        this.a(Items.vy, ModelTemplates.by);
        this.a(Items.vz, ModelTemplates.by);
        this.a(Items.vC, ModelTemplates.by);
        this.a(Items.vA, ModelTemplates.by);
        this.a(Items.vD, ModelTemplates.by);
        this.a(Items.vE, ModelTemplates.by);
        this.a(Items.vF, ModelTemplates.by);
        this.a(Items.uG, ModelTemplates.bx);
        this.a(Items.uE, ModelTemplates.bx);
        this.a(Items.vK, ModelTemplates.bx);
        this.a(Items.pk, ModelTemplates.bz);
        this.a(Items.pl, ModelTemplates.bz);
        this.a(Items.oG, ModelTemplates.bx);
        this.a(Items.pj, ModelTemplates.bz);
        this.a(Items.oH, ModelTemplates.bx);
        this.a(Items.pi, ModelTemplates.bz);
        this.a(Items.ph, ModelTemplates.bz);
        this.a(Items.uq, ModelTemplates.bx);
        this.a(Items.ul, ModelTemplates.bx);
        this.a(Items.nT, ModelTemplates.bx);
        this.a(Items.nU, ModelTemplates.bx);
        this.a(Items.rg, ModelTemplates.bx);
        this.a(Items.pW, ModelTemplates.bx);
        this.a(Items.qL, ModelTemplates.bx);
        this.a(Items.vJ, ModelTemplates.bx);
        this.a(Items.vU, ModelTemplates.bx);
        this.a(Items.rl, ModelTemplates.bx);
        this.a(Items.ub, ModelTemplates.bx);
        this.a(Items.va, ModelTemplates.bx);
        this.a(Items.pU, ModelTemplates.bx);
        this.a(Items.qy, ModelTemplates.bx);
        this.a(Items.us, ModelTemplates.bx);
        this.a(Items.ur, ModelTemplates.bx);
        this.a(Items.qZ, ModelTemplates.bx);
        this.a(Items.qC, ModelTemplates.bx);
        this.a(Items.um, ModelTemplates.bx);
        this.a(Items.rp, ModelTemplates.bx);
        this.a(Items.oy, ModelTemplates.bx);
        this.a(Items.ut, ModelTemplates.bx);
        this.a(Items.uw, ModelTemplates.bx);
        this.a(Items.ux, ModelTemplates.bx);
        this.a(Items.uv, ModelTemplates.bx);
        this.a(Items.rt, ModelTemplates.bx);
        this.a(Items.sb, ModelTemplates.bx);
        this.a(Items.nK, ModelTemplates.bx);
        this.a(Items.qX, ModelTemplates.bx);
        this.a(Items.qD, ModelTemplates.bx);
        this.a(Items.oo, ModelTemplates.bx);
        this.a(Items.rS, ModelTemplates.bx);
        this.a(Items.vn, ModelTemplates.bx);
        this.a(Items.vR, ModelTemplates.bx);
        this.a(Items.qN, ModelTemplates.bx);
        this.a(Items.qz, ModelTemplates.bx);
        this.a(Items.xh, ModelTemplates.bx);
        this.a(Items.vi, ModelTemplates.bx);
        this.a(Items.sj, ModelTemplates.bx);
        this.a(Items.nV, ModelTemplates.bx);
        this.a(Items.nW, ModelTemplates.bx);
        this.a(Items.qU, ModelTemplates.bx);
        this.a(Items.pm, ModelTemplates.bz);
        this.a(Items.oQ, ModelTemplates.bz);
        this.a(Items.oR, ModelTemplates.bz);
        this.a(Items.oP, ModelTemplates.bz);
        this.a(Items.oO, ModelTemplates.bz);
        this.a(Items.oN, ModelTemplates.bz);
        this.a(Items.rx, ModelTemplates.bx);
        this.a(Items.vN, ModelTemplates.bx);
        this.a(Items.nO, ModelTemplates.bx);
        this.a(Items.vm, ModelTemplates.bx);
        this.a(Items.vI, ModelTemplates.bx);
        this.a(Items.qY, ModelTemplates.bx);
        this.a(Items.qF, ModelTemplates.bx);
        this.a(Items.qG, ModelTemplates.bx);
        this.a(Items.qH, ModelTemplates.bx);
        this.a(Items.qw, ModelTemplates.bx);
        this.a(Items.pt, ModelTemplates.bx);
        this.a(Items.rf, ModelTemplates.bx);
        this.a(Items.oL, ModelTemplates.bz);
        this.a(Items.oM, ModelTemplates.bz);
        this.a(Items.oK, ModelTemplates.bz);
        this.a(Items.oJ, ModelTemplates.bz);
        this.a(Items.oI, ModelTemplates.bz);
        this.a(Items.tT, ModelTemplates.bx);
        this.a(Items.tU, ModelTemplates.bx);
        this.a(Items.rj, ModelTemplates.bx);
        this.a(Items.xj, ModelTemplates.bx);
        this.a(Items.xk, ModelTemplates.bx);
        this.a(Items.xl, ModelTemplates.bx);
        this.a(Items.xm, ModelTemplates.bx);
        this.a(Items.xn, ModelTemplates.bx);
        this.a(Items.xo, ModelTemplates.bx);
        this.a(Items.xp, ModelTemplates.bx);
        this.a(Items.xq, ModelTemplates.bx);
        this.a(Items.xr, ModelTemplates.bx);
        this.a(Items.xs, ModelTemplates.bx);
        this.a(Items.xt, ModelTemplates.bx);
        this.a(Items.xu, ModelTemplates.bx);
        this.a(Items.xv, ModelTemplates.bx);
        this.a(Items.xw, ModelTemplates.bx);
        this.a(Items.xx, ModelTemplates.bx);
        this.a(Items.xy, ModelTemplates.bx);
        this.a(Items.xz, ModelTemplates.bx);
        this.a(Items.vq, Items.pm, ModelTemplates.bz);
        this.a(Items.pY, Items.pX, ModelTemplates.bx);
        for (Item item : BuiltInRegistries.h) {
            if (!(item instanceof ItemArmor)) continue;
            ItemArmor armorItem = (ItemArmor)item;
            this.a(armorItem);
        }
        this.a(Items.xA, ModelTemplates.bx);
        this.a(Items.xB, ModelTemplates.bx);
        this.a(Items.xC, ModelTemplates.bx);
        this.a(Items.xD, ModelTemplates.bx);
        this.a(Items.xE, ModelTemplates.bx);
        this.a(Items.xF, ModelTemplates.bx);
        this.a(Items.xG, ModelTemplates.bx);
        this.a(Items.xH, ModelTemplates.bx);
        this.a(Items.xI, ModelTemplates.bx);
        this.a(Items.xJ, ModelTemplates.bx);
        this.a(Items.xK, ModelTemplates.bx);
        this.a(Items.xL, ModelTemplates.bx);
        this.a(Items.xM, ModelTemplates.bx);
        this.a(Items.xN, ModelTemplates.bx);
        this.a(Items.xO, ModelTemplates.bx);
        this.a(Items.xP, ModelTemplates.bx);
        this.a(Items.xQ, ModelTemplates.bx);
        this.a(Items.xR, ModelTemplates.bx);
        this.a(Items.xS, ModelTemplates.bx);
        this.a(Items.xT, ModelTemplates.bx);
        this.a(Items.yl, ModelTemplates.bx);
    }

    record a(String a, float b, Map<ArmorMaterial, String> c) {
        public String a(ArmorMaterial armorMaterial) {
            return this.c.getOrDefault(armorMaterial, this.a);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this, object);
        }
    }
}

