/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.IMaterial;

public class ShapedRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory b;
    private final Item c;
    private final int d;
    private final List<String> e = Lists.newArrayList();
    private final Map<Character, RecipeItemStack> f = Maps.newLinkedHashMap();
    private final Map<String, Criterion<?>> g = new LinkedHashMap();
    @Nullable
    private String h;
    private boolean i = true;

    public ShapedRecipeBuilder(RecipeCategory category, IMaterial output, int count) {
        this.b = category;
        this.c = output.k();
        this.d = count;
    }

    public static ShapedRecipeBuilder a(RecipeCategory category, IMaterial output) {
        return ShapedRecipeBuilder.a(category, output, 1);
    }

    public static ShapedRecipeBuilder a(RecipeCategory category, IMaterial output, int count) {
        return new ShapedRecipeBuilder(category, output, count);
    }

    public ShapedRecipeBuilder a(Character c2, TagKey<Item> tag) {
        return this.a(c2, RecipeItemStack.a(tag));
    }

    public ShapedRecipeBuilder a(Character c2, IMaterial itemProvider) {
        return this.a(c2, RecipeItemStack.a(itemProvider));
    }

    public ShapedRecipeBuilder a(Character c2, RecipeItemStack ingredient) {
        if (this.f.containsKey(c2)) {
            throw new IllegalArgumentException("Symbol '" + c2 + "' is already defined!");
        }
        if (c2.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.f.put(c2, ingredient);
        return this;
    }

    public ShapedRecipeBuilder b(String patternStr) {
        if (!this.e.isEmpty() && patternStr.length() != this.e.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.e.add(patternStr);
        return this;
    }

    @Override
    public ShapedRecipeBuilder b(String string, Criterion<?> criterion) {
        this.g.put(string, criterion);
        return this;
    }

    @Override
    public ShapedRecipeBuilder c(@Nullable String string) {
        this.h = string;
        return this;
    }

    public ShapedRecipeBuilder a(boolean showNotification) {
        this.i = showNotification;
        return this;
    }

    @Override
    @Override
    public Item a() {
        return this.c;
    }

    @Override
    @Override
    public void a(RecipeOutput exporter, MinecraftKey recipeId) {
        ShapedRecipePattern shapedRecipePattern = this.a(recipeId);
        Advancement.SerializedAdvancement builder = exporter.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(recipeId)).a(AdvancementRewards.a.c(recipeId)).a(AdvancementRequirements.a.b);
        this.g.forEach(builder::a);
        ShapedRecipes shapedRecipe = new ShapedRecipes(Objects.requireNonNullElse(this.h, ""), RecipeBuilder.a(this.b), shapedRecipePattern, new ItemStack(this.c, this.d), this.i);
        exporter.a(recipeId, shapedRecipe, builder.b(recipeId.d("recipes/" + this.b.a() + "/")));
    }

    private ShapedRecipePattern a(MinecraftKey recipeId) {
        if (this.g.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
        return ShapedRecipePattern.a(this.f, this.e);
    }

    @Override
    public /* synthetic */ RecipeBuilder a(@Nullable String group) {
        return this.c(group);
    }

    public /* synthetic */ RecipeBuilder a(String name, Criterion criterion) {
        return this.b(name, criterion);
    }
}

